/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine.grid.thermal;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import resonant.engine.grid.thermal.FluidThermal;
import resonant.lib.science.ChemElement;
import resonant.lib.transform.vector.Vector3;

public class ThermalPhysics {
    public static final ThermalPhysics INSTNACE = new ThermalPhysics();
    public static final int ROOM_TEMPERATURE = 295;
    public final HashMap<Vector3, Integer> thermalMap = new HashMap();

    public static float getTemperatureForCoordinate(World world, int x, int z) {
        int averageTemperature = 273 + (int)(((double)world.func_72807_a(x, z).func_150564_a(x, 0, z) - 0.4) * 50.0);
        double dayNightVariance = (double)averageTemperature * 0.05;
        return (float)((double)averageTemperature + (world.func_72935_r() ? dayNightVariance : -dayNightVariance));
    }

    public static double getEnergyForTemperatureChange(float mass, double specificHeatCapacity, float temperature) {
        return (double)mass * specificHeatCapacity * (double)temperature;
    }

    public static float getTemperatureForEnergy(float mass, long specificHeatCapacity, long energy) {
        return (float)energy / (mass * (float)specificHeatCapacity);
    }

    public static double getRequiredBoilWaterEnergy(World world, int x, int z) {
        return ThermalPhysics.getRequiredBoilWaterEnergy(world, x, z, 1000);
    }

    public static double getRequiredBoilWaterEnergy(World world, int x, int z, int volume) {
        float temperatureChange = 373.0f - ThermalPhysics.getTemperatureForCoordinate(world, x, z);
        float mass = ThermalPhysics.getMass(volume, 1.0f);
        return ThermalPhysics.getEnergyForTemperatureChange(mass, 4200.0, temperatureChange) + ThermalPhysics.getEnergyForStateChange(mass, 2257000.0);
    }

    public static double getEnergyForStateChange(float mass, double latentHeatCapacity) {
        return (double)mass * latentHeatCapacity;
    }

    public static float getMass(float volume, float density) {
        return volume / 1000.0f * density;
    }

    public static int getMass(FluidStack fluidStack) {
        return fluidStack.amount / 1000 * fluidStack.getFluid().getDensity(fluidStack);
    }

    public void update() {
        for (Map.Entry<Vector3, Integer> entry : this.thermalMap.entrySet()) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Vector3 checkPos = entry.getKey().clone().$plus(dir);
                int neighbourTemp = this.getTemperature(checkPos);
                entry.setValue((entry.getValue() + neighbourTemp) / 2);
            }
        }
    }

    public int addEnergyToFluid(FluidStack fluidStack, int specificHeatCapacity, long energy) {
        int mass = fluidStack.amount / 1000 * fluidStack.getFluid().getDensity(fluidStack);
        int changeInTemperature = (int)(energy / (long)(mass * specificHeatCapacity));
        if (fluidStack.getFluid() instanceof FluidThermal) {
            ((FluidThermal)fluidStack.getFluid()).setTemperature(fluidStack, fluidStack.getFluid().getTemperature(fluidStack) + changeInTemperature);
        }
        return changeInTemperature;
    }

    public void addEnergy(Vector3 position, ChemElement element, long energy) {
        int mass = (int)(1.0f * element.density);
        int changeInTemperature = (int)((float)energy / ((float)mass * element.heatData.specificHeat));
        this.setTemperature(position, this.getTemperature(position) + changeInTemperature);
    }

    public void setTemperature(Vector3 position, int temperature) {
        this.thermalMap.put(position, temperature);
    }

    public int getTemperature(Vector3 position) {
        if (this.thermalMap.containsKey(position)) {
            return this.thermalMap.get(position);
        }
        return 295;
    }
}

