/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.access.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import resonant.lib.access.java.AccessGroup;
import resonant.lib.access.java.AccessProfile;
import resonant.lib.access.java.AccessUser;
import resonant.lib.access.java.IProfileContainer;
import resonant.lib.access.java.Permission;
import resonant.lib.access.java.Permissions;

public class AccessUtility {
    public static final Set<Permission> permissions = new LinkedHashSet<Permission>();
    public static final HashMap<String, List<String>> groupDefaultNodes = new LinkedHashMap<String, List<String>>();
    public static final HashMap<String, String> groupDefaultExtends = new LinkedHashMap<String, String>();

    public static void createDefaultGroup(String name, String prefabGroup, List<String> nodes) {
        if (name != null) {
            groupDefaultNodes.put(name, nodes);
            groupDefaultExtends.put(name, prefabGroup);
        }
    }

    public static void createDefaultGroup(String name, String prefabGroup, String ... nodes) {
        AccessUtility.createDefaultGroup(name, prefabGroup, nodes != null ? Arrays.asList(nodes) : null);
    }

    public static void registerPermission(String node, String group) {
        AccessUtility.registerPermission(new Permission(node), group);
    }

    public static void registerPermission(Permission perm, String group) {
        List<String> perms;
        if (!permissions.contains(perm)) {
            permissions.add(perm);
        }
        if (group != null && !group.isEmpty() && groupDefaultNodes.containsKey(group) && (perms = groupDefaultNodes.get(group)) != null && !perms.contains(perm.id)) {
            perms.add(perm.id);
        }
    }

    public static List<AccessGroup> buildNewGroup() {
        AccessGroup group;
        ArrayList<AccessGroup> groups = new ArrayList<AccessGroup>();
        for (Map.Entry<String, List<String>> entry : groupDefaultNodes.entrySet()) {
            group = new AccessGroup(entry.getKey(), new AccessUser[0]);
            if (entry.getValue() != null) {
                for (String string : entry.getValue()) {
                    group.addNode(string);
                }
            }
            groups.add(group);
        }
        for (Map.Entry<String, Object> entry : groupDefaultExtends.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            group = AccessUtility.getGroup(groups, entry.getKey());
            AccessGroup groupToExtend = AccessUtility.getGroup(groups, (String)entry.getValue());
            if (group == null || groupToExtend == null) continue;
            group.setToExtend(groupToExtend);
        }
        return groups;
    }

    public static void loadNewGroupSet(IProfileContainer container) {
        if (container != null) {
            AccessUtility.loadNewGroupSet(container.getAccessProfile());
        }
    }

    public static void loadNewGroupSet(AccessProfile profile) {
        if (profile != null) {
            List<AccessGroup> groups = AccessUtility.buildNewGroup();
            for (AccessGroup group : groups) {
                profile.addGroup(group);
            }
        }
    }

    public static AccessGroup getGroup(Collection<AccessGroup> groups, String name) {
        for (AccessGroup group : groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Permissions.PROFILE_OWNER.toString());
        list.add(Permissions.inventoryDisable.toString());
        list.add(Permissions.inventoryEnable.toString());
        list.add(Permissions.profile.toString());
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(Permissions.PROFILE_ADMIN.toString());
        list2.add(Permissions.inventoryModify.toString());
        list2.add(Permissions.inventoryLock.toString());
        list2.add(Permissions.inventoryUnlock.toString());
        list2.add(Permissions.inventoryModify.toString());
        list2.add(Permissions.group.toString());
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add(Permissions.PROFILE_USER.toString());
        list3.add(Permissions.inventoryOpen.toString());
        list3.add(Permissions.inventoryInput.toString());
        list3.add(Permissions.inventoryOutput.toString());
        AccessUtility.createDefaultGroup("user", null, list3);
        AccessUtility.createDefaultGroup("admin", "user", list2);
        AccessUtility.createDefaultGroup("owner", "admin", list);
    }
}

