/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.debug;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import resonant.api.grid.IUpdate;
import resonant.lib.debug.UpdatePanel;
import resonant.lib.debug.UpdatedLabel;
import resonant.lib.transform.vector.IVectorWorld;

public class FrameDebug
extends Frame
implements IVectorWorld {
    protected long tick = 0L;
    TileEntity tile = null;
    boolean debugNode = false;

    public FrameDebug(TileEntity tile) {
        this();
        this.tile = tile;
    }

    protected FrameDebug() {
        this.buildGUI();
    }

    protected void buildGUI() {
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        UpdatePanel topPanel = new UpdatePanel();
        UpdatePanel botPanel = new UpdatePanel();
        UpdatePanel rightPanel = new UpdatePanel();
        topPanel.setBorder(loweredetched);
        botPanel.setBorder(loweredetched);
        rightPanel.setBorder(loweredetched);
        this.buildTop(topPanel);
        this.buildBottom(botPanel);
        this.buildCenter(rightPanel);
        this.add((Component)topPanel, "North");
        this.add((Component)botPanel, "South");
        this.add((Component)rightPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame f = (Frame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
    }

    public void buildTop(UpdatePanel panel) {
        panel.setLayout(new GridLayout(1, 2, 0, 0));
        UpdatedLabel tickLabel = new UpdatedLabel("Tile: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + FrameDebug.this.tile;
            }
        };
        panel.add(tickLabel);
    }

    public void buildBottom(UpdatePanel panel) {
        panel.setLayout(new GridLayout(1, 4, 0, 0));
        UpdatedLabel tickLabel = new UpdatedLabel("Tick: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + FrameDebug.this.tick;
            }
        };
        panel.add(tickLabel);
        UpdatedLabel xLabel = new UpdatedLabel("X: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + FrameDebug.this.x();
            }
        };
        panel.add(xLabel);
        UpdatedLabel yLabel = new UpdatedLabel("Y: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + FrameDebug.this.y();
            }
        };
        panel.add(yLabel);
        UpdatedLabel zLabel = new UpdatedLabel("Z: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + FrameDebug.this.z();
            }
        };
        panel.add(zLabel);
    }

    public void buildCenter(UpdatePanel panel) {
        panel.setLayout(new GridLayout(1, 4, 0, 0));
        UpdatedLabel tickLabel = new UpdatedLabel("Valid: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + (FrameDebug.this.tile != null ? Boolean.valueOf(FrameDebug.this.tile.func_145837_r()) : "null");
            }
        };
        panel.add(tickLabel);
        UpdatedLabel block_label = new UpdatedLabel("BLOCK: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + (FrameDebug.this.tile != null ? FrameDebug.this.tile.func_145838_q() : "null");
            }
        };
        panel.add(block_label);
        UpdatedLabel meta_label = new UpdatedLabel("META: "){

            @Override
            public String buildLabel() {
                return super.buildLabel() + (FrameDebug.this.tile != null && FrameDebug.this.tile.func_145838_q() != null ? Integer.valueOf(FrameDebug.this.tile.func_145832_p()) : "-");
            }
        };
        panel.add(meta_label);
    }

    public void update() {
        ++this.tick;
        if (this.tick >= Long.MAX_VALUE) {
            this.tick = 0L;
        }
        for (Component component : this.getComponents()) {
            if (!(component instanceof IUpdate)) continue;
            ((IUpdate)((Object)component)).update(0.05);
        }
    }

    public void showDebugFrame() {
        this.setTitle("Resonant Engine Debug Window");
        this.setBounds(200, 200, 450, 600);
        this.setVisible(true);
    }

    public void closeDebugFrame() {
        this.dispose();
    }

    @Override
    public double z() {
        return this.tile != null ? (double)this.tile.field_145849_e : 0.0;
    }

    @Override
    public double x() {
        return this.tile != null ? (double)this.tile.field_145851_c : 0.0;
    }

    @Override
    public double y() {
        return this.tile != null ? (double)this.tile.field_145848_d : 0.0;
    }

    @Override
    public World world() {
        return this.tile != null ? this.tile.func_145831_w() : null;
    }
}

