/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.grid;

import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class Compatibility {
    public static final Set<CompatibilityModule> loadedModules = new LinkedHashSet<CompatibilityModule>();
    public static final HashMap<Class, CompatibilityModule> energyHandlerCache = new HashMap();
    public static final HashMap<Class, CompatibilityModule> energyStorageCache = new HashMap();

    public static void register(CompatibilityModule module) {
        loadedModules.add(module);
    }

    public static CompatibilityModule getHandler(Object handler, ForgeDirection dir) {
        if (Compatibility.isHandler(handler, dir)) {
            return energyHandlerCache.get(handler.getClass());
        }
        return null;
    }

    public static boolean isHandler(Object handler, ForgeDirection dir) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyHandlerCache.containsKey(clazz)) {
                return true;
            }
            for (CompatibilityModule module : loadedModules) {
                if (!module.doIsHandler(handler, dir)) continue;
                energyHandlerCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static CompatibilityModule getContainer(Object handler) {
        if (Compatibility.isEnergyContainer(handler)) {
            return energyStorageCache.get(handler.getClass());
        }
        return null;
    }

    public static boolean isEnergyContainer(Object handler) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyStorageCache.containsKey(clazz)) {
                return true;
            }
            for (CompatibilityModule module : loadedModules) {
                if (!module.doIsEnergyContainer(handler)) continue;
                energyStorageCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        CompatibilityModule module = Compatibility.getHandler(obj, direction);
        if (module != null) {
            return module.canConnect(obj, direction, source);
        }
        return false;
    }

    public static double fill(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        return Compatibility.receiveEnergy(handler, direction, energy, doReceive);
    }

    public static double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        CompatibilityModule module = Compatibility.getHandler(handler, direction);
        if (module != null) {
            return module.receiveEnergy(handler, direction, energy, doReceive);
        }
        return 0.0;
    }

    public static double drain(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        return Compatibility.extractEnergy(handler, direction, energy, doExtract);
    }

    public static double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        CompatibilityModule module = Compatibility.getHandler(handler, direction);
        if (module != null) {
            return module.extractEnergy(handler, direction, energy, doExtract);
        }
        return 0.0;
    }

    public static double fill(ItemStack itemStack, double joules, boolean doCharge) {
        return Compatibility.chargeItem(itemStack, joules, doCharge);
    }

    public static double chargeItem(ItemStack itemStack, double joules, boolean doCharge) {
        CompatibilityModule module = Compatibility.getHandler(itemStack, null);
        if (module != null) {
            return module.chargeItem(itemStack, joules, doCharge);
        }
        return 0.0;
    }

    public static double drain(ItemStack itemStack, double joules, boolean doDischarge) {
        return Compatibility.dischargeItem(itemStack, joules, doDischarge);
    }

    public static double dischargeItem(ItemStack itemStack, double joules, boolean doDischarge) {
        CompatibilityModule module = Compatibility.getHandler(itemStack, null);
        if (module != null) {
            return module.dischargeItem(itemStack, joules, doDischarge);
        }
        return 0.0;
    }

    public static ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        CompatibilityModule module = Compatibility.getHandler(itemStack, null);
        if (module != null) {
            return module.getItemWithCharge(itemStack, energy);
        }
        return itemStack;
    }

    public static double getEnergy(Object obj, ForgeDirection direction) {
        CompatibilityModule module = Compatibility.getHandler(obj, direction);
        if (module != null) {
            return module.getEnergy(obj, direction);
        }
        return 0.0;
    }

    public static double getMaxEnergy(Object handler, ForgeDirection direction) {
        CompatibilityModule module = Compatibility.getHandler(handler, direction);
        if (module != null) {
            return module.getMaxEnergy(handler, direction);
        }
        return 0.0;
    }

    public static double getEnergyItem(ItemStack is) {
        CompatibilityModule module = Compatibility.getHandler(is, null);
        if (module != null) {
            return module.getEnergyItem(is);
        }
        return 0.0;
    }

    public static double getMaxEnergyItem(ItemStack is) {
        CompatibilityModule module = Compatibility.getHandler(is, null);
        if (module != null) {
            return module.getMaxEnergyItem(is);
        }
        return 0.0;
    }

    public static abstract class CompatibilityModule {
        public final String modID;
        public final String moduleName;
        public final String fullUnit;
        public final String unit;
        public double ratio;
        public double reciprocal_ratio;
        public boolean isEnabled;

        public CompatibilityModule(String modID, String moduleName, String fullUnit, String unit, int ratio) {
            this.modID = modID;
            this.moduleName = moduleName;
            this.fullUnit = fullUnit;
            this.unit = unit;
            this.ratio = 1.0 / (double)ratio;
            this.reciprocal_ratio = ratio;
        }

        public boolean isLoaded() {
            return Loader.isModLoaded((String)this.modID);
        }

        public abstract double receiveEnergy(Object var1, ForgeDirection var2, double var3, boolean var5);

        public abstract double extractEnergy(Object var1, ForgeDirection var2, double var3, boolean var5);

        public abstract double chargeItem(ItemStack var1, double var2, boolean var4);

        public abstract double dischargeItem(ItemStack var1, double var2, boolean var4);

        public abstract boolean doIsHandler(Object var1, ForgeDirection var2);

        public abstract boolean doIsEnergyContainer(Object var1);

        public abstract boolean canConnect(Object var1, ForgeDirection var2, Object var3);

        public abstract ItemStack getItemWithCharge(ItemStack var1, double var2);

        public abstract double getEnergy(Object var1, ForgeDirection var2);

        public abstract double getMaxEnergy(Object var1, ForgeDirection var2);

        public abstract double getEnergyItem(ItemStack var1);

        public abstract double getMaxEnergyItem(ItemStack var1);
    }
}

