/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.multiblock.reference;

import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import resonant.lib.multiblock.reference.IMultiBlockStructure;
import resonant.lib.transform.vector.Vector3;
import resonant.lib.utility.nbt.ISaveObj;

public class MultiBlockHandler<W extends IMultiBlockStructure>
implements ISaveObj {
    protected final W tile;
    protected WeakReference<W> prim = null;
    protected Vector3 newPrimary = null;
    protected Class<? extends W> wrapperClass;

    public MultiBlockHandler(W wrapper) {
        this.tile = wrapper;
        this.wrapperClass = wrapper.getClass();
    }

    public void update() {
        W checkWrapper;
        if (this.tile.getWorld() != null && this.newPrimary != null && (checkWrapper = this.getWrapperAt(this.newPrimary.clone().add(this.tile.getPosition()))) != null) {
            this.newPrimary = null;
            if (checkWrapper != this.getPrimary()) {
                this.prim = new WeakReference<W>(checkWrapper);
                this.tile.onMultiBlockChanged();
            }
        }
    }

    public boolean toggleConstruct() {
        if (this.isConstructed()) {
            return this.deconstruct();
        }
        return this.construct();
    }

    public Set<W> getStructure() {
        LinkedHashSet<W> structure = new LinkedHashSet<W>();
        Iterable<Vector3> vectors = this.tile.getMultiBlockVectors();
        for (Vector3 vector : vectors) {
            W checkWrapper = this.getWrapperAt(vector.add(this.tile.getPosition()));
            if (checkWrapper != null) {
                structure.add(checkWrapper);
                continue;
            }
            structure.clear();
            return null;
        }
        return structure;
    }

    public boolean construct() {
        Set<W> structures;
        if (!this.isConstructed() && (structures = this.getStructure()) != null) {
            for (IMultiBlockStructure structure : structures) {
                if (!structure.getMultiBlock().isConstructed()) continue;
                return false;
            }
            this.prim = new WeakReference<W>(this.tile);
            for (IMultiBlockStructure structure : structures) {
                structure.getMultiBlock().prim = this.prim;
            }
            for (IMultiBlockStructure structure : structures) {
                structure.onMultiBlockChanged();
            }
            return true;
        }
        return false;
    }

    public boolean deconstruct() {
        if (this.isConstructed()) {
            if (this.isPrimary()) {
                Set<W> structures = this.getStructure();
                if (structures != null) {
                    for (IMultiBlockStructure structure : structures) {
                        structure.getMultiBlock().prim = null;
                    }
                    for (IMultiBlockStructure structure : structures) {
                        structure.onMultiBlockChanged();
                    }
                }
            } else {
                this.getPrimary().getMultiBlock().deconstruct();
            }
            return true;
        }
        return false;
    }

    public W getWrapperAt(Vector3 position) {
        TileEntity tile = position.getTileEntity((IBlockAccess)this.tile.getWorld());
        if (tile != null && this.wrapperClass.isAssignableFrom(tile.getClass())) {
            return (W)((IMultiBlockStructure)tile);
        }
        return null;
    }

    public boolean isConstructed() {
        return this.prim != null;
    }

    public boolean isPrimary() {
        return !this.isConstructed() || this.getPrimary() == this.tile;
    }

    public W getPrimary() {
        return (W)(this.prim == null ? null : (IMultiBlockStructure)this.prim.get());
    }

    public W get() {
        return this.getPrimary() != null ? this.getPrimary() : this.tile;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("primaryMultiBlock")) {
            this.newPrimary = new Vector3(nbt.func_74775_l("primaryMultiBlock"));
            this.update();
        } else {
            this.prim = null;
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        if (this.isConstructed()) {
            nbt.func_74782_a("primaryMultiBlock", (NBTBase)this.getPrimary().getPosition().subtract(this.tile.getPosition()).toNBT());
        }
    }
}

