/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.ore;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import resonant.lib.ore.OreGenerator;

public class OreGenReplace
extends OreGenerator {
    public int minGenerateLevel;
    public int maxGenerateLevel;
    public int amountPerChunk;
    public int amountPerBranch;
    public Block replaceBlock;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;

    public OreGenReplace(String name, ItemStack stack, Block replaceBlock, int minGenerateLevel, int maxGenerateLevel, int amountPerChunk, int amountPerBranch, String harvestTool, int harvestLevel) {
        super(name, stack, harvestTool, harvestLevel);
        this.minGenerateLevel = minGenerateLevel;
        this.maxGenerateLevel = maxGenerateLevel;
        this.amountPerChunk = amountPerChunk;
        this.amountPerBranch = amountPerBranch;
        this.replaceBlock = replaceBlock;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        try {
            for (int i = 0; i < this.amountPerChunk; ++i) {
                int x = varX + random.nextInt(16);
                int z = varZ + random.nextInt(16);
                int y = random.nextInt(Math.max(this.maxGenerateLevel - this.minGenerateLevel, 0)) + this.minGenerateLevel;
                this.generateReplace(world, random, x, y, z);
            }
        }
        catch (Exception e) {
            System.out.println("Error generating ore: " + this.name);
            e.printStackTrace();
        }
    }

    public boolean generateReplace(World par1World, Random par2Random, int par3, int par4, int par5) {
        float var6 = par2Random.nextFloat() * (float)Math.PI;
        double var7 = (float)(par3 + 8) + MathHelper.func_76126_a((float)var6) * (float)this.amountPerBranch / 8.0f;
        double var9 = (float)(par3 + 8) - MathHelper.func_76126_a((float)var6) * (float)this.amountPerBranch / 8.0f;
        double var11 = (float)(par5 + 8) + MathHelper.func_76134_b((float)var6) * (float)this.amountPerBranch / 8.0f;
        double var13 = (float)(par5 + 8) - MathHelper.func_76134_b((float)var6) * (float)this.amountPerBranch / 8.0f;
        double var15 = par4 + par2Random.nextInt(3) - 2;
        double var17 = par4 + par2Random.nextInt(3) - 2;
        for (int var19 = 0; var19 <= this.amountPerBranch; ++var19) {
            double var20 = var7 + (var9 - var7) * (double)var19 / (double)this.amountPerBranch;
            double var22 = var15 + (var17 - var15) * (double)var19 / (double)this.amountPerBranch;
            double var24 = var11 + (var13 - var11) * (double)var19 / (double)this.amountPerBranch;
            double var26 = par2Random.nextDouble() * (double)this.amountPerBranch / 16.0;
            double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.amountPerBranch)) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)this.amountPerBranch)) + 1.0f) * var26 + 1.0;
            int var32 = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
            int var33 = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
            int var34 = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
            int var35 = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
            int var36 = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
            int var37 = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
            for (int var38 = var32; var38 <= var35; ++var38) {
                double var39 = ((double)var38 + 0.5 - var20) / (var28 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int var41 = var33; var41 <= var36; ++var41) {
                    double var42 = ((double)var41 + 0.5 - var22) / (var30 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int var44 = var34; var44 <= var37; ++var44) {
                        double var45 = ((double)var44 + 0.5 - var24) / (var28 / 2.0);
                        Block block = par1World.func_147439_a(var38, var41, var44);
                        if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || this.replaceBlock != Blocks.field_150350_a && block != this.replaceBlock) continue;
                        par1World.func_147465_d(var38, var41, var44, this.oreBlock, this.oreMeta, 2);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkProvider chunkGenerator) {
        if (!this.shouldGenerate) {
            return false;
        }
        if (this.ignoreSurface && chunkGenerator instanceof ChunkProviderGenerate) {
            return false;
        }
        if (this.ignoreNether && chunkGenerator instanceof ChunkProviderHell) {
            return false;
        }
        return !this.ignoreEnd || !(chunkGenerator instanceof ChunkProviderEnd);
    }
}

