/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.path;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.lib.path.IPathCallBack;
import resonant.lib.path.Pathfinder;
import resonant.lib.transform.vector.Vector3;

public class PathfinderAStar
extends Pathfinder {
    public Set<Vector3> openSet;
    public HashMap<Vector3, Vector3> navigationMap;
    public HashMap<Vector3, Double> gScore;
    public HashMap<Vector3, Double> fScore;
    public Vector3 goal;

    public PathfinderAStar(IPathCallBack callBack, Vector3 goal) {
        super(callBack);
        this.goal = goal;
    }

    @Override
    public boolean findNodes(Vector3 start) {
        this.reset();
        this.openSet.add(start);
        this.gScore.put(start, 0.0);
        this.fScore.put(start, this.gScore.get(start) + this.getHeuristicEstimatedCost(start, this.goal));
        while (!this.openSet.isEmpty()) {
            Vector3 currentNode = null;
            double lowestFScore = 0.0;
            for (Vector3 node : this.openSet) {
                if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                currentNode = node;
                lowestFScore = this.fScore.get(node);
            }
            if (currentNode == null) break;
            if (this.callBackCheck.onSearch(this, start, currentNode)) {
                return false;
            }
            if (currentNode.equals(this.goal)) {
                this.results = this.reconstructPath(this.navigationMap, this.goal);
                return true;
            }
            this.openSet.remove(currentNode);
            this.closedSet.add(currentNode);
            for (Vector3 neighbor : this.getNeighborNodes(currentNode)) {
                double tentativeGScore = this.gScore.get(currentNode) + currentNode.distance(neighbor);
                if (this.closedSet.contains(neighbor) && tentativeGScore >= this.gScore.get(neighbor) || this.openSet.contains(neighbor) && !(tentativeGScore < this.gScore.get(neighbor))) continue;
                this.navigationMap.put(neighbor, currentNode);
                this.gScore.put(neighbor, tentativeGScore);
                this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getHeuristicEstimatedCost(neighbor, this.goal));
                this.openSet.add(neighbor);
            }
        }
        return false;
    }

    @Override
    public Pathfinder reset() {
        this.openSet = new HashSet<Vector3>();
        this.navigationMap = new HashMap();
        this.gScore = new HashMap();
        this.fScore = new HashMap();
        return super.reset();
    }

    public List<Vector3> reconstructPath(HashMap<Vector3, Vector3> nagivationMap, Vector3 current_node) {
        LinkedList<Vector3> path = new LinkedList<Vector3>();
        path.add(current_node);
        if (nagivationMap.containsKey(current_node)) {
            path.addAll(this.reconstructPath(nagivationMap, nagivationMap.get(current_node)));
            return path;
        }
        return path;
    }

    public double getHeuristicEstimatedCost(Vector3 start, Vector3 goal) {
        return start.distance(goal);
    }

    public Set<Vector3> getNeighborNodes(Vector3 vector) {
        if (this.callBackCheck != null) {
            return this.callBackCheck.getConnectedNodes(this, vector);
        }
        HashSet<Vector3> neighbors = new HashSet<Vector3>();
        for (int i = 0; i < 6; ++i) {
            neighbors.add(vector.clone().add(ForgeDirection.getOrientation((int)i)));
        }
        return neighbors;
    }
}

