/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.block;

import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import resonant.lib.transform.vector.Vector3;
import resonant.lib.utility.WrenchUtility;
import resonant.lib.utility.inventory.InventoryUtility;

public abstract class BlockAdvanced
extends Block {
    protected BlockAdvanced(Material material) {
        super(material);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (WrenchUtility.isUsableWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z)) {
            WrenchUtility.damageWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z);
            if (entityPlayer.func_70093_af() && this.onSneakUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
            return this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        if (entityPlayer.func_70093_af() && this.onSneakMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
            return true;
        }
        return this.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean interactCurrentItem(IInventory inventory, int slotID, EntityPlayer player) {
        ItemStack stackInInventory = inventory.func_70301_a(slotID);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && (stackInInventory == null || stackInInventory.func_77969_a(current))) {
            return this.insertCurrentItem(inventory, slotID, player);
        }
        return this.extractItem(inventory, slotID, player);
    }

    public boolean insertCurrentItem(IInventory inventory, int slotID, EntityPlayer player) {
        ItemStack stackInInventory = inventory.func_70301_a(slotID);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && (stackInInventory == null || stackInInventory.func_77969_a(current)) && inventory.func_94041_b(slotID, current)) {
            if (this.isControlDown(player)) {
                if (stackInInventory == null) {
                    inventory.func_70299_a(slotID, current.func_77979_a(1));
                } else {
                    ++stackInInventory.field_77994_a;
                    --current.field_77994_a;
                }
            } else {
                if (stackInInventory == null) {
                    inventory.func_70299_a(slotID, current);
                } else {
                    stackInInventory.field_77994_a += current.field_77994_a;
                    current.field_77994_a = 0;
                }
                current = null;
            }
            if (current == null || current.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        return false;
    }

    public boolean extractItem(IInventory inventory, int slotID, EntityPlayer player) {
        ItemStack stackInInventory = inventory.func_70301_a(slotID);
        if (stackInInventory != null) {
            if (this.isControlDown(player)) {
                InventoryUtility.dropItemStack(player.field_70170_p, new Vector3((Entity)player), stackInInventory.func_77979_a(1), 0);
            } else {
                InventoryUtility.dropItemStack(player.field_70170_p, new Vector3((Entity)player), stackInInventory, 0);
                stackInInventory = null;
            }
            if (stackInInventory == null || stackInInventory.field_77994_a <= 0) {
                inventory.func_70299_a(slotID, null);
            }
            return true;
        }
        return false;
    }

    public boolean isControlDown(EntityPlayer player) {
        try {
            Class<?> ckm = Class.forName("codechicken.multipart.ControlKeyModifer");
            Method m = ckm.getMethod("isControlDown", EntityPlayer.class);
            return (Boolean)m.invoke(null, player);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

