/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import resonant.api.items.IEnergyItem;
import resonant.lib.grid.Compatibility;
import resonant.lib.science.UnitDisplay;

public abstract class ItemElectric
extends Item
implements IEnergyItem {
    private static final String ENERGY_NBT = "electricity";

    public ItemElectric() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        double joules = this.getEnergy(itemStack);
        color = joules <= this.getEnergyCapacity(itemStack) / 3.0 ? "\u00a74" : (joules > this.getEnergyCapacity(itemStack) * 2.0 / 3.0 ? "\u00a72" : "\u00a76");
        list.add(color + new UnitDisplay(UnitDisplay.Unit.JOULES, joules) + "/" + new UnitDisplay(UnitDisplay.Unit.JOULES, this.getEnergyCapacity(itemStack)).symbol());
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setEnergy(itemStack, 0.0);
    }

    @Override
    public double recharge(ItemStack itemStack, double energy, boolean doReceive) {
        double energyReceived = Math.min(this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack), Math.min(this.getTransferRate(itemStack), energy));
        if (doReceive) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyReceived);
        }
        return energyReceived;
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) / 100.0;
    }

    @Override
    public double discharge(ItemStack itemStack, double energy, boolean doTransfer) {
        double energyExtracted = Math.min(this.getEnergy(itemStack), Math.min(this.getTransferRate(itemStack), energy));
        if (doTransfer) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public double getVoltage(ItemStack itemStack) {
        return 120.0;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(joules, this.getEnergyCapacity(itemStack)), 0.0);
        itemStack.func_77978_p().func_74780_a(ENERGY_NBT, electricityStored);
        itemStack.func_77964_b((int)(100.0 - electricityStored / this.getEnergyCapacity(itemStack) * 100.0));
    }

    public double getTransfer(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack);
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double energyStored = itemStack.func_77978_p().func_74769_h(ENERGY_NBT);
        itemStack.func_77964_b((int)(100.0 - energyStored / this.getEnergyCapacity(itemStack) * 100.0));
        return energyStored;
    }

    public void func_150895_a(Item id, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(Compatibility.getHandler(this, null).getItemWithCharge(new ItemStack((Item)this), 0.0));
        par3List.add(Compatibility.getHandler(this, null).getItemWithCharge(new ItemStack((Item)this), this.getEnergyCapacity(new ItemStack((Item)this))));
    }
}

