/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.poison;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.api.armor.IAntiPoisonArmor;
import resonant.api.blocks.IAntiPoisonBlock;
import resonant.engine.References;
import resonant.lib.transform.vector.Vector3;

public abstract class Poison {
    static HashMap<String, Poison> poisons = new HashMap();
    static BiMap<String, Integer> poisonIDs = HashBiMap.create();
    private static int maxID = 0;
    protected final boolean isDisabled;
    protected String name;
    protected EnumSet<ArmorType> armorRequired = EnumSet.range(ArmorType.HELM, ArmorType.BOOTS);

    public Poison(String name) {
        this.name = name;
        poisons.put(name, this);
        poisonIDs.put((Object)name, (Object)(++maxID));
        this.isDisabled = References.CONFIGURATION.get("Disable Poison", "Disable " + this.name, false).getBoolean(false);
    }

    public static Poison getPoison(String name) {
        return poisons.get(name);
    }

    public static Poison getPoison(int id) {
        return poisons.get(Poison.getName(id));
    }

    public static String getName(int fluidID) {
        return (String)poisonIDs.inverse().get((Object)fluidID);
    }

    public static int getID(String name) {
        return (Integer)poisonIDs.get((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public final int getID() {
        return Poison.getID(this.getName());
    }

    public EnumSet<ArmorType> getArmorRequired() {
        return this.armorRequired;
    }

    public void poisonEntity(Vector3 emitPosition, EntityLivingBase entity, int amplifier) {
        if (!this.isEntityProtected(emitPosition, entity, amplifier)) {
            this.doPoisonEntity(emitPosition, entity, amplifier);
        }
    }

    public void poisonEntity(Vector3 emitPosition, EntityLivingBase entity) {
        this.poisonEntity(emitPosition, entity, 0);
    }

    public boolean isEntityProtected(Vector3 emitPosition, EntityLivingBase entity, int amplifier) {
        EnumSet<ArmorType> armorWorn = EnumSet.noneOf(ArmorType.class);
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            for (int i = 0; i < entityPlayer.field_71071_by.field_70460_b.length; ++i) {
                IAntiPoisonArmor armor;
                if (entityPlayer.field_71071_by.field_70460_b[i] == null || !(entityPlayer.field_71071_by.field_70460_b[i].func_77973_b() instanceof IAntiPoisonArmor) || !(armor = (IAntiPoisonArmor)entityPlayer.field_71071_by.field_70460_b[i].func_77973_b()).isProtectedFromPoison(entityPlayer.field_71071_by.field_70460_b[i], entity, this.getName())) continue;
                armorWorn.add(ArmorType.values()[armor.getArmorType() % ArmorType.values().length]);
                armor.onProtectFromPoison(entityPlayer.field_71071_by.field_70460_b[i], entity, this.getName());
            }
        }
        return armorWorn.containsAll(this.armorRequired);
    }

    public int getAntiPoisonBlockCount(World world, Vector3 startingPosition, Vector3 endingPosition) {
        Vector3 delta = (Vector3)endingPosition.clone().subtract(startingPosition).normalize();
        Vector3 targetPosition = startingPosition.clone();
        double totalDistance = startingPosition.distance(endingPosition);
        int count = 0;
        if (totalDistance > 1.0) {
            while (targetPosition.distance(endingPosition) <= totalDistance) {
                Block block = targetPosition.getBlock((IBlockAccess)world);
                if (block instanceof IAntiPoisonBlock && ((IAntiPoisonBlock)block).isPoisonPrevention(world, targetPosition.xi(), targetPosition.yi(), targetPosition.zi(), this.getName())) {
                    ++count;
                }
                targetPosition.add(delta);
            }
        }
        return count;
    }

    protected abstract void doPoisonEntity(Vector3 var1, EntityLivingBase var2, int var3);

    public static enum ArmorType {
        HELM,
        BODY,
        LEGGINGS,
        BOOTS;

    }
}

