/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.recipe;

import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class UniversalRecipe {
    public static final ArrayList<UniversalRecipe> RECIPES = new ArrayList();
    public static final UniversalRecipe PRIMARY_METAL = new UniversalRecipe("ingotSteel", "plateiron", new ItemStack(Items.field_151042_j));
    public static final UniversalRecipe PRIMARY_PLATE;
    public static final UniversalRecipe SECONDARY_METAL;
    public static final UniversalRecipe SECONDARY_PLATE;
    public static final UniversalRecipe CIRCUIT_T1;
    public static final UniversalRecipe CIRCUIT_T2;
    public static final UniversalRecipe CIRCUIT_T3;
    public static final UniversalRecipe BATTERY;
    public static final UniversalRecipe ADVANCED_BATTERY;
    public static final UniversalRecipe BATTERY_BOX;
    public static final UniversalRecipe WRENCH;
    public static final UniversalRecipe WIRE;
    public static final UniversalRecipe MOTOR;
    public static final UniversalRecipe RUBBER;
    private final ArrayList alternatives = new ArrayList();
    private final Object[] originalRecipes;
    public String defaultRecipe;
    private boolean didGenerate = false;

    public UniversalRecipe(String defaultRecipe, Object ... alternativeRecipes) {
        this.defaultRecipe = defaultRecipe;
        this.originalRecipes = alternativeRecipes;
        RECIPES.add(this);
    }

    public static boolean recipeExists(List<ItemStack> itemStacks) {
        if (itemStacks != null && itemStacks.size() > 0) {
            for (ItemStack stack : itemStacks) {
                if (stack != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean recipeExists(ItemStack ... itemStacks) {
        return UniversalRecipe.recipeExists(Arrays.asList(itemStacks));
    }

    public static boolean recipeExists(String stackName) {
        return UniversalRecipe.recipeExists(OreDictionary.getOres((String)stackName));
    }

    public void generate() {
        if (UniversalRecipe.recipeExists(this.defaultRecipe)) {
            this.alternatives.add(this.defaultRecipe);
        }
        for (Object alternative : this.originalRecipes) {
            if (alternative instanceof ItemStack) {
                if (!UniversalRecipe.recipeExists((ItemStack)alternative)) continue;
                this.alternatives.add(alternative);
                continue;
            }
            if (!(alternative instanceof String) || !UniversalRecipe.recipeExists((String)alternative)) continue;
            this.alternatives.add(alternative);
        }
        this.didGenerate = true;
    }

    public Object get(boolean allowAlternatives) {
        if (!this.didGenerate) {
            this.generate();
        }
        if (allowAlternatives) {
            return this.alternatives.get(0);
        }
        return UniversalRecipe.recipeExists(this.defaultRecipe) ? this.defaultRecipe : this.alternatives.get(this.alternatives.size() - 1);
    }

    public Object get() {
        return this.get(true);
    }

    static {
        SECONDARY_METAL = new UniversalRecipe("ingotBronze", new ItemStack(Items.field_151118_aC));
        PRIMARY_PLATE = new UniversalRecipe("plateSteel", IC2Items.getItem("advancedAlloy"), new ItemStack(Blocks.field_150339_S));
        SECONDARY_PLATE = new UniversalRecipe("plateBronze", IC2Items.getItem("carbonPlate"), new ItemStack(Blocks.field_150336_V));
        CIRCUIT_T1 = new UniversalRecipe("circuitBasic", IC2Items.getItem("electronicCircuit"), new ItemStack(Blocks.field_150437_az));
        CIRCUIT_T2 = new UniversalRecipe("circuitAdvanced", IC2Items.getItem("advancedCircuit"), new ItemStack(Items.field_151107_aW));
        CIRCUIT_T3 = new UniversalRecipe("circuitElite", IC2Items.getItem("iridiumPlate"), new ItemStack(Items.field_151132_bS));
        ADVANCED_BATTERY = new UniversalRecipe("advancedBattery", IC2Items.getItem("energyCrystal"), "battery", new ItemStack(Items.field_151107_aW));
        BATTERY = new UniversalRecipe("battery", IC2Items.getItem("reBattery"), new ItemStack(Items.field_151107_aW));
        BATTERY_BOX = new UniversalRecipe("batteryBox", IC2Items.getItem("batBox"), new ItemStack(Blocks.field_150340_R));
        WRENCH = new UniversalRecipe("wrench", IC2Items.getItem("wrench"), new ItemStack(Items.field_151036_c));
        WIRE = new UniversalRecipe("wire", "ironWire", "copperCableBlock", new ItemStack(Items.field_151137_ax));
        MOTOR = new UniversalRecipe("motor", "gear", IC2Items.getItem("generator"), new ItemStack((Block)Blocks.field_150331_J));
        RUBBER = new UniversalRecipe("rubber", "itemRubber", new ItemStack(Items.field_151123_aH));
    }
}

