/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.RenderUtility;
import resonant.lib.transform.rotation.Quaternion;
import resonant.lib.transform.vector.Vector3;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.WorldUtility;

@SideOnly(value=Side.CLIENT)
public class RenderItemOverlayUtility {
    private static final ForgeDirection[] forge_sides = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    private static RenderBlocks renderBlocks = new RenderBlocks();
    private static RenderItem renderItem = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);

    public static void renderTopOverlay(TileEntity tileEntity, ItemStack[] inventory, ForgeDirection dir, double x, double y, double z) {
        RenderItemOverlayUtility.renderTopOverlay(tileEntity, inventory, dir, 3, 3, x, y, z, 0.7f);
    }

    public static void renderTopOverlay(TileEntity tileEntity, ItemStack[] inventory, ForgeDirection dir, int matrixX, int matrixZ, double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        boolean isLooking = false;
        MovingObjectPosition objectPosition = player.func_70614_a(8.0, 1.0f);
        if (objectPosition != null) {
            isLooking = objectPosition.field_72311_b == tileEntity.field_145851_c && objectPosition.field_72312_c == tileEntity.field_145848_d && objectPosition.field_72309_d == tileEntity.field_145849_e;
        }
        for (int i = 0; i < matrixX * matrixZ; ++i) {
            if (inventory[i] == null) continue;
            Vector3 translation = (Vector3)new Vector3((double)(i / matrixX) / (double)matrixX + 0.5 / (double)matrixX, 1.1, (double)(i % matrixZ) / (double)matrixZ + 0.5 / (double)matrixZ).add(-0.5);
            translation.multiply(0.85);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            RenderUtility.rotateBlockBasedOnDirection(dir);
            GL11.glTranslated((double)translation.x(), (double)translation.y(), (double)translation.z());
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            RenderItemOverlayUtility.renderItem(tileEntity.func_145831_w(), ForgeDirection.UP, inventory[i], new Vector3(0.0, 0.0, 0.0), 0.0f, 4);
            GL11.glPopMatrix();
            if (!isLooking) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            int angle = WorldUtility.getAngleFromForgeDirection(WorldUtility.invertX(dir));
            RenderUtility.renderFloatingText("" + inventory[i].field_77994_a, ((Vector3)translation.transform(new Quaternion(angle, Vector3.up())).add(0.5)).add(new Vector3(0.0, 0.3, 0.0)));
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public static void renderItemOnSides(TileEntity tile, ItemStack itemStack, double x, double y, double z) {
        RenderItemOverlayUtility.renderItemOnSides(tile, itemStack, x, y, z, LanguageUtility.getLocal("tooltip.noOutput"));
    }

    public static void renderItemOnSides(TileEntity tile, ItemStack itemStack, double x, double y, double z, String renderText) {
        RenderItemOverlayUtility.renderItemOnSides(tile, itemStack, x, y, z, renderText, EnumSet.of(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST));
    }

    public static void renderItemOnSides(TileEntity tile, ItemStack itemStack, double x, double y, double z, String renderText, EnumSet<ForgeDirection> sides) {
        if (tile != null && tile.func_145831_w() != null) {
            String amount = "";
            if (itemStack != null) {
                renderText = itemStack.func_82833_r();
                amount = Integer.toString(itemStack.field_77994_a);
            }
            for (ForgeDirection direction : sides) {
                if (direction == ForgeDirection.UNKNOWN || tile.func_145838_q().isSideSolid((IBlockAccess)tile.func_145831_w(), tile.field_145851_c + direction.offsetX, tile.field_145848_d, tile.field_145849_e + direction.offsetZ, direction.getOpposite())) continue;
                RenderItemOverlayUtility.renderItemOnSide(tile, itemStack, direction, x, y, z, renderText, amount);
                GL11.glPushMatrix();
                RenderItemOverlayUtility.setupLight(tile, direction.offsetX, direction.offsetZ);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glDisable((int)2896);
                RenderUtility.renderText(renderText, direction, 0.02f, x, y - (double)0.35f, z);
                RenderUtility.renderText(amount, direction, 0.02f, x, y - (double)0.15f, z);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
        }
    }

    protected static void renderItemSingleSide(TileEntity tile, double x, double y, double z, ItemStack itemStack, ForgeDirection direction, String renderText) {
        if (!tile.func_145838_q().isSideSolid((IBlockAccess)tile.func_145831_w(), tile.field_145851_c + direction.offsetX, tile.field_145848_d, tile.field_145849_e + direction.offsetZ, direction.getOpposite())) {
            String amount = "";
            if (itemStack != null) {
                renderText = itemStack.func_82833_r();
                amount = Integer.toString(itemStack.field_77994_a);
            }
            RenderItemOverlayUtility.renderItemOnSide(tile, itemStack, direction, x, y, z, renderText, amount);
            GL11.glPushMatrix();
            RenderItemOverlayUtility.setupLight(tile, direction.offsetX, direction.offsetZ);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2896);
            RenderUtility.renderText(renderText, direction, 0.02f, x, y - (double)0.35f, z);
            RenderUtility.renderText(amount, direction, 0.02f, x, y - (double)0.15f, z);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    protected static void renderItemOnSide(TileEntity tile, ItemStack itemStack, ForgeDirection direction, double x, double y, double z, String renderText, String amount) {
        if (itemStack != null) {
            GL11.glPushMatrix();
            switch (direction) {
                case NORTH: {
                    GL11.glTranslated((double)(x + 0.65), (double)(y + 0.9), (double)(z - 0.01));
                    break;
                }
                case SOUTH: {
                    GL11.glTranslated((double)(x + 0.35), (double)(y + 0.9), (double)(z + 1.01));
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GL11.glTranslated((double)(x - 0.01), (double)(y + 0.9), (double)(z + 0.35));
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GL11.glTranslated((double)(x + 1.01), (double)(y + 0.9), (double)(z + 0.65));
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case UP: {
                    GL11.glTranslated((double)(x + 0.65), (double)(y + 1.01), (double)(z + 0.9));
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case DOWN: {
                    GL11.glTranslated((double)(x + 0.65), (double)(y - 0.01), (double)(z - 0.01));
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            float scale = 0.03125f;
            GL11.glScalef((float)(0.6f * scale), (float)(0.6f * scale), (float)-1.0E-5f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
            RenderItemOverlayUtility.setupLight(tile, direction.offsetX, direction.offsetZ);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2896);
            if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)renderEngine, (ItemStack)itemStack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                renderItem.func_77015_a(Minecraft.func_71410_x().field_71466_p, renderEngine, itemStack, 0, 0);
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    private static void setupLight(TileEntity tileEntity, int xDifference, int zDifference) {
        World world = tileEntity.func_145831_w();
        if (tileEntity.func_145838_q().func_149662_c()) {
            return;
        }
        int br = world.func_72802_i(tileEntity.field_145851_c + xDifference, tileEntity.field_145848_d, tileEntity.field_145849_e + zDifference, 0);
        int var11 = br % 65536;
        int var12 = br / 65536;
        float scale = 1.0f;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 * scale), (float)((float)var12 * scale));
    }

    public static void renderItem(World world, ForgeDirection dir, ItemStack itemStack, Vector3 position, float rotationYaw, int angle) {
        if (itemStack != null) {
            EntityItem entityItem = new EntityItem(world, 0.0, 0.0, 0.0, itemStack.func_77946_l());
            entityItem.func_92059_d().field_77994_a = 1;
            entityItem.field_70290_d = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)position.x(), (double)position.y(), (double)(-position.z()));
            GL11.glRotatef((float)(180.0f + rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(90 * angle), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderItem renderItem = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);
            boolean fancyGraphics = RenderManager.field_78727_a.field_78733_k.field_74347_j;
            RenderManager.field_78727_a.field_78733_k.field_74347_j = true;
            renderItem.func_76986_a(entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderManager.field_78727_a.field_78733_k.field_74347_j = fancyGraphics;
            GL11.glPopMatrix();
        }
    }
}

