/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render.fx;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import resonant.lib.transform.rotation.Quaternion;
import resonant.lib.transform.vector.Vector3;

@SideOnly(value=Side.CLIENT)
public class FXElectricBolt2
extends EntityFX {
    public static final ResourceLocation TEXTURE = new ResourceLocation("resonant", "models/fadedSphere.png");
    public static final ResourceLocation PARTICLE_RESOURCE = new ResourceLocation("textures/particle/particles.png");
    private final Map<Integer, Integer> parentIDMap = new HashMap<Integer, Integer>();
    public double boltLength;
    public float complexity;
    public int segmentCount;
    private float boltWidth;
    private BoltPoint start;
    private BoltPoint end;
    private List<BoltSegment> segments = new ArrayList<BoltSegment>();
    private int maxSplitID;
    private Random rand = new Random();

    public FXElectricBolt2(World world, Vector3 startVec, Vector3 targetVec, boolean doSplits) {
        super(world, startVec.x(), startVec.y(), startVec.z());
        this.start = new BoltPoint(startVec);
        this.end = new BoltPoint(targetVec);
        if (this.end.y() == Double.POSITIVE_INFINITY) {
            this.end.y(Minecraft.func_71410_x().field_71439_g.field_70163_u + 30.0);
        }
        this.segmentCount = 1;
        this.field_70547_e = 3 + this.rand.nextInt(3) - 1;
        this.complexity = 2.0f;
        this.boltWidth = 0.05f;
        this.boltLength = this.start.distance(this.end);
        this.setUp(doSplits);
    }

    public FXElectricBolt2(World world, Vector3 startVec, Vector3 targetVec) {
        this(world, startVec, targetVec, true);
    }

    private void setUp(boolean doSplits) {
        this.segments.add(new BoltSegment(this.start, this.end));
        this.recalculate();
        if (doSplits) {
            double offsetRatio = this.boltLength * (double)this.complexity;
            this.split(2, offsetRatio / 10.0, 0.7f, 0.1f, 10.0f);
            this.split(2, offsetRatio / 15.0, 0.5f, 0.1f, 12.0f);
            this.split(2, offsetRatio / 25.0, 0.5f, 0.1f, 14.0f);
            this.split(2, offsetRatio / 38.0, 0.5f, 0.1f, 15.0f);
            this.split(2, offsetRatio / 55.0, 0.0f, 0.0f, 0.0f);
            this.split(2, offsetRatio / 70.0, 0.0f, 0.0f, 0.0f);
            this.recalculate();
            Collections.sort(this.segments, new Comparator<BoltSegment>(){

                @Override
                public int compare(BoltSegment bolt1, BoltSegment bolt2) {
                    return Float.compare(bolt2.alpha, bolt1.alpha);
                }
            });
        }
    }

    public FXElectricBolt2 setColor(float r, float g, float b) {
        this.field_70552_h = r + this.rand.nextFloat() * 0.1f - 0.1f;
        this.field_70553_i = g + this.rand.nextFloat() * 0.1f - 0.1f;
        this.field_70551_j = b + this.rand.nextFloat() * 0.1f - 0.1f;
        return this;
    }

    public void split(int splitAmount, double offset, float splitChance, float splitLength, float splitAngle) {
        List<BoltSegment> oldSegments = this.segments;
        this.segments = new ArrayList<BoltSegment>();
        BoltSegment prev = null;
        for (BoltSegment segment : oldSegments) {
            int i;
            prev = segment.prev;
            Vector3 subSegment = (Vector3)segment.difference.clone().multiply((double)(1.0f / (float)splitAmount));
            BoltPoint[] newPoints = new BoltPoint[splitAmount + 1];
            BoltPoint startPoint = segment.start;
            newPoints[0] = segment.start;
            newPoints[splitAmount] = segment.end;
            for (i = 1; i < splitAmount; ++i) {
                Vector3 newOffset = (Vector3)segment.difference.perpendicular().transform(new Quaternion(this.rand.nextFloat() * 360.0f, segment.difference)).multiply((double)(this.rand.nextFloat() - 0.5f) * offset);
                Vector3 basePoint = (Vector3)startPoint.clone().add(subSegment.clone().multiply((double)i));
                newPoints[i] = new BoltPoint(basePoint, newOffset);
            }
            for (i = 0; i < splitAmount; ++i) {
                BoltSegment next = new BoltSegment(newPoints[i], newPoints[i + 1], segment.alpha, segment.id * splitAmount + i, segment.splitID);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && this.rand.nextFloat() < splitChance) {
                    Vector3 splitrot = next.difference.xCross().transform(new Quaternion(this.rand.nextFloat() * 360.0f, next.difference));
                    Vector3 diff = (Vector3)next.difference.clone().transform(new Quaternion((this.rand.nextFloat() * 0.66f + 0.33f) * splitAngle, splitrot)).multiply((double)splitLength);
                    ++this.maxSplitID;
                    this.parentIDMap.put(this.maxSplitID, next.splitID);
                    BoltSegment split = new BoltSegment(newPoints[i], new BoltPoint(newPoints[i + 1].base, newPoints[i + 1].offset.clone().add(diff)), segment.alpha / 2.0f, next.id, this.maxSplitID);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.segmentCount *= splitAmount;
    }

    private void recalculate() {
        HashMap<Integer, Integer> lastActiveSegment = new HashMap<Integer, Integer>();
        Collections.sort(this.segments, new Comparator(){

            public int compare(BoltSegment o1, BoltSegment o2) {
                int comp = Integer.valueOf(o1.splitID).compareTo(o2.splitID);
                if (comp == 0) {
                    return Integer.valueOf(o1.id).compareTo(o2.id);
                }
                return comp;
            }

            public int compare(Object obj, Object obj1) {
                return this.compare((BoltSegment)obj, (BoltSegment)obj1);
            }
        });
        int lastSplitCalc = 0;
        int lastActiveSeg = 0;
        for (BoltSegment segment : this.segments) {
            if (segment.splitID > lastSplitCalc) {
                lastActiveSegment.put(lastSplitCalc, lastActiveSeg);
                lastSplitCalc = segment.splitID;
                lastActiveSeg = (Integer)lastActiveSegment.get(this.parentIDMap.get(segment.splitID));
            }
            lastActiveSeg = segment.id;
        }
        lastActiveSegment.put(lastSplitCalc, lastActiveSeg);
        lastSplitCalc = 0;
        lastActiveSeg = (Integer)lastActiveSegment.get(0);
        Iterator<BoltSegment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            BoltSegment segment = iterator.next();
            if (lastSplitCalc != segment.splitID) {
                lastSplitCalc = segment.splitID;
                lastActiveSeg = (Integer)lastActiveSegment.get(segment.splitID);
            }
            if (segment.id > lastActiveSeg) {
                iterator.remove();
            }
            segment.recalculate();
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialframe, float cosYaw, float cosPitch, float sinYaw, float sinSinPitch, float cosSinPitch) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78380_c(0xF000F0);
        Vector3 playerVector = new Vector3(sinYaw * -cosPitch, -cosSinPitch / cosYaw, cosYaw * cosPitch);
        int renderlength = (int)(((float)this.field_70546_d + partialframe + (float)((int)(this.boltLength * 3.0))) / (float)((int)(this.boltLength * 3.0)) * (float)this.segmentCount);
        for (BoltSegment segment : this.segments) {
            float rz3;
            float ry3;
            float rx3;
            Vector3 roundEnd;
            if (segment == null || segment.id > renderlength) continue;
            double renderWidth = (double)this.boltWidth * ((new Vector3((Entity)player).distance(segment.start) / 5.0 + 1.0) * (double)(1.0f + segment.alpha) * 0.5);
            renderWidth = Math.min((double)this.boltWidth, Math.max(renderWidth, 0.0));
            if (!(segment.difference.magnitude() > 0.0) || segment.difference.magnitude() == Double.NaN || segment.difference.magnitude() == Double.POSITIVE_INFINITY || !(renderWidth > 0.0) || renderWidth == Double.NaN || renderWidth == Double.POSITIVE_INFINITY) continue;
            Vector3 diffPrev = (Vector3)playerVector.cross(segment.prevDiff).multiply(renderWidth / segment.sinPrev);
            Vector3 diffNext = (Vector3)playerVector.cross(segment.nextDiff).multiply(renderWidth / segment.sinNext);
            BoltPoint startVec = segment.start;
            BoltPoint endVec = segment.end;
            float rx1 = (float)(startVec.x() - field_70556_an);
            float ry1 = (float)(startVec.y() - field_70554_ao);
            float rz1 = (float)(startVec.z() - field_70555_ap);
            float rx2 = (float)(endVec.x() - field_70556_an);
            float ry2 = (float)(endVec.y() - field_70554_ao);
            float rz2 = (float)(endVec.z() - field_70555_ap);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, (1.0f - (this.field_70546_d >= 0 ? (float)this.field_70546_d / (float)this.field_70547_e : 0.0f) * 0.6f) * segment.alpha);
            tessellator.func_78374_a((double)rx2 - diffNext.x(), (double)ry2 - diffNext.y(), (double)rz2 - diffNext.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx1 - diffPrev.x(), (double)ry1 - diffPrev.y(), (double)rz1 - diffPrev.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx1 + diffPrev.x(), (double)ry1 + diffPrev.y(), (double)rz1 + diffPrev.z(), 0.5, 1.0);
            tessellator.func_78374_a((double)rx2 + diffNext.x(), (double)ry2 + diffNext.y(), (double)rz2 + diffNext.z(), 0.5, 1.0);
            if (segment.next == null) {
                roundEnd = (Vector3)segment.end.clone().add(((Vector3)segment.difference.clone().normalize()).multiply(renderWidth));
                rx3 = (float)(roundEnd.x() - field_70556_an);
                ry3 = (float)(roundEnd.y() - field_70554_ao);
                rz3 = (float)(roundEnd.z() - field_70555_ap);
                tessellator.func_78374_a((double)rx3 - diffNext.x(), (double)ry3 - diffNext.y(), (double)rz3 - diffNext.z(), 0.0, 0.0);
                tessellator.func_78374_a((double)rx2 - diffNext.x(), (double)ry2 - diffNext.y(), (double)rz2 - diffNext.z(), 0.5, 0.0);
                tessellator.func_78374_a((double)rx2 + diffNext.x(), (double)ry2 + diffNext.y(), (double)rz2 + diffNext.z(), 0.5, 1.0);
                tessellator.func_78374_a((double)rx3 + diffNext.x(), (double)ry3 + diffNext.y(), (double)rz3 + diffNext.z(), 0.0, 1.0);
            }
            if (segment.prev != null) continue;
            roundEnd = (Vector3)segment.start.clone().subtract(((Vector3)segment.difference.clone().normalize()).multiply(renderWidth));
            rx3 = (float)(roundEnd.x() - field_70556_an);
            ry3 = (float)(roundEnd.y() - field_70554_ao);
            rz3 = (float)(roundEnd.z() - field_70555_ap);
            tessellator.func_78374_a((double)rx1 - diffPrev.x(), (double)ry1 - diffPrev.y(), (double)rz1 - diffPrev.z(), 0.5, 0.0);
            tessellator.func_78374_a((double)rx3 - diffPrev.x(), (double)ry3 - diffPrev.y(), (double)rz3 - diffPrev.z(), 0.0, 0.0);
            tessellator.func_78374_a((double)rx3 + diffPrev.x(), (double)ry3 + diffPrev.y(), (double)rz3 + diffPrev.z(), 0.0, 1.0);
            tessellator.func_78374_a((double)rx1 + diffPrev.x(), (double)ry1 + diffPrev.y(), (double)rz1 + diffPrev.z(), 0.5, 1.0);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(PARTICLE_RESOURCE);
        tessellator.func_78382_b();
    }

    private class BoltSegment {
        public BoltPoint start;
        public BoltPoint end;
        public BoltSegment prev;
        public BoltSegment next;
        public float alpha;
        public int id;
        public int splitID;
        public Vector3 difference;
        public Vector3 prevDiff;
        public Vector3 nextDiff;
        public double sinPrev;
        public double sinNext;

        public BoltSegment(BoltPoint start, BoltPoint end) {
            this(start, end, 1.0f, 0, 0);
        }

        public BoltSegment(BoltPoint start, BoltPoint end, float alpha, int id, int splitID) {
            this.start = start;
            this.end = end;
            this.alpha = alpha;
            this.id = id;
            this.splitID = splitID;
            this.difference = this.end.clone().subtract(this.start);
        }

        public void recalculate() {
            Vector3 diffNorm;
            if (this.prev != null) {
                Vector3 prevDiffNorm = (Vector3)this.prev.difference.clone().normalize();
                diffNorm = (Vector3)this.difference.clone().normalize();
                this.prevDiff = (Vector3)diffNorm.clone().add(prevDiffNorm).normalize();
                this.sinPrev = Math.sin(diffNorm.anglePreNorm((Vector3)prevDiffNorm.clone().multiply(-1.0)) / 2.0);
            } else {
                this.prevDiff = (Vector3)this.difference.clone().normalize();
                this.sinPrev = 1.0;
            }
            if (this.next != null) {
                Vector3 nextDiffNorm = (Vector3)this.next.difference.clone().normalize();
                diffNorm = (Vector3)this.difference.clone().normalize();
                this.nextDiff = (Vector3)diffNorm.clone().add(nextDiffNorm).normalize();
                this.sinNext = Math.sin(diffNorm.anglePreNorm((Vector3)nextDiffNorm.clone().multiply(-1.0)) / 2.0);
            } else {
                this.nextDiff = (Vector3)this.difference.clone().normalize();
                this.sinNext = 1.0;
            }
        }
    }

    private class BoltPoint
    extends Vector3 {
        public Vector3 base;
        public Vector3 offset;

        public BoltPoint(Vector3 base, Vector3 offset) {
            super(base.clone().add(offset));
            this.base = base;
            this.offset = offset;
        }

        public BoltPoint(Vector3 base) {
            this(base, new Vector3());
        }
    }
}

