/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.schematic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.lib.schematic.BuildMap;
import resonant.lib.schematic.Placement;
import resonant.lib.transform.vector.Vector3;
import resonant.lib.type.Pair;

public abstract class Schematic {
    public abstract String getName();

    public BuildMap getBuildMap(Vector3 center, ForgeDirection facingDirection, int size) {
        HashMap<Vector3, Pair<Block, Integer>> map = this.getStructure(facingDirection, size);
        BuildMap buildMap = new BuildMap(map.size());
        int p = 0;
        for (Map.Entry<Vector3, Pair<Block, Integer>> entry : map.entrySet()) {
            buildMap.add(p, entry.getKey(), new Placement(entry.getValue().left(), entry.getValue().right()));
            ++p;
        }
        return buildMap;
    }

    public abstract HashMap<Vector3, Pair<Block, Integer>> getStructure(ForgeDirection var1, int var2);

    public HashMap<Vector3, Pair<Block, Integer>> getLine(Vector3 start, ForgeDirection dir, Block block, int meta, int length) {
        HashMap<Vector3, Pair<Block, Integer>> returnMap = new HashMap<Vector3, Pair<Block, Integer>>();
        for (int i = 0; i < length; ++i) {
            returnMap.put(((Vector3)new Vector3(dir).multiply((double)i)).add(start), new Pair<Block, Integer>(block, meta));
        }
        return returnMap;
    }

    public HashMap<Vector3, Pair<Block, Integer>> getBox(Vector3 center, Block block, int meta, int size) {
        return this.getBox(center, block, meta, size, size);
    }

    public HashMap<Vector3, Pair<Block, Integer>> getBox(Vector3 center, Block block, int meta, int sizeX, int sizeZ) {
        HashMap<Vector3, Pair<Block, Integer>> returnMap = new HashMap<Vector3, Pair<Block, Integer>>();
        Vector3 start = new Vector3(-sizeX, 0.0, -sizeZ).add(center);
        if (sizeX != sizeZ) {
            for (int x = 0; x <= sizeX * 2; ++x) {
                returnMap.put(new Vector3(x, 0.0, 0.0).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Vector3(x, 0.0, sizeZ * 2).add(start), new Pair<Block, Integer>(block, meta));
            }
            for (int z = 0; z <= sizeZ * 2; ++z) {
                returnMap.put(new Vector3(0.0, 0.0, z).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Vector3(sizeX * 2, 0.0, z).add(start), new Pair<Block, Integer>(block, meta));
            }
        } else {
            for (int s = 0; s <= sizeX * 2; ++s) {
                returnMap.put(new Vector3(s, 0.0, 0.0).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Vector3(s, 0.0, sizeZ * 2).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Vector3(0.0, 0.0, s).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Vector3(sizeZ * 2, 0.0, s).add(start), new Pair<Block, Integer>(block, meta));
            }
        }
        return returnMap;
    }
}

