/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.transform.region;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.transform.AbstractOperation;
import resonant.lib.transform.vector.Vector2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001-\u0011\u0011BU3di\u0006tw\r\\3\u000b\u0005\r!\u0011A\u0002:fO&|gN\u0003\u0002\u0006\r\u0005IAO]1og\u001a|'/\u001c\u0006\u0003\u000f!\t1\u0001\\5c\u0015\u0005I\u0011\u0001\u0003:fg>t\u0017M\u001c;\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0004\u001b9\u0001R\"\u0001\u0003\n\u0005=!!!E!cgR\u0014\u0018m\u0019;Pa\u0016\u0014\u0018\r^5p]B\u0011\u0011\u0003A\u0007\u0002\u0005!A1\u0003\u0001BA\u0002\u0013\u0005A#A\u0002nS:,\u0012!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00031\u0011\taA^3di>\u0014\u0018B\u0001\u000e\u0018\u0005\u001d1Vm\u0019;peJB\u0001\u0002\b\u0001\u0003\u0002\u0004%\t!H\u0001\b[&tw\fJ3r)\tqB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\bbB\u0013\u001c\u0003\u0003\u0005\r!F\u0001\u0004q\u0012\n\u0004\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0015B\u000b\u0002\t5Lg\u000e\t\u0005\tS\u0001\u0011\t\u0019!C\u0001)\u0005\u0019Q.\u0019=\t\u0011-\u0002!\u00111A\u0005\u00021\nq!\\1y?\u0012*\u0017\u000f\u0006\u0002\u001f[!9QEKA\u0001\u0002\u0004)\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\u000b\u0002\t5\f\u0007\u0010\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\u0019D\u0007C\u0003\u0014a\u0001\u0007Q\u0003C\u0003*a\u0001\u0007Q\u0003C\u00032\u0001\u0011\u0005a\u0007F\u0001\u0011\u0011\u0015\t\u0004\u0001\"\u00019)\r\u0001\u0012h\u000f\u0005\u0006u]\u0002\r!F\u0001\u0004m\u0016\u001c\u0007\"\u0002\u001f8\u0001\u0004i\u0014!C3ya\u0006t7/[8o!\tyb(\u0003\u0002@A\t1Ai\\;cY\u0016DQ!\r\u0001\u0005\u0002\u0005#R\u0001\u0005\"E\r\"CQa\u0011!A\u0002u\nA!\\5o1\")Q\t\u0011a\u0001{\u0005!Q.\u001b8Z\u0011\u00159\u0005\t1\u0001>\u0003\u0011i\u0017\r\u001f-\t\u000b%\u0003\u0005\u0019A\u001f\u0002\t5\f\u00070\u0017\u0005\u0006c\u0001!\ta\u0013\u000b\u0003!1CQ!\u0014&A\u0002A\tAA]3di\")q\n\u0001C!!\u0006\u00191/\u001a;\u0015\u0005A\t\u0006\"\u0002*O\u0001\u0004\u0001\u0012!B8uQ\u0016\u0014\b\"\u0002+\u0001\t\u0003*\u0016!\u0002:pk:$W#\u0001\t\t\u000b]\u0003A\u0011I+\u0002\t\r,\u0017\u000e\u001c\u0005\u00063\u0002!\t%V\u0001\u0006M2|wN\u001d\u0005\u0006S\u0001!\te\u0017\u000b\u0003!qCQA\u0015.A\u0002AAQa\u0005\u0001\u0005By#\"\u0001E0\t\u000bIk\u0006\u0019\u0001\t\t\u000b\u0005\u0004A\u0011\t\u001c\u0002\u0015I,7-\u001b9s_\u000e\fG\u000eC\u0003d\u0001\u0011\u0005C-A\u0003%a2,8\u000f\u0006\u0002\u0011K\")aM\u0019a\u0001{\u00051\u0011-\\8v]RDQa\u0019\u0001\u0005B!$\"\u0001E5\t\u000b\u0019<\u0007\u0019\u0001\t\t\u000b\r\u0004A\u0011A6\u0015\u0005Aa\u0007\"\u0002\u001ek\u0001\u0004)\u0002\"\u00028\u0001\t\u0003y\u0017\u0001\u0003\u0013qYV\u001cH%Z9\u0015\u0005A\u0001\b\"\u0002\u001en\u0001\u0004)\u0002\"\u0002:\u0001\t\u0003\u0019\u0018A\u0002\u0013nS:,8\u000f\u0006\u0002\u0011i\")!(\u001da\u0001+!)a\u000f\u0001C\u0001o\u0006IA%\\5okN$S-\u001d\u000b\u0003!aDQAO;A\u0002UAQA\u001f\u0001\u0005\u0002m\f1!\u00193e)\t\u0001B\u0010C\u0003;s\u0002\u0007Q\u0003C\u0003\u007f\u0001\u0011\u0005q0\u0001\u0004bI\u0012\u001cV\r\u001e\u000b\u0004!\u0005\u0005\u0001\"\u0002\u001e~\u0001\u0004)\u0002bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\tgV\u0014GO]1diR\u0019\u0001#!\u0003\t\ri\n\u0019\u00011\u0001\u0016\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t1b];ciJ\f7\r^*fiR\u0019\u0001#!\u0005\t\ri\nY\u00011\u0001\u0016\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\ta\u0001\n;j[\u0016\u001cHc\u0001\t\u0002\u001a!1a-a\u0005A\u0002uBq!!\u0006\u0001\t\u0003\ti\u0002F\u0002\u0011\u0003?AaAZA\u000e\u0001\u0004\u0001\u0002bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u000bS:$XM]:fGR\u001cH\u0003BA\u0014\u0003[\u00012aHA\u0015\u0013\r\tY\u0003\t\u0002\b\u0005>|G.Z1o\u0011\u001d\ty#!\tA\u0002U\tQ\u0001]8j]RDq!a\t\u0001\t\u0003\t\u0019\u0004\u0006\u0003\u0002(\u0005U\u0002BB\u0002\u00022\u0001\u0007\u0001\u0003C\u0004\u0002:\u0001!\t%a\u000f\u0002\u0011]\u0014\u0018\u000e^3O\u0005R#B!!\u0010\u0002RA!\u0011qHA'\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013a\u00018ci*!\u0011qIA%\u0003%i\u0017N\\3de\u00064GO\u0003\u0002\u0002L\u0005\u0019a.\u001a;\n\t\u0005=\u0013\u0011\t\u0002\u000f\u001d\n#F+Y4D_6\u0004x.\u001e8e\u0011!\t\u0019%a\u000eA\u0002\u0005u\u0002bBA+\u0001\u0011\u0005\u0013qK\u0001\roJLG/\u001a\"zi\u0016\u0014UO\u001a\u000b\u0005\u00033\ni\u0007\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\r\t,hMZ3s\u0015\u0011\t\u0019'!\u001a\u0002\u000b9,G\u000f^=\u000b\u0005\u0005\u001d\u0014AA5p\u0013\u0011\tY'!\u0018\u0003\u000f\tKH/\u001a\"vM\"A\u0011qNA*\u0001\u0004\tI&\u0001\u0003eCR\f\u0007bBA:\u0001\u0011\u0005\u0013QO\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000f\t\u0005\u0003s\nyHD\u0002 \u0003wJ1!! !\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011QAB\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0010\u0011\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\u00061Q-];bYN$B!a\n\u0002\f\"A\u0011QRAC\u0001\u0004\ty)A\u0001p!\ry\u0012\u0011S\u0005\u0004\u0003'\u0003#aA!os\"1\u0011q\u0013\u0001\u0005BY\nQa\u00197p]\u0016\u0004")
public class Rectangle
extends AbstractOperation<Rectangle> {
    private Vector2 min;
    private Vector2 max;

    public Vector2 min() {
        return this.min;
    }

    public void min_$eq(Vector2 x$1) {
        this.min = x$1;
    }

    public Vector2 max() {
        return this.max;
    }

    public void max_$eq(Vector2 x$1) {
        this.max = x$1;
    }

    @Override
    public Rectangle set(Rectangle other) {
        this.min_$eq(other.min().clone());
        this.max_$eq(other.max().clone());
        return this;
    }

    @Override
    public Rectangle round() {
        return new Rectangle(this.min().round(), this.max().round());
    }

    @Override
    public Rectangle ceil() {
        return new Rectangle(this.min().ceil(), this.max().ceil());
    }

    @Override
    public Rectangle floor() {
        return new Rectangle(this.min().floor(), this.max().floor());
    }

    @Override
    public Rectangle max(Rectangle other) {
        return new Rectangle(this.min().max(other.min()), this.max().max(other.max()));
    }

    @Override
    public Rectangle min(Rectangle other) {
        return new Rectangle(this.min().min(other.min()), this.max().min(other.max()));
    }

    @Override
    public Rectangle reciprocal() {
        return new Rectangle(this.min().reciprocal(), this.max().reciprocal());
    }

    @Override
    public Rectangle $plus(double amount) {
        return new Rectangle(this.min().$plus(amount), this.max().$plus(amount));
    }

    @Override
    public Rectangle $plus(Rectangle amount) {
        return new Rectangle(this.min().$plus(amount.min()), this.max().$plus(amount.max()));
    }

    @Override
    public Rectangle $plus(Vector2 vec) {
        return new Rectangle(this.min().$plus(vec), this.max().$plus(vec));
    }

    @Override
    public Rectangle $plus$eq(Vector2 vec) {
        this.min().$plus$eq(vec);
        this.max().$plus$eq(vec);
        return this;
    }

    @Override
    public Rectangle $minus(Vector2 vec) {
        return this.$plus(vec.$times(-1.0));
    }

    @Override
    public Rectangle $minus$eq(Vector2 vec) {
        return this.$plus$eq(vec.$times(-1.0));
    }

    @Override
    public Rectangle add(Vector2 vec) {
        return this.$plus(vec);
    }

    public Rectangle addSet(Vector2 vec) {
        return this.$plus$eq(vec);
    }

    @Override
    public Rectangle subtract(Vector2 vec) {
        return this.$minus(vec);
    }

    public Rectangle subtractSet(Vector2 vec) {
        return this.$minus$eq(vec);
    }

    @Override
    public Rectangle $times(double amount) {
        return new Rectangle(this.min().$times(amount), this.max().$times(amount));
    }

    @Override
    public Rectangle $times(Rectangle amount) {
        return new Rectangle(this.min().$times(amount.min()), this.max().$times(amount.max()));
    }

    public boolean intersects(Vector2 point) {
        return point.x() > this.min().x() && point.x() < this.max().x() && point.y() > this.min().y() && point.y() < this.max().y();
    }

    public boolean intersects(Rectangle region) {
        return region.max().x() > this.min().x() && region.min().x() < this.max().x() ? region.max().y() > this.min().y() && region.min().y() < this.max().y() : false;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("min", (NBTBase)this.min().toNBT());
        nbt.func_74782_a("max", (NBTBase)this.max().toNBT());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        this.min().writeByteBuf(data);
        this.max().writeByteBuf(data);
        return data;
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Rectangle[").append((Object)new BigDecimal(this.min().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.min().y(), cont)).append((Object)"] -> [").append((Object)new BigDecimal(this.max().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.max().y(), cont)).append((Object)"]").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Rectangle)) return false;
        Vector2 vector2 = this.min();
        Vector2 vector22 = ((Rectangle)o).min();
        if (vector2 == null) {
            if (vector22 != null) {
                return false;
            }
        } else if (!((Object)vector2).equals(vector22)) return false;
        Vector2 vector23 = this.max();
        Vector2 vector24 = ((Rectangle)o).max();
        if (vector23 == null) {
            if (vector24 == null) return true;
            return false;
        } else {
            if (!((Object)vector23).equals(vector24)) return false;
            return true;
        }
    }

    public Rectangle clone() {
        return new Rectangle(this);
    }

    public Rectangle(Vector2 min, Vector2 max) {
        this.min = min;
        this.max = max;
    }

    public Rectangle() {
        this(new Vector2(), new Vector2());
    }

    public Rectangle(Vector2 vec, double expansion) {
        this(vec, vec.$plus(expansion));
    }

    public Rectangle(double minX, double minY, double maxX, double maxY) {
        this(new Vector2(minX, minY), new Vector2(maxX, maxY));
    }

    public Rectangle(Rectangle rect) {
        this(rect.min().clone(), rect.max().clone());
    }
}

