/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.transform.rotation;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.transform.ITransform;
import resonant.lib.transform.matrix.Matrix;
import resonant.lib.transform.rotation.AngleAxis$;
import resonant.lib.transform.rotation.EulerAngle;
import resonant.lib.transform.vector.Vector3;
import scala.Cloneable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001-\u0011\u0011\"\u00118hY\u0016\f\u00050[:\u000b\u0005\r!\u0011\u0001\u0003:pi\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0001\"A\u0002mS\nT\u0011!C\u0001\te\u0016\u001cxN\\1oi\u000e\u00011\u0003\u0002\u0001\r)i\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\n\u00072|g.Z1cY\u0016\u0004\"a\u0007\u000f\u000e\u0003\u0011I!!\b\u0003\u0003\u0015%#&/\u00198tM>\u0014X\u000e\u0003\u0005 \u0001\t\u0005\r\u0011\"\u0001!\u0003\u0015\tgn\u001a7f+\u0005\t\u0003CA\u000b#\u0013\t\u0019cC\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005I\u0011M\\4mK~#S-\u001d\u000b\u0003O)\u0002\"!\u0006\u0015\n\u0005%2\"\u0001B+oSRDqa\u000b\u0013\u0002\u0002\u0003\u0007\u0011%A\u0002yIEB\u0001\"\f\u0001\u0003\u0002\u0003\u0006K!I\u0001\u0007C:<G.\u001a\u0011\t\u0011=\u0002!\u00111A\u0005\u0002A\nA!\u0019=jgV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025\t\u00051a/Z2u_JL!AN\u001a\u0003\u000fY+7\r^8sg!A\u0001\b\u0001BA\u0002\u0013\u0005\u0011(\u0001\u0005bq&\u001cx\fJ3r)\t9#\bC\u0004,o\u0005\u0005\t\u0019A\u0019\t\u0011q\u0002!\u0011!Q!\nE\nQ!\u0019=jg\u0002BQA\u0010\u0001\u0005\u0002}\na\u0001P5oSRtDc\u0001!C\u0007B\u0011\u0011\tA\u0007\u0002\u0005!9q$\u0010I\u0001\u0002\u0004\t\u0003bB\u0018>!\u0003\u0005\r!\r\u0005\u0006}\u0001!\t!\u0012\u000b\u0003\u0001\u001aCQa\u0012#A\u0002!\u000b1A\u001c2u!\tIu*D\u0001K\u0015\t95J\u0003\u0002M\u001b\u0006IQ.\u001b8fGJ\fg\r\u001e\u0006\u0002\u001d\u0006\u0019a.\u001a;\n\u0005AS%A\u0004(C)R\u000bwmQ8na>,h\u000e\u001a\u0005\u0006%\u0002!\taU\u0001\u0005G\u0016LG.F\u0001A\u0011\u0015)\u0006\u0001\"\u0001T\u0003\u00151Gn\\8s\u0011\u00159\u0006\u0001\"\u0001T\u0003\u0015\u0011x.\u001e8e\u0011\u0015)\u0001\u0001\"\u0011Z)\t\t$\fC\u000351\u0002\u0007\u0011\u0007C\u0003]\u0001\u0011\u0005Q,\u0001\tu_J{G/\u0019;j_:l\u0015\r\u001e:jqV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\t\u00051Q.\u0019;sSbL!a\u00191\u0003\r5\u000bGO]5y\u0011\u0015)\u0007\u0001\"\u0001g\u00031!x.R;mKJ\fen\u001a7f+\u00059\u0007CA!i\u0013\tI'A\u0001\u0006Fk2,'/\u00118hY\u0016DQa\u001b\u0001\u0005\u00021\f\u0001b\u001e:ji\u0016t%\t\u0016\u000b\u0003\u00116DQa\u00126A\u0002!CQa\u001c\u0001\u0005\u0002A\fAb\u001e:ji\u0016\u0014\u0015\u0010^3Ck\u001a$\"!]>\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018A\u00022vM\u001a,'O\u0003\u0002wo\u0006)a.\u001a;us*\t\u00010\u0001\u0002j_&\u0011!p\u001d\u0002\b\u0005f$XMQ;g\u0011\u0015ah\u000e1\u0001r\u0003\u0011!\u0017\r^1\t\u000by\u0004A\u0011I@\u0002\u000b\rdwN\\3\u0015\u0003\u0001Cq!a\u0001\u0001\t\u0003\n)!\u0001\u0005iCND7i\u001c3f)\t\t9\u0001E\u0002\u0016\u0003\u0013I1!a\u0003\u0017\u0005\rIe\u000e\u001e\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0003\u0019)\u0017/^1mgR!\u00111CA\r!\r)\u0012QC\u0005\u0004\u0003/1\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u00037\ti\u00011\u0001\u0002\u001e\u0005\tq\u000eE\u0002\u0016\u0003?I1!!\t\u0017\u0005\r\te._\u0004\n\u0003K\u0011\u0011\u0011!E\u0001\u0003O\t\u0011\"\u00118hY\u0016\f\u00050[:\u0011\u0007\u0005\u000bIC\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u0016'\u0011\tI#!\f\u0011\u0007U\ty#C\u0002\u00022Y\u0011a!\u00118z%\u00164\u0007b\u0002 \u0002*\u0011\u0005\u0011Q\u0007\u000b\u0003\u0003OA!\"!\u000f\u0002*E\u0005I\u0011AA\u001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004C\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-c#\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005M\u0013\u0011FI\u0001\n\u0003\t)&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003/R3!MA \u0001")
public class AngleAxis
implements Cloneable,
ITransform {
    private double angle;
    private Vector3 axis;

    public static Vector3 $lessinit$greater$default$2() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$1();
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    public Vector3 axis() {
        return this.axis;
    }

    public void axis_$eq(Vector3 x$1) {
        this.axis = x$1;
    }

    public AngleAxis ceil() {
        return new AngleAxis(Math.ceil(this.angle()), this.axis().ceil());
    }

    public AngleAxis floor() {
        return new AngleAxis(Math.floor(this.angle()), this.axis().floor());
    }

    public AngleAxis round() {
        return new AngleAxis(Math.round(this.angle()), this.axis().round());
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        return this.toRotationMatrix().$times(vector);
    }

    public Matrix toRotationMatrix() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double cos = Math.cos(this.angle());
        double oneMinusCos = 1.0 - cos;
        double sin = Math.sin(this.angle());
        Matrix matrix = new Matrix(3, 3);
        matrix.apply(0).update(0, x * x * oneMinusCos + cos);
        matrix.apply(0).update(1, y * x * oneMinusCos + z * sin);
        matrix.apply(0).update(2, x * z * oneMinusCos - y * sin);
        matrix.apply(1).update(0, x * y * oneMinusCos - z * sin);
        matrix.apply(1).update(1, y * y * oneMinusCos + cos);
        matrix.apply(1).update(2, y * z * oneMinusCos + x * sin);
        matrix.apply(2).update(0, x * z * oneMinusCos + y * sin);
        matrix.apply(2).update(1, y * z * oneMinusCos - x * sin);
        matrix.apply(2).update(2, z * z * oneMinusCos + cos);
        return matrix;
    }

    public EulerAngle toEulerAngle() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double s = Math.sin(this.angle());
        double c = Math.cos(this.angle());
        double t = 1.0 - c;
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (x * y * t + z * s > 0.998) {
            yaw = (double)2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = 1.5707963267948966;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        if (x * y * t + z * s < -0.998) {
            yaw = (double)-2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = -Math.PI / (double)2;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        yaw = Math.atan2(y * s - x * z * t, 1.0 - (y * y + z * z) * t);
        pitch = Math.asin(x * y * t + z * s);
        roll = Math.atan2(x * s - y * z * t, 1.0 - (x * x + z * z) * t);
        return new EulerAngle(yaw, pitch, roll);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.axis().writeNBT(nbt);
        nbt.func_74780_a("angle", this.angle());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        this.axis().writeByteBuf(data);
        data.writeDouble(this.angle());
        return data;
    }

    public AngleAxis clone() {
        return new AngleAxis(this.angle(), this.axis());
    }

    public int hashCode() {
        long angle = Double.doubleToLongBits(this.angle());
        int hash = this.axis().hashCode();
        hash = 31 * hash + (int)(angle ^ angle >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof AngleAxis) {
            AngleAxis other = (AngleAxis)o;
            return this.axis().equals(other.axis()) && this.angle() == other.angle();
        }
        return false;
    }

    public AngleAxis(double angle, Vector3 axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public AngleAxis(NBTTagCompound nbt) {
        this(nbt.func_74769_h("angle"), new Vector3(nbt));
    }
}

