/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.transform.rotation;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.lib.transform.AbstractOperation;
import resonant.lib.transform.ITransform;
import resonant.lib.transform.rotation.AngleAxis;
import resonant.lib.transform.rotation.EulerAngle$;
import resonant.lib.transform.rotation.Quaternion;
import resonant.lib.transform.vector.Vector3;
import scala.Cloneable;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!B\u0001\u0003\u0011\u0003Y\u0011AC#vY\u0016\u0014\u0018I\\4mK*\u00111\u0001B\u0001\te>$\u0018\r^5p]*\u0011QAB\u0001\niJ\fgn\u001d4pe6T!a\u0002\u0005\u0002\u00071L'MC\u0001\n\u0003!\u0011Xm]8oC:$8\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u000b\u000bVdWM]!oO2,7CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u000655!\taG\u0001\u0010C:<G.\u001a#jM\u001a,'/\u001a8dKR\u0019AdH\u0011\u0011\u0005Ei\u0012B\u0001\u0010\u0013\u0005\u0019!u.\u001e2mK\")\u0001%\u0007a\u00019\u00051\u0011M\\4mK\u0006CQAI\rA\u0002q\ta!\u00198hY\u0016\u0014\u0005\"\u0002\u0013\u000e\t\u0003)\u0013aD2mC6\u0004\u0018I\\4mKR{7G\u000e\u0019\u0015\u0005q1\u0003\"B\u0014$\u0001\u0004a\u0012!\u0002<bYV,\u0007\"B\u0015\u000e\t\u0003Q\u0013aD2mC6\u0004\u0018I\\4mKR{\u0017\u0007\u000f\u0019\u0015\u0005qY\u0003\"B\u0014)\u0001\u0004a\u0002\"B\u0017\u000e\t\u0003q\u0013AC2mC6\u0004\u0018I\\4mKR!Ad\f\u00193\u0011\u00159C\u00061\u0001\u001d\u0011\u0015\tD\u00061\u0001\u001d\u0003\ri\u0017N\u001c\u0005\u0006g1\u0002\r\u0001H\u0001\u0004[\u0006Dh\u0001\u0002\b\u0003\u0001U\u001aB\u0001\u000e\u001c<}A\u0019q\u0007\u000f\u001e\u000e\u0003\u0011I!!\u000f\u0003\u0003#\u0005\u00137\u000f\u001e:bGR|\u0005/\u001a:bi&|g\u000e\u0005\u0002\riA\u0011\u0011\u0003P\u0005\u0003{I\u0011\u0011b\u00117p]\u0016\f'\r\\3\u0011\u0005]z\u0014B\u0001!\u0005\u0005)IEK]1og\u001a|'/\u001c\u0005\t\u0005R\u0012\t\u0019!C\u0001\u0007\u0006\u0019\u00110Y<\u0016\u0003qA\u0001\"\u0012\u001b\u0003\u0002\u0004%\tAR\u0001\bs\u0006<x\fJ3r)\t9%\n\u0005\u0002\u0012\u0011&\u0011\u0011J\u0005\u0002\u0005+:LG\u000fC\u0004L\t\u0006\u0005\t\u0019\u0001\u000f\u0002\u0007a$\u0013\u0007\u0003\u0005Ni\t\u0005\t\u0015)\u0003\u001d\u0003\u0011I\u0018m\u001e\u0011\t\u0011=#$\u00111A\u0005\u0002\r\u000bQ\u0001]5uG\"D\u0001\"\u0015\u001b\u0003\u0002\u0004%\tAU\u0001\na&$8\r[0%KF$\"aR*\t\u000f-\u0003\u0016\u0011!a\u00019!AQ\u000b\u000eB\u0001B\u0003&A$\u0001\u0004qSR\u001c\u0007\u000e\t\u0005\t/R\u0012\t\u0019!C\u0001\u0007\u0006!!o\u001c7m\u0011!IFG!a\u0001\n\u0003Q\u0016\u0001\u0003:pY2|F%Z9\u0015\u0005\u001d[\u0006bB&Y\u0003\u0003\u0005\r\u0001\b\u0005\t;R\u0012\t\u0011)Q\u00059\u0005)!o\u001c7mA!)q\u0003\u000eC\u0001?R!!\bY1c\u0011\u0015\u0011e\f1\u0001\u001d\u0011\u0015ye\f1\u0001\u001d\u0011\u00159f\f1\u0001\u001d\u0011\u00159B\u0007\"\u0001e)\rQTM\u001a\u0005\u0006\u0005\u000e\u0004\r\u0001\b\u0005\u0006\u001f\u000e\u0004\r\u0001\b\u0005\u0006/Q\"\t\u0001\u001b\u000b\u0003u%DQA[4A\u0002-\f1\u0001Z5s!\taW/D\u0001n\u0015\tqw.\u0001\u0003vi&d'B\u00019r\u0003\u0019\u0019w.\\7p]*\u0011!o]\u0001\u000f[&tWm\u0019:bMR4wN]4f\u0015\u0005!\u0018a\u00018fi&\u0011a/\u001c\u0002\u000f\r>\u0014x-\u001a#je\u0016\u001cG/[8o\u0011\u0015AH\u0007\"\u0001z\u0003\r\u0019X\r\u001e\u000b\u0005\u000fj\\H\u0010C\u0003Co\u0002\u0007A\u0004C\u0003Po\u0002\u0007A\u0004C\u0003Xo\u0002\u0007A\u0004C\u0003yi\u0011\u0005c\u0010\u0006\u0002;\u007f\"1\u0011\u0011A?A\u0002i\nQa\u001c;iKJDq!!\u00025\t\u0003\n9!A\u0003%a2,8\u000fF\u0002;\u0003\u0013Aq!!\u0001\u0002\u0004\u0001\u0007A\u0004C\u0004\u0002\u0006Q\"\t%!\u0004\u0015\u0007i\ny\u0001C\u0004\u0002\u0002\u0005-\u0001\u0019\u0001\u001e\t\u000f\u0005MA\u0007\"\u0011\u0002\u0016\u00051A\u0005^5nKN$2AOA\f\u0011\u001d\t\t!!\u0005A\u0002qAq!a\u00055\t\u0003\nY\u0002F\u0002;\u0003;Aq!!\u0001\u0002\u001a\u0001\u0007!\bC\u0004\u0002\"Q\"\t%a\t\u0002\u0015I,7-\u001b9s_\u000e\fG\u000eF\u0001;\u0011\u001d\t9\u0003\u000eC\u0001\u0003S\tAaY3jYV\t!\bC\u0004\u0002.Q\"\t!!\u000b\u0002\u000b\u0019dwn\u001c:\t\u000f\u0005EB\u0007\"\u0001\u0002*\u0005)!o\\;oI\"11\u0007\u000eC\u0001\u0003k!2AOA\u001c\u0011\u001d\t\t!a\rA\u0002iBa!\r\u001b\u0005\u0002\u0005mBc\u0001\u001e\u0002>!9\u0011\u0011AA\u001d\u0001\u0004Q\u0004bBA!i\u0011\u0005\u00111I\u0001\u0013C\n\u001cx\u000e\\;uK\u0012KgMZ3sK:\u001cW\rF\u0002;\u0003\u000bBq!!\u0001\u0002@\u0001\u0007!\bC\u0004\u0002JQ\"\t!a\u0013\u0002\u0011%\u001cx+\u001b;iS:$b!!\u0014\u0002T\u0005U\u0003cA\t\u0002P%\u0019\u0011\u0011\u000b\n\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011AA$\u0001\u0004Q\u0004bBA,\u0003\u000f\u0002\r\u0001H\u0001\u0007[\u0006\u0014x-\u001b8\t\r\u0015!D\u0011IA.)\u0011\ti&!\u001b\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019\u0005\u0003\u00191Xm\u0019;pe&!\u0011qMA1\u0005\u001d1Vm\u0019;peNB\u0001\"a\u0019\u0002Z\u0001\u0007\u0011Q\f\u0005\b\u0003[\"D\u0011AA8\u0003!!xNV3di>\u0014XCAA/\u0011\u001d\t\u0019\b\u000eC\u0001\u0003k\n1\u0002^8B]\u001edW-\u0011=jgV\u0011\u0011q\u000f\t\u0004\u0019\u0005e\u0014bAA>\u0005\tI\u0011I\\4mK\u0006C\u0018n\u001d\u0005\b\u0003\u007f\"D\u0011AAA\u00031!x.U;bi\u0016\u0014h.[8o+\t\t\u0019\tE\u0002\r\u0003\u000bK1!a\"\u0003\u0005)\tV/\u0019;fe:LwN\u001c\u0005\b\u0003\u0017#D\u0011AAG\u0003\u001d!x\u000eV;qY\u0016,\"!a$\u0011\rE\t\t\n\b\u000f\u001d\u0013\r\t\u0019J\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000f\u0005]E\u0007\"\u0011\u0002$\u0005)1\r\\8oK\"9\u00111\u0014\u001b\u0005B\u0005u\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0005\u0003BAQ\u0003Os1!EAR\u0013\r\t)KE\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00161\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015&\u0003C\u0004\u00020R\"\t%!-\u0002\u0019]\u0014\u0018\u000e^3CsR,')\u001e4\u0015\t\u0005M\u0016q\u0019\t\u0005\u0003k\u000b\u0019-\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0019\u0011WO\u001a4fe*!\u0011QXA`\u0003\u0015qW\r\u001e;z\u0015\t\t\t-\u0001\u0002j_&!\u0011QYA\\\u0005\u001d\u0011\u0015\u0010^3Ck\u001aD\u0001\"!3\u0002.\u0002\u0007\u00111W\u0001\u0005I\u0006$\u0018\rC\u0004\u0002NR\"\t%a4\u0002\u0011]\u0014\u0018\u000e^3O\u0005R#B!!5\u0002bB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017a\u00018ci*\u0019\u00111\\:\u0002\u00135Lg.Z2sC\u001a$\u0018\u0002BAp\u0003+\u0014aB\u0014\"U)\u0006<7i\\7q_VtG\r\u0003\u0005\u0002X\u0006-\u0007\u0019AAi\u0001")
public class EulerAngle
extends AbstractOperation<EulerAngle>
implements Cloneable,
ITransform {
    private double yaw;
    private double pitch;
    private double roll;

    public static double clampAngle(double d, double d2, double d3) {
        return EulerAngle$.MODULE$.clampAngle(d, d2, d3);
    }

    public static double clampAngleTo180(double d) {
        return EulerAngle$.MODULE$.clampAngleTo180(d);
    }

    public static double clampAngleTo360(double d) {
        return EulerAngle$.MODULE$.clampAngleTo360(d);
    }

    public static double angleDifference(double d, double d2) {
        return EulerAngle$.MODULE$.angleDifference(d, d2);
    }

    public double yaw() {
        return this.yaw;
    }

    public void yaw_$eq(double x$1) {
        this.yaw = x$1;
    }

    public double pitch() {
        return this.pitch;
    }

    public void pitch_$eq(double x$1) {
        this.pitch = x$1;
    }

    public double roll() {
        return this.roll;
    }

    public void roll_$eq(double x$1) {
        this.roll = x$1;
    }

    public void set(double yaw, double pitch, double roll) {
        this.yaw_$eq(yaw);
        this.pitch_$eq(pitch);
        this.roll_$eq(roll);
    }

    @Override
    public EulerAngle set(EulerAngle other) {
        this.yaw_$eq(other.yaw());
        this.pitch_$eq(other.pitch());
        this.roll_$eq(other.roll());
        return this;
    }

    @Override
    public EulerAngle $plus(double other) {
        return new EulerAngle(this.yaw() + other, this.pitch() + other, this.roll() + other);
    }

    @Override
    public EulerAngle $plus(EulerAngle other) {
        return new EulerAngle(this.yaw() + other.yaw(), this.pitch() + other.pitch(), this.roll() + other.roll());
    }

    @Override
    public EulerAngle $times(double other) {
        return new EulerAngle(this.yaw() * other, this.pitch() * other, this.roll() * other);
    }

    @Override
    public EulerAngle $times(EulerAngle other) {
        return new EulerAngle(this.yaw() * other.yaw(), this.pitch() * other.pitch(), this.roll() * other.roll());
    }

    @Override
    public EulerAngle reciprocal() {
        return new EulerAngle(1.0 / this.yaw(), 1.0 / this.pitch(), 1.0 / this.roll());
    }

    @Override
    public EulerAngle ceil() {
        return new EulerAngle(Math.ceil(this.yaw()), Math.ceil(this.pitch()), Math.ceil(this.roll()));
    }

    @Override
    public EulerAngle floor() {
        return new EulerAngle(Math.floor(this.yaw()), Math.floor(this.pitch()), Math.floor(this.roll()));
    }

    @Override
    public EulerAngle round() {
        return new EulerAngle(Math.round(this.yaw()), Math.round(this.pitch()), Math.round(this.roll()));
    }

    @Override
    public EulerAngle max(EulerAngle other) {
        return new EulerAngle(Math.max(this.yaw(), other.yaw()), Math.max(this.pitch(), other.pitch()), Math.max(this.roll(), other.roll()));
    }

    @Override
    public EulerAngle min(EulerAngle other) {
        return new EulerAngle(Math.min(this.yaw(), other.yaw()), Math.min(this.pitch(), other.pitch()), Math.min(this.roll(), other.roll()));
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(EulerAngle$.MODULE$.angleDifference(this.yaw(), other.yaw()), EulerAngle$.MODULE$.angleDifference(this.pitch(), other.pitch()), EulerAngle$.MODULE$.angleDifference(this.roll(), other.roll()));
    }

    public boolean isWithin(EulerAngle other, double margin) {
        return this.absoluteDifference(other).toTuple().productIterator().exists((Function1)new Serializable(this, margin){
            private final double margin$1;

            public final boolean apply(Object i) {
                return BoxesRunTime.unboxToDouble((Object)i) > this.margin$1;
            }
            {
                this.margin$1 = margin$1;
            }
        });
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        return vector.transform(this.toQuaternion());
    }

    public Vector3 toVector() {
        return new Vector3(-Math.sin(this.yaw()) * Math.cos(this.pitch()), Math.sin(this.pitch()), -Math.cos(this.yaw()) * Math.cos(this.pitch()));
    }

    public AngleAxis toAngleAxis() {
        double c1 = Math.cos(this.yaw() / (double)2);
        double s1 = Math.sin(this.yaw() / (double)2);
        double c2 = Math.cos(this.pitch() / (double)2);
        double s2 = Math.sin(this.pitch() / (double)2);
        double c3 = Math.cos(this.roll() / (double)2);
        double s3 = Math.sin(this.roll() / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        double angle = (double)2 * Math.acos(w);
        Vector3 axis = new Vector3(x, y, z);
        axis = axis.magnitudeSquared() < 0.001 ? new Vector3(0.0, 0.0, -1.0) : (Vector3)axis.normalize();
        return new AngleAxis(angle, axis);
    }

    public Quaternion toQuaternion() {
        double c1 = Math.cos(Math.toRadians(this.yaw()) / (double)2);
        double s1 = Math.sin(Math.toRadians(this.yaw()) / (double)2);
        double c2 = Math.cos(Math.toRadians(this.pitch()) / (double)2);
        double s2 = Math.sin(Math.toRadians(this.pitch()) / (double)2);
        double c3 = Math.cos(Math.toRadians(this.roll()) / (double)2);
        double s3 = Math.sin(Math.toRadians(this.roll()) / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, x, y, z);
    }

    public Tuple3<Object, Object, Object> toTuple() {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.yaw()), (Object)BoxesRunTime.boxToDouble((double)this.pitch()), (Object)BoxesRunTime.boxToDouble((double)this.roll()));
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw(), this.pitch(), this.roll());
    }

    public String toString() {
        return new StringBuilder().append((Object)"EulerAngle[").append((Object)BoxesRunTime.boxToDouble((double)this.yaw())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.pitch())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.roll())).append((Object)"]").toString();
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.yaw());
        data.writeDouble(this.pitch());
        return data.writeDouble(this.roll());
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.yaw());
        nbt.func_74780_a("pitch", this.pitch());
        nbt.func_74780_a("roll", this.roll());
        return nbt;
    }

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    public EulerAngle(ForgeDirection dir) {
        this(0.0, 0.0, 0.0);
        ForgeDirection forgeDirection = dir;
        if (ForgeDirection.DOWN.equals(forgeDirection)) {
            this.set(0.0, -90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.UP.equals(forgeDirection)) {
            this.set(0.0, 90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.NORTH.equals(forgeDirection)) {
            this.set(0.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.SOUTH.equals(forgeDirection)) {
            this.set(180.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.WEST.equals(forgeDirection)) {
            this.set(90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.EAST.equals(forgeDirection)) {
            this.set(-90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

