/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.transform.rotation;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import resonant.lib.transform.ITransform;
import resonant.lib.transform.vector.Vector3;
import scala.Cloneable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001-\u0011!\"U;bi\u0016\u0014h.[8o\u0015\t\u0019A!\u0001\u0005s_R\fG/[8o\u0015\t)a!A\u0005ue\u0006t7OZ8s[*\u0011q\u0001C\u0001\u0004Y&\u0014'\"A\u0005\u0002\u0011I,7o\u001c8b]R\u001c\u0001a\u0005\u0003\u0001\u0019QQ\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0013\rcwN\\3bE2,\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005)IEK]1og\u001a|'/\u001c\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\tAq\u0001\n\u0001A\u0002\u0013\u0005Q%A\u0001y+\u00051\u0003CA\u000b(\u0013\tAcC\u0001\u0004E_V\u0014G.\u001a\u0005\bU\u0001\u0001\r\u0011\"\u0001,\u0003\u0015Ax\fJ3r)\tas\u0006\u0005\u0002\u0016[%\u0011aF\u0006\u0002\u0005+:LG\u000fC\u00041S\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013\u0007\u0003\u00043\u0001\u0001\u0006KAJ\u0001\u0003q\u0002Bq\u0001\u000e\u0001A\u0002\u0013\u0005Q%A\u0001z\u0011\u001d1\u0004\u00011A\u0005\u0002]\nQ!_0%KF$\"\u0001\f\u001d\t\u000fA*\u0014\u0011!a\u0001M!1!\b\u0001Q!\n\u0019\n!!\u001f\u0011\t\u000fq\u0002\u0001\u0019!C\u0001K\u0005\t!\u0010C\u0004?\u0001\u0001\u0007I\u0011A \u0002\u000bi|F%Z9\u0015\u00051\u0002\u0005b\u0002\u0019>\u0003\u0003\u0005\rA\n\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0014\u0002\u0005i\u0004\u0003b\u0002#\u0001\u0001\u0004%\t!J\u0001\u0002o\"9a\t\u0001a\u0001\n\u00039\u0015!B<`I\u0015\fHC\u0001\u0017I\u0011\u001d\u0001T)!AA\u0002\u0019BaA\u0013\u0001!B\u00131\u0013AA<!\u0011\u0015y\u0002\u0001\"\u0001M)\t\tS\nC\u0003O\u0017\u0002\u0007\u0011%\u0001\u0006Rk\u0006$XM\u001d8j_:DQa\b\u0001\u0005\u0002A#2!I)T\u0011\u0015\u0011v\n1\u0001'\u0003\u0015\tgn\u001a7f\u0011\u0015!v\n1\u0001V\u0003\u0011\t\u00070[:\u0011\u0005YKV\"A,\u000b\u0005a#\u0011A\u0002<fGR|'/\u0003\u0002[/\n9a+Z2u_J\u001c\u0004\"B\u0010\u0001\t\u0003aF#B\u0011^?\u0006\u001c\u0007\"\u00020\\\u0001\u00041\u0013!\u00013\t\u000b\u0001\\\u0006\u0019\u0001\u0014\u0002\u0005\u0011\f\u0004\"\u00022\\\u0001\u00041\u0013A\u000133\u0011\u0015!7\f1\u0001'\u0003\t!7\u0007C\u0003g\u0001\u0011\u0005q-A\u0002tKR$\"!\t5\t\u000b%,\u0007\u0019A\u0011\u0002\u0003EDQA\u001a\u0001\u0005\u0002-$R!\t7n]>DQA\u00186A\u0002\u0019BQ\u0001\u00196A\u0002\u0019BQA\u00196A\u0002\u0019BQ\u0001\u001a6A\u0002\u0019BQ!\u001d\u0001\u0005\u0002I\fQb]3u\u0003J|WO\u001c3Bq&\u001cH#B\u0011tk^L\b\"\u0002;q\u0001\u00041\u0013AA1y\u0011\u00151\b\u000f1\u0001'\u0003\t\t\u0017\u0010C\u0003ya\u0002\u0007a%\u0001\u0002bu\")!\u0010\u001da\u0001M\u0005iqN]5hS:\fG.\u00118hY\u0016DQ!\u001d\u0001\u0005\u0002q$2!I?\u007f\u0011\u0015!6\u00101\u0001V\u0011\u0015\u00116\u00101\u0001'\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t\u0001\"\\;mi&\u0004H.\u001f\u000b\u0004C\u0005\u0015\u0001\"\u0002(\u0000\u0001\u0004\t\u0003bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u000ee&<\u0007\u000e^'vYRL\u0007\u000f\\=\u0015\u0007\u0005\ni\u0001\u0003\u0004O\u0003\u000f\u0001\r!\t\u0005\u0007\u0003#\u0001A\u0011A\u0013\u0002\u00135\fwM\\5uk\u0012,\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\n]>\u0014X.\u00197ju\u0016,\u0012!\t\u0005\u0007\u00037\u0001A\u0011\t\u0011\u0002\u000b\rdwN\\3\t\r\u0015\u0001A\u0011IA\u0010)\r)\u0016\u0011\u0005\u0005\u00071\u0006u\u0001\u0019A+\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u0005AAo\\*ue&tw\r\u0006\u0002\u0002*A!\u00111FA\u0019\u001d\r)\u0012QF\u0005\u0004\u0003_1\u0012A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0005U\"AB*ue&twMC\u0002\u00020Y\u0001")
public class Quaternion
implements Cloneable,
ITransform {
    private double x = 1.0;
    private double y = 0.0;
    private double z = 0.0;
    private double w = 0.0;

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public double w() {
        return this.w;
    }

    public void w_$eq(double x$1) {
        this.w = x$1;
    }

    public Quaternion set(Quaternion q) {
        this.x_$eq(q.x());
        this.y_$eq(q.y());
        this.z_$eq(q.z());
        this.w_$eq(q.w());
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
        return this;
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double originalAngle) {
        double angle = originalAngle;
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(Vector3 axis, double angle) {
        return this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion multiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() - this.y() * Quaternion2.z() + this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() + this.x() * Quaternion2.z() + this.y() * Quaternion2.w() - this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() - this.x() * Quaternion2.y() + this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public Quaternion rightMultiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() + this.y() * Quaternion2.z() - this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() - this.x() * Quaternion2.z() + this.y() * Quaternion2.w() + this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() + this.x() * Quaternion2.y() - this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z() + this.w() * this.w());
    }

    public Quaternion normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x_$eq(this.x() * d);
            this.y_$eq(this.y() * d);
            this.z_$eq(this.z() * d);
            this.w_$eq(this.w() * d);
        }
        return this;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public Vector3 transform(Vector3 vector) {
        double d = -this.x() * vector.x() - this.y() * vector.y() - this.z() * vector.z();
        double d1 = this.w() * vector.x() + this.y() * vector.z() - this.z() * vector.y();
        double d2 = this.w() * vector.y() - this.x() * vector.z() + this.z() * vector.x();
        double d3 = this.w() * vector.z() + this.x() * vector.y() - this.y() * vector.x();
        return new Vector3(d1 * this.w() - d * this.x() - d2 * this.z() + d3 * this.y(), d2 * this.w() - d * this.y() + d1 * this.z() - d3 * this.x(), d3 * this.w() - d * this.z() - d1 * this.y() + d2 * this.x());
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Quaternion[").append((Object)new BigDecimal(this.w(), cont)).append((Object)", ").append((Object)new BigDecimal(this.x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.y(), cont)).append((Object)", ").append((Object)new BigDecimal(this.z(), cont)).append((Object)"]").toString();
    }

    public Quaternion() {
    }

    public Quaternion(Quaternion Quaternion2) {
        this();
        this.x_$eq(Quaternion2.x());
        this.y_$eq(Quaternion2.y());
        this.z_$eq(Quaternion2.z());
        this.w_$eq(Quaternion2.w());
    }

    public Quaternion(double angle, Vector3 axis) {
        this();
        this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this();
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
    }
}

