/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.transform.vector;

import com.google.common.io.ByteArrayDataInput;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.lib.transform.AbstractVector;
import resonant.lib.transform.ITransform;
import resonant.lib.transform.rotation.EulerAngle;
import resonant.lib.transform.vector.IVector3;
import resonant.lib.transform.vector.Vector2;
import resonant.lib.transform.vector.Vector3$;
import resonant.lib.transform.vector.Vector3$$anonfun$getAround$1$;
import scala.Cloneable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011]u!B\u0001\u0003\u0011\u0003Y\u0011a\u0002,fGR|'o\r\u0006\u0003\u0007\u0011\taA^3di>\u0014(BA\u0003\u0007\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\b\u0011\u0005\u0019A.\u001b2\u000b\u0003%\t\u0001B]3t_:\fg\u000e^\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005\u001d1Vm\u0019;peN\u001a\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0003\u001b\u001b\u0011\u00051$A\u0004hKRdun\\6\u0015\u000bq!y\u0007\"\u001d\u0011\u00051ib\u0001\u0002\b\u0003\u0001y\u0019B!H\u0010$MA\u0019\u0001%\t\u000f\u000e\u0003\u0011I!A\t\u0003\u0003\u001d\u0005\u00137\u000f\u001e:bGR4Vm\u0019;peB\u0011\u0011\u0003J\u0005\u0003KI\u0011\u0011b\u00117p]\u0016\f'\r\\3\u0011\u000519\u0013B\u0001\u0015\u0003\u0005!Ie+Z2u_J\u001c\u0004\u0002\u0003\u0016\u001e\u0005\u0003\u0007I\u0011A\u0016\u0002\u0003a,\u0012\u0001\f\t\u0003#5J!A\f\n\u0003\r\u0011{WO\u00197f\u0011!\u0001TD!a\u0001\n\u0003\t\u0014!\u0002=`I\u0015\fHC\u0001\u001a6!\t\t2'\u0003\u00025%\t!QK\\5u\u0011\u001d1t&!AA\u00021\n1\u0001\u001f\u00132\u0011!ATD!A!B\u0013a\u0013A\u0001=!\u0011!QTD!a\u0001\n\u0003Y\u0013!A=\t\u0011qj\"\u00111A\u0005\u0002u\nQ!_0%KF$\"A\r \t\u000fYZ\u0014\u0011!a\u0001Y!A\u0001)\bB\u0001B\u0003&A&\u0001\u0002zA!A!)\bBA\u0002\u0013\u00051&A\u0001{\u0011!!UD!a\u0001\n\u0003)\u0015!\u0002>`I\u0015\fHC\u0001\u001aG\u0011\u001d14)!AA\u00021B\u0001\u0002S\u000f\u0003\u0002\u0003\u0006K\u0001L\u0001\u0003u\u0002BQaF\u000f\u0005\u0002)#B\u0001H&M\u001b\")!&\u0013a\u0001Y!)!(\u0013a\u0001Y!)!)\u0013a\u0001Y!)q#\bC\u0001\u001fR\tA\u0004C\u0003\u0018;\u0011\u0005\u0011\u000b\u0006\u0002\u001d%\")1\u000b\u0015a\u0001Y\u00051\u0011-\\8v]RDQaF\u000f\u0005\u0002U#2\u0001\b,Y\u0011\u00159F\u000b1\u0001-\u0003\rI\u0018m\u001e\u0005\u00063R\u0003\r\u0001L\u0001\u0006a&$8\r\u001b\u0005\u0006/u!\ta\u0017\u000b\u00039qCQ!\u0018.A\u0002y\u000bA\u0001^5mKB\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\u000bi&dW-\u001a8uSRL(BA2e\u0003%i\u0017N\\3de\u00064GOC\u0001f\u0003\rqW\r^\u0005\u0003O\u0002\u0014!\u0002V5mK\u0016sG/\u001b;z\u0011\u00159R\u0004\"\u0001j)\ta\"\u000eC\u0003lQ\u0002\u0007A.\u0001\u0004f]RLG/\u001f\t\u0003[>l\u0011A\u001c\u0006\u0003W\nL!\u0001\u001d8\u0003\r\u0015sG/\u001b;z\u0011\u00159R\u0004\"\u0001s)\ta2\u000fC\u0003uc\u0002\u0007a%A\u0002wK\u000eDQaF\u000f\u0005\u0002Y$\"\u0001H<\t\u000bQ,\b\u0019\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m\u0014\u0017\u0001B;uS2L!! >\u0003\tY+7m\r\u0005\u0006/u!\ta \u000b\u00049\u0005\u0005\u0001bBA\u0002}\u0002\u0007\u0011QA\u0001\u0004]\n$\b\u0003BA\u0004\u0003\u0017i!!!\u0003\u000b\u0007\u0005\r!-\u0003\u0003\u0002\u000e\u0005%!A\u0004(C)R\u000bwmQ8na>,h\u000e\u001a\u0005\u0007/u!\t!!\u0005\u0015\u0007q\t\u0019\u0002\u0003\u0005\u0002\u0016\u0005=\u0001\u0019AA\f\u0003\u0011!\u0017\r^1\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u00051!-\u001e4gKJTA!!\t\u0002$\u0005)a.\u001a;us*\u0011\u0011QE\u0001\u0003S>LA!!\u000b\u0002\u001c\t9!)\u001f;f\u0005V4\u0007BB\f\u001e\t\u0003\ti\u0003F\u0002\u001d\u0003_A\u0001\"!\r\u0002,\u0001\u0007\u00111G\u0001\u0004I&\u0014\b\u0003BA\u001b\u0003\u0003j!!a\u000e\u000b\u0007m\fID\u0003\u0003\u0002<\u0005u\u0012AB2p[6|gNC\u0002\u0002@\u0011\fa\"\\5oK\u000e\u0014\u0018M\u001a;g_J<W-\u0003\u0003\u0002D\u0005]\"A\u0004$pe\u001e,G)\u001b:fGRLwN\u001c\u0005\u0007/u!\t!a\u0012\u0015\u0007q\tI\u0005\u0003\u0005\u0002L\u0005\u0015\u0003\u0019AA'\u0003\u0011\u0001\u0018M]\u0019\u0011\u0007e\fy%C\u0002\u0002Ri\u0014A#T8wS:<wJ\u00196fGR\u0004vn]5uS>t\u0007BB\f\u001e\t\u0003\t)\u0006F\u0002\u001d\u0003/B\u0001\"a\u0013\u0002T\u0001\u0007\u0011\u0011\f\t\u0004s\u0006m\u0013bAA/u\n\u00012\t[;oW\u000e{wN\u001d3j]\u0006$Xm\u001d\u0005\u0007/u!\t!!\u0019\u0015\u0007q\t\u0019\u0007\u0003\u0005\u0002f\u0005}\u0003\u0019AA4\u0003\r\u0001\u0018M\u001d\t\u0006\u0003S\nI\b\f\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\tHC\u0001\u0007yI|w\u000e\u001e \n\u0003MI1!a\u001e\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\t\u00191+Z9\u000b\u0007\u0005]$\u0003\u0003\u0004\u0018;\u0011\u0005\u0011\u0011\u0011\u000b\u00049\u0005\r\u0005\u0002CA3\u0003\u007f\u0002\r!!\"\u0011\rE\t9\t\f\u0017-\u0013\r\tII\u0005\u0002\u0007)V\u0004H.Z\u001a\t\r]iB\u0011AAG)\ra\u0012q\u0012\u0005\t\u0003+\tY\t1\u0001\u0002\u0012B!\u00111SAQ\u001b\t\t)J\u0003\u0003\u0002&\u0005]%\u0002BA\u001e\u00033SA!a'\u0002\u001e\u00061qm\\8hY\u0016T!!a(\u0002\u0007\r|W.\u0003\u0003\u0002$\u0006U%A\u0005\"zi\u0016\f%O]1z\t\u0006$\u0018-\u00138qkRDaAK\u000f\u0005\u0002\u0005\u001dFc\u0001\u001a\u0002*\"11+!*A\u00021BaAO\u000f\u0005\u0002\u00055Fc\u0001\u001a\u00020\"11+a+A\u00021BaAQ\u000f\u0005\u0002\u0005MFc\u0001\u001a\u00026\"11+!-A\u00021Bq!!/\u001e\t\u0003\nY,A\u0002tKR$2\u0001HA_\u0011\u0019!\u0018q\u0017a\u00019!9\u0011\u0011Y\u000f\u0005\u0002\u0005\r\u0017A\u0002;p-\u0016\u001c7'F\u0001y\u0011\u001d\t9-\bC\u0001\u0003\u0013\f\u0011\u0002^8WK\u000e$xN\u001d\u001a\u0016\u0005\u0005-\u0007c\u0001\u0007\u0002N&\u0019\u0011q\u001a\u0002\u0003\u000fY+7\r^8se!9\u00111[\u000f\u0005\u0002\u0005U\u0017a\u0002;p\u0003J\u0014\u0018-_\u000b\u0003\u0003/\u0004B!EAmY%\u0019\u00111\u001c\n\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005}W\u0004\"\u0001\u0002b\u00061Ao\u001c'jgR,\"!a9\u0011\u000b\u0005\u0015\u0018q\u001e\u0017\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u00055(#\u0001\u0006d_2dWm\u0019;j_:LA!!=\u0002h\n!A*[:u\u0011\u001d\t)0\bC\u0001\u0003o\f\u0011\u0002^8J]Rd\u0015n\u001d;\u0016\u0005\u0005e\bCBAs\u0003_\fY\u0010E\u0002\u0012\u0003{L1!a@\u0013\u0005\rIe\u000e\u001e\u0005\b\u0005\u0007iB\u0011\u0001B\u0003\u0003\u001d!x\u000eV;qY\u0016,\"!!\"\t\u000f\t%Q\u0004\"\u0001\u0003\f\u0005\u0001Bo\u001c$pe\u001e,G)\u001b:fGRLwN\\\u000b\u0003\u0003gAqAa\u0004\u001e\t\u0003\u0012\t\"\u0001\u0005xe&$XM\u0014\"U)\u0011\t)Aa\u0005\t\u0011\u0005\r!Q\u0002a\u0001\u0003\u000bAqAa\u0006\u001e\t\u0003\u0011I\"\u0001\u0005u_&sGO\u0014\"U+\t\t)\u0001C\u0004\u0003\u001eu!\tAa\b\u0002\u0017]\u0014\u0018\u000e^3J]Rt%\t\u0016\u000b\u0005\u0003\u000b\u0011\t\u0003\u0003\u0005\u0002\u0004\tm\u0001\u0019AA\u0003\u0011\u001d\u0011)#\bC!\u0005O\tAb\u001e:ji\u0016\u0014\u0015\u0010^3Ck\u001a$B!a\u0006\u0003*!A\u0011Q\u0003B\u0012\u0001\u0004\t9\u0002C\u0004\u0003.u!\tAa\f\u0002\u0019Q|W)\u001e7fe\u0006sw\r\\3\u0016\u0005\tE\u0002\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\u0007\t]B!\u0001\u0005s_R\fG/[8o\u0013\u0011\u0011YD!\u000e\u0003\u0015\u0015+H.\u001a:B]\u001edW\rC\u0004\u0003.u!\tAa\u0010\u0015\t\tE\"\u0011\t\u0005\b\u0005\u0007\u0012i\u00041\u0001\u001d\u0003\u0019!\u0018M]4fi\"9!qI\u000f\u0005\u0002\t%\u0013A\u0001=j+\t\tY\u0010C\u0004\u0003Nu!\tA!\u0013\u0002\u0005eL\u0007b\u0002B);\u0011\u0005!\u0011J\u0001\u0003u&DqA!\u0016\u001e\t\u0003\u00119&\u0001\u0002yMV\u0011!\u0011\f\t\u0004#\tm\u0013b\u0001B/%\t)a\t\\8bi\"9!\u0011M\u000f\u0005\u0002\t]\u0013AA=g\u0011\u001d\u0011)'\bC\u0001\u0005/\n!A\u001f4\t\u000f\t%T\u0004\"\u0011\u0003l\u0005)!o\\;oIV\tA\u0004C\u0004\u0003pu!\tEa\u001b\u0002\t\r,\u0017\u000e\u001c\u0005\b\u0005gjB\u0011\tB6\u0003\u00151Gn\\8s\u0011\u001d\u00119(\bC\u0001\u0005s\n1!\\1y)\ra\"1\u0010\u0005\b\u0005{\u0012)\b1\u0001\u001d\u0003\u0015yG\u000f[3s\u0011\u001d\u0011\t)\bC\u0001\u0005\u0007\u000b1!\\5o)\ra\"Q\u0011\u0005\b\u0005{\u0012y\b1\u0001\u001d\u0011\u0019\u0011I)\bC!\u001f\u0006Q!/Z2jaJ|7-\u00197\t\u000f\t5U\u0004\"\u0011\u0003\u0010\u00061A%\\5okN$2\u0001\bBI\u0011\u0019\u0019&1\u0012a\u0001Y!9!QR\u000f\u0005B\tUEc\u0001\u000f\u0003\u0018\"11Ka%A\u0002qAqA!$\u001e\t\u0003\u0011Y\nF\u0004\u001d\u0005;\u0013yJ!)\t\r)\u0012I\n1\u0001-\u0011\u0019Q$\u0011\u0014a\u0001Y!1!I!'A\u00021BqA!*\u001e\t\u0003\u00119+A\u0005%[&tWo\u001d\u0013fcR9AD!+\u0003,\n5\u0006B\u0002\u0016\u0003$\u0002\u0007A\u0006\u0003\u0004;\u0005G\u0003\r\u0001\f\u0005\u0007\u0005\n\r\u0006\u0019\u0001\u0017\t\u000f\tEV\u0004\"\u0001\u00034\u0006A1/\u001e2ue\u0006\u001cG\u000fF\u0004\u001d\u0005k\u00139L!/\t\r)\u0012y\u000b1\u0001-\u0011\u0019Q$q\u0016a\u0001Y!1!Ia,A\u00021BqA!0\u001e\t\u0003\u0011y,A\u0005tk\n,\u0015/^1mgR9AD!1\u0003D\n\u0015\u0007B\u0002\u0016\u0003<\u0002\u0007A\u0006\u0003\u0004;\u0005w\u0003\r\u0001\f\u0005\u0007\u0005\nm\u0006\u0019\u0001\u0017\t\u000f\t5U\u0004\"\u0001\u0003JR\u0019ADa3\t\u000fM\u00139\r1\u0001\u00024!9!QU\u000f\u0005\u0002\t=Gc\u0001\u000f\u0003R\"91K!4A\u0002\u0005M\u0002b\u0002BY;\u0011\u0005!Q\u001b\u000b\u00049\t]\u0007bB*\u0003T\u0002\u0007\u00111\u0007\u0005\b\u0005{kB\u0011\u0001Bn)\ra\"Q\u001c\u0005\b'\ne\u0007\u0019AA\u001a\u0011\u001d\u0011\t/\bC!\u0005G\fQ\u0001\n9mkN$2\u0001\bBs\u0011\u0019\u0019&q\u001ca\u0001Y!9!\u0011]\u000f\u0005B\t%Hc\u0001\u000f\u0003l\"11Ka:A\u0002qAqA!9\u001e\t\u0003\u0011y\u000fF\u0004\u001d\u0005c\u0014\u0019P!>\t\r)\u0012i\u000f1\u0001-\u0011\u0019Q$Q\u001ea\u0001Y!1!I!<A\u00021BqA!?\u001e\t\u0003\u0011Y0\u0001\u0005%a2,8\u000fJ3r)\u001da\"Q B\u0000\u0007\u0003AaA\u000bB|\u0001\u0004a\u0003B\u0002\u001e\u0003x\u0002\u0007A\u0006\u0003\u0004C\u0005o\u0004\r\u0001\f\u0005\b\u0007\u000biB\u0011AB\u0004\u0003\r\tG\r\u001a\u000b\b9\r%11BB\u0007\u0011\u0019Q31\u0001a\u0001Y!1!ha\u0001A\u00021BaAQB\u0002\u0001\u0004a\u0003bBB\t;\u0011\u000511C\u0001\nC\u0012$W)];bYN$r\u0001HB\u000b\u0007/\u0019I\u0002\u0003\u0004+\u0007\u001f\u0001\r\u0001\f\u0005\u0007u\r=\u0001\u0019\u0001\u0017\t\r\t\u001by\u00011\u0001-\u0011\u001d\u0011\t/\bC\u0001\u0007;!2\u0001HB\u0010\u0011\u001d\u001961\u0004a\u0001\u0003gAqA!?\u001e\t\u0003\u0019\u0019\u0003F\u0002\u001d\u0007KAqaUB\u0011\u0001\u0004\t\u0019\u0004C\u0004\u0004\u0006u!\ta!\u000b\u0015\u0007q\u0019Y\u0003C\u0004T\u0007O\u0001\r!a\r\t\u000f\rEQ\u0004\"\u0001\u00040Q\u0019Ad!\r\t\u000fM\u001bi\u00031\u0001\u00024!91QG\u000f\u0005B\r]\u0012A\u0002\u0013uS6,7\u000fF\u0002\u001d\u0007sAaaUB\u001a\u0001\u0004a\u0003bBB\u001b;\u0011\u00053Q\b\u000b\u00049\r}\u0002BB*\u0004<\u0001\u0007A\u0004C\u0004\u0004Du!\te!\u0012\u0002\u0003\u0011\"2\u0001LB$\u0011\u001d\u0011ih!\u0011A\u0002qAqaa\u0013\u001e\t\u0003\u0019i%A\u0003de>\u001c8\u000fF\u0002\u001d\u0007\u001fBqA! \u0004J\u0001\u0007A\u0004C\u0004\u0004Tu!\ta!\u0016\u0002\u0011\u0011\u0002XM]2f]R$2\u0001HB,\u0011\u001d\u0011ih!\u0015A\u0002qAqaa\u0017\u001e\t\u0003\u0011Y'\u0001\u0004y\u0007J|7o\u001d\u0005\b\u0007?jB\u0011\u0001B6\u0003\u0019Q8I]8tg\"911M\u000f\u0005\u0002\r\u0015\u0014\u0001C7jIB{\u0017N\u001c;\u0015\u0007q\u00199\u0007C\u0004\u0004j\r\u0005\u0004\u0019\u0001\u000f\u0002\u0007A|7\u000fC\u0004\u0004nu!\tAa\u001b\u0002\u001bA,'\u000f]3oI&\u001cW\u000f\\1s\u0011\u001d\u0019\t(\bC\u0001\u0007g\na![:[KJ|WCAB;!\r\t2qO\u0005\u0004\u0007s\u0012\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u000bu!\ta! \u0015\u0007q\u0019y\b\u0003\u0005\u0004\u0002\u000em\u0004\u0019ABB\u0003-!(/\u00198tM>\u0014X.\u001a:\u0011\u0007\u0001\u001a))C\u0002\u0004\b\u0012\u0011!\"\u0013+sC:\u001chm\u001c:n\u0011\u001d\u0019Y)\bC\u0001\u0007\u001b\u000bQ!\u00198hY\u0016$2\u0001LBH\u0011\u001d\u0011ih!#A\u0002qAqaa%\u001e\t\u0003\u0019)*\u0001\u0007b]\u001edW\r\u0015:f\u001d>\u0014X\u000eF\u0002-\u0007/CqA! \u0004\u0012\u0002\u0007A\u0004C\u0004\u0004\u001cv!\ta!(\u0002\u0013\u001d,G/\u0011:pk:$G\u0003CBP\u0007W\u001bIl!0\u0011\u000b\r\u00056\u0011\u0016\u000f\u000e\u0005\r\r&bA>\u0004&*\u00111qU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002r\u000e\r\u0006\u0002CBW\u00073\u0003\raa,\u0002\u000b]|'\u000f\u001c3\u0011\t\rE6QW\u0007\u0003\u0007gS1a!,c\u0013\u0011\u00199la-\u0003\u000b]{'\u000f\u001c3\t\u0011\rm6\u0011\u0014a\u0001\u0003g\tAa]5eK\"A1qXBM\u0001\u0004\tY0A\u0003sC:<W\rC\u0004\u0004Dv!\ta!2\u0002\u0011I\f\u0017\u0010\u0016:bG\u0016$\u0002\"!\u0014\u0004H\u000e%71\u001a\u0005\t\u0007[\u001b\t\r1\u0001\u00040\"9\u0011\u0011GBa\u0001\u0004a\u0002bBBg\u0007\u0003\u0004\r\u0001L\u0001\u0005I&\u001cH\u000fC\u0004\u0004Dv!\ta!5\u0015\r\u0005531[Bk\u0011!\u0019ika4A\u0002\r=\u0006bBBl\u0007\u001f\u0004\r\u0001H\u0001\u0004K:$\u0007bBBn;\u0011\u00051Q\\\u0001\u000fe\u0006LHK]1dK\ncwnY6t)\u0019\tiea8\u0004b\"A1QVBm\u0001\u0004\u0019y\u000bC\u0004\u0004X\u000ee\u0007\u0019\u0001\u000f\t\u000f\r\u0015X\u0004\"\u0001\u0004h\u0006\u0001\"/Y=Ue\u0006\u001cW-\u00128uSRLWm\u001d\u000b\u0007\u0003\u001b\u001aIoa;\t\u0011\r561\u001da\u0001\u0007_Cqaa6\u0004d\u0002\u0007A\u0004C\u0004\u0004pv!\ta!=\u0002\u0011\u001d,GO\u00117pG.$Baa=\u0004\u0000B!1Q_B~\u001b\t\u00199PC\u0002\u0004z\n\fQA\u00197pG.LAa!@\u0004x\n)!\t\\8dW\"A1QVBw\u0001\u0004!\t\u0001\u0005\u0003\u00042\u0012\r\u0011\u0002\u0002C\u0003\u0007g\u0013A\"\u0013\"m_\u000e\\\u0017iY2fgNDq\u0001\"\u0003\u001e\t\u0003!Y!\u0001\thKR\u0014En\\2l\u001b\u0016$\u0018\rZ1uCR!\u00111 C\u0007\u0011!\u0019i\u000bb\u0002A\u0002\u0011\u0005\u0001b\u0002C\t;\u0011\u0005A1C\u0001\u000eO\u0016$H+\u001b7f\u000b:$\u0018\u000e^=\u0015\u0007y#)\u0002\u0003\u0005\u0004.\u0012=\u0001\u0019\u0001C\u0001\u0011\u001d!I\"\bC\u0001\t7\t\u0001b]3u\u00052|7m\u001b\u000b\u000b\u0007k\"i\u0002b\b\u0005\"\u0011\u0015\u0002\u0002CBW\t/\u0001\raa,\t\u0011\reHq\u0003a\u0001\u0007gD\u0001\u0002b\t\u0005\u0018\u0001\u0007\u00111`\u0001\t[\u0016$\u0018\rZ1uC\"AAq\u0005C\f\u0001\u0004\tY0\u0001\u0004o_RLg-\u001f\u0005\b\t3iB\u0011\u0001C\u0016)!\u0019)\b\"\f\u00050\u0011E\u0002\u0002CBW\tS\u0001\raa,\t\u0011\reH\u0011\u0006a\u0001\u0007gD\u0001\u0002b\t\u0005*\u0001\u0007\u00111 \u0005\b\t3iB\u0011\u0001C\u001b)\u0019\u0019)\bb\u000e\u0005:!A1Q\u0016C\u001a\u0001\u0004\u0019y\u000b\u0003\u0005\u0004z\u0012M\u0002\u0019ABz\u0011\u001d!i$\bC\u0001\t\u007f\tQb]3u\u00052|7m\u001b+p\u0003&\u0014H\u0003BB;\t\u0003B\u0001b!,\u0005<\u0001\u00071q\u0016\u0005\b\t\u000bjB\u0011\tC$\u0003!A\u0017m\u001d5D_\u0012,GCAA~\u0011\u001d!Y%\bC!\t\u001b\na!Z9vC2\u001cH\u0003BB;\t\u001fB\u0001\u0002\"\u0015\u0005J\u0001\u0007A1K\u0001\u0002_B\u0019\u0011\u0003\"\u0016\n\u0007\u0011]#CA\u0002B]fDa\u0001b\u0017\u001e\t\u0003z\u0015!B2m_:,\u0007b\u0002C0;\u0011\u0005C\u0011M\u0001\ti>\u001cFO]5oOR\u0011A1\r\t\u0005\tK\"Y'\u0004\u0002\u0005h)!A\u0011NBS\u0003\u0011a\u0017M\\4\n\t\u00115Dq\r\u0002\u0007'R\u0014\u0018N\\4\t\u000b-L\u0002\u0019\u00017\t\r\u0011M\u0014\u00041\u0001-\u0003!!\u0017n\u001d;b]\u000e,\u0007B\u0002\u000e\u000e\t\u0003!9\bF\u0004\u001d\ts\"Y\b\" \t\r]#)\b1\u0001-\u0011\u0019IFQ\u000fa\u0001Y!9A1\u000fC;\u0001\u0004a\u0003b\u0002CA\u001b\u0011\u0005!1N\u0001\u0003kBDq\u0001\"\"\u000e\t\u0003\u0011Y'\u0001\u0003e_^t\u0007b\u0002CE\u001b\u0011\u0005!1N\u0001\u0006]>\u0014H\u000f\u001b\u0005\b\t\u001bkA\u0011\u0001B6\u0003\u0015\u0019x.\u001e;i\u0011\u001d!\t*\u0004C\u0001\u0005W\nA!Z1ti\"9AQS\u0007\u0005\u0002\t-\u0014\u0001B<fgR\u0004")
public class Vector3
extends AbstractVector<Vector3>
implements Cloneable,
IVector3 {
    private double x;
    private double y;
    private double z;

    public static Vector3 west() {
        return Vector3$.MODULE$.west();
    }

    public static Vector3 east() {
        return Vector3$.MODULE$.east();
    }

    public static Vector3 south() {
        return Vector3$.MODULE$.south();
    }

    public static Vector3 north() {
        return Vector3$.MODULE$.north();
    }

    public static Vector3 down() {
        return Vector3$.MODULE$.down();
    }

    public static Vector3 up() {
        return Vector3$.MODULE$.up();
    }

    public static Vector3 getLook(double d, double d2, double d3) {
        return Vector3$.MODULE$.getLook(d, d2, d3);
    }

    public static Vector3 getLook(Entity entity, double d) {
        return Vector3$.MODULE$.getLook(entity, d);
    }

    @Override
    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    @Override
    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    @Override
    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public void x(double amount) {
        this.x_$eq(amount);
    }

    public void y(double amount) {
        this.y_$eq(amount);
    }

    public void z(double amount) {
        this.z_$eq(amount);
    }

    @Override
    public Vector3 set(Vector3 vec) {
        this.x_$eq(vec.x());
        this.y_$eq(vec.y());
        this.z_$eq(vec.z());
        return this;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x(), (double)this.y(), (double)this.z());
    }

    public Vector2 toVector2() {
        return new Vector2(this.x(), this.z());
    }

    public double[] toArray() {
        return new double[]{this.x(), this.y(), this.z()};
    }

    public List<Object> toList() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.x(), this.y(), this.z()}));
    }

    public List<Object> toIntList() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{(int)this.x(), (int)this.y(), (int)this.z()}));
    }

    public Tuple3<Object, Object, Object> toTuple() {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.x()), (Object)BoxesRunTime.boxToDouble((double)this.y()), (Object)BoxesRunTime.boxToDouble((double)this.z()));
    }

    public ForgeDirection toForgeDirection() {
        Option option = Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).find((Function1)new $anonfun$1(this));
        if (option instanceof Some) {
            Some some = (Some)option;
            ForgeDirection entry = (ForgeDirection)some.x();
            return entry;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    public NBTTagCompound toIntNBT() {
        return this.writeIntNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeIntNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", (int)this.x());
        nbt.func_74768_a("y", (int)this.y());
        nbt.func_74768_a("z", (int)this.z());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    public EulerAngle toEulerAngle() {
        return new EulerAngle(Math.toDegrees(Math.atan2(this.x(), this.z())), Math.toDegrees(-Math.atan2(this.y(), Math.hypot(this.z(), this.x()))));
    }

    public EulerAngle toEulerAngle(Vector3 target) {
        return this.clone().$minus(target).toEulerAngle();
    }

    public int xi() {
        return (int)this.x();
    }

    public int yi() {
        return (int)this.y();
    }

    public int zi() {
        return (int)this.z();
    }

    public float xf() {
        return (float)this.x();
    }

    public float yf() {
        return (float)this.y();
    }

    public float zf() {
        return (float)this.z();
    }

    @Override
    public Vector3 round() {
        return new Vector3(Math.round(this.x()), Math.round(this.y()), Math.round(this.z()));
    }

    @Override
    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x()), Math.ceil(this.y()), Math.ceil(this.z()));
    }

    @Override
    public Vector3 floor() {
        return new Vector3(Math.floor(this.x()), Math.floor(this.y()), Math.floor(this.z()));
    }

    @Override
    public Vector3 max(Vector3 other) {
        return new Vector3(Math.max(this.x(), other.x()), Math.max(this.y(), other.y()), Math.max(this.z(), other.z()));
    }

    @Override
    public Vector3 min(Vector3 other) {
        return new Vector3(Math.min(this.x(), other.x()), Math.min(this.y(), other.y()), Math.min(this.z(), other.z()));
    }

    @Override
    public Vector3 reciprocal() {
        return new Vector3(1.0 / this.x(), 1.0 / this.y(), 1.0 / this.z());
    }

    @Override
    public Vector3 $minus(double amount) {
        return new Vector3(this.x() - amount, this.y() - amount, this.z() - amount);
    }

    @Override
    public Vector3 $minus(Vector3 amount) {
        return new Vector3(this.x() - amount.x(), this.y() - amount.y(), this.z() - amount.z());
    }

    public Vector3 $minus(double x, double y, double z) {
        return new Vector3(this.x() - x, this.y() - y, this.z() - z);
    }

    public Vector3 $minus$eq(double x, double y, double z) {
        return this.set(new Vector3(this.x() - x, this.y() - y, this.z() - z));
    }

    public Vector3 subtract(double x, double y, double z) {
        this.x_$eq(this.x() - x);
        this.y_$eq(this.y() - y);
        this.z_$eq(this.z() - z);
        return this;
    }

    public Vector3 subEquals(double x, double y, double z) {
        return this.$minus$eq(x, y, z);
    }

    @Override
    public Vector3 $minus(ForgeDirection amount) {
        return this.$minus(new Vector3(amount));
    }

    @Override
    public Vector3 $minus$eq(ForgeDirection amount) {
        return this.set(this.$minus(new Vector3(amount)));
    }

    @Override
    public Vector3 subtract(ForgeDirection amount) {
        return this.$minus(amount);
    }

    public Vector3 subEquals(ForgeDirection amount) {
        return this.$minus$eq(amount);
    }

    @Override
    public Vector3 $plus(double amount) {
        return new Vector3(this.x() + amount, this.y() + amount, this.z() + amount);
    }

    @Override
    public Vector3 $plus(Vector3 amount) {
        return new Vector3(this.x() + amount.x(), this.y() + amount.y(), this.z() + amount.z());
    }

    public Vector3 $plus(double x, double y, double z) {
        return new Vector3(this.x() + x, this.y() + y, this.z() + z);
    }

    public Vector3 $plus$eq(double x, double y, double z) {
        return this.set(new Vector3(this.x() + x, this.y() + y, this.z() + z));
    }

    public Vector3 add(double x, double y, double z) {
        this.x_$eq(this.x() + x);
        this.y_$eq(this.y() + y);
        this.z_$eq(this.z() + z);
        return this;
    }

    public Vector3 addEquals(double x, double y, double z) {
        return this.$plus$eq(x, y, z);
    }

    @Override
    public Vector3 $plus(ForgeDirection amount) {
        return this.$plus(new Vector3(amount));
    }

    @Override
    public Vector3 $plus$eq(ForgeDirection amount) {
        return this.set(this.$plus(new Vector3(amount)));
    }

    @Override
    public Vector3 add(ForgeDirection amount) {
        return this.$plus(amount);
    }

    @Override
    public Vector3 addEquals(ForgeDirection amount) {
        return this.$plus$eq(amount);
    }

    @Override
    public Vector3 $times(double amount) {
        return new Vector3(this.x() * amount, this.y() * amount, this.z() * amount);
    }

    @Override
    public Vector3 $times(Vector3 amount) {
        return new Vector3(this.x() * amount.x(), this.y() * amount.y(), this.z() * amount.z());
    }

    @Override
    public double $(Vector3 other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z();
    }

    public Vector3 cross(Vector3 other) {
        return this.$percent(other);
    }

    public Vector3 $percent(Vector3 other) {
        return new Vector3(this.y() * other.z() - this.z() * other.y(), this.z() * other.x() - this.x() * other.z(), this.x() * other.y() - this.y() * other.x());
    }

    public Vector3 xCross() {
        return new Vector3(0.0, this.z(), -this.y());
    }

    public Vector3 zCross() {
        return new Vector3(-this.y(), this.x(), 0.0);
    }

    public Vector3 midPoint(Vector3 pos) {
        return new Vector3((this.x() + pos.x()) / (double)2, (this.y() + pos.y()) / (double)2, (this.z() + pos.z()) / (double)2);
    }

    public Vector3 perpendicular() {
        if (this.z() == 0.0) {
            return this.zCross();
        }
        return this.xCross();
    }

    public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0 && this.z() == 0.0;
    }

    public Vector3 transform(ITransform transformer) {
        return transformer.transform(this);
    }

    public double angle(Vector3 other) {
        return Math.acos(this.$(other) / (this.magnitude() * other.magnitude()));
    }

    public double anglePreNorm(Vector3 other) {
        return Math.acos(this.$(other));
    }

    public java.util.List<Vector3> getAround(World world, ForgeDirection side, int range) {
        ArrayList<Vector3> list = new ArrayList<Vector3>();
        ForgeDirection forgeDirection = side;
        int n = ForgeDirection.EAST.equals(forgeDirection) ? 0 : (ForgeDirection.WEST.equals(forgeDirection) ? 0 : range);
        int dx = n;
        ForgeDirection forgeDirection2 = side;
        int n2 = ForgeDirection.DOWN.equals(forgeDirection2) ? 0 : (ForgeDirection.UP.equals(forgeDirection2) ? 0 : range);
        int dy = n2;
        ForgeDirection forgeDirection3 = side;
        int n3 = ForgeDirection.NORTH.equals(forgeDirection3) ? 0 : (ForgeDirection.SOUTH.equals(forgeDirection3) ? 0 : range);
        int dz = n3;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.xi() - dx), this.xi() + dx).foreach$mVc$sp((Function1)new Serializable(this, list, dx, dy, dz){
            private final /* synthetic */ Vector3 $outer;
            public final java.util.List list$1;
            private final int dx$1;
            private final int dy$1;
            public final int dz$1;

            public final void apply(int x) {
                this.apply$mcVI$sp(x);
            }

            public void apply$mcVI$sp(int x) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.$outer.yi() - this.dy$1), this.$outer.yi() + this.dx$1).foreach$mVc$sp((Function1)new Serializable(this, x){
                    private final /* synthetic */ $anonfun$getAround$1 $outer;
                    public final int x$2;

                    public final void apply(int y) {
                        this.apply$mcVI$sp(y);
                    }

                    public void apply$mcVI$sp(int y) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.$outer.resonant$lib$transform$vector$Vector3$$anonfun$$$outer().zi() - this.$outer.dz$1), this.$outer.resonant$lib$transform$vector$Vector3$$anonfun$$$outer().zi() + this.$outer.dz$1).foreach((Function1)new Serializable(this, y){
                            private final /* synthetic */ $anonfun$getAround$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final int y$1;

                            public final boolean apply(int z) {
                                return this.apply$mcZI$sp(z);
                            }

                            public boolean apply$mcZI$sp(int z) {
                                return this.$outer.resonant$lib$transform$vector$Vector3$$anonfun$$anonfun$$$outer().list$1.add(new Vector3(this.$outer.x$2, this.y$1, z));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.y$1 = y$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$getAround$1 resonant$lib$transform$vector$Vector3$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                    }
                });
            }

            public /* synthetic */ Vector3 resonant$lib$transform$vector$Vector3$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.list$1 = list$1;
                this.dx$1 = dx$1;
                this.dy$1 = dy$1;
                this.dz$1 = dz$1;
            }
        });
        return list;
    }

    public MovingObjectPosition rayTrace(World world, Vector3 dir, double dist) {
        return this.rayTrace(world, this.$plus(dir.$times(dist)));
    }

    public MovingObjectPosition rayTrace(World world, Vector3 end) {
        MovingObjectPosition block = this.rayTraceBlocks(world, end);
        MovingObjectPosition entity = this.rayTraceEntities(world, end);
        if (block == null) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        Vector3 vector3 = new Vector3(block.field_72307_f);
        Vector3 vector32 = new Vector3(entity.field_72307_f);
        if (this.distance(vector3) < this.distance(vector32)) {
            return block;
        }
        return entity;
    }

    public MovingObjectPosition rayTraceBlocks(World world, Vector3 end) {
        return world.func_72933_a(this.toVec3(), end.toVec3());
    }

    public MovingObjectPosition rayTraceEntities(World world, Vector3 end) {
        ObjectRef closestEntityMOP = ObjectRef.create(null);
        DoubleRef closetDistance = DoubleRef.create((double)0.0);
        double checkDistance = this.distance(end);
        AxisAlignedBB scanRegion = AxisAlignedBB.func_72330_a((double)(-checkDistance), (double)(-checkDistance), (double)(-checkDistance), (double)checkDistance, (double)checkDistance, (double)checkDistance).func_72317_d(this.x(), this.y(), this.z());
        Buffer checkEntities = (Buffer)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(world.func_72872_a(Entity.class, scanRegion)).map((Function1)new Serializable(this){

            public final Entity apply(Object x$1) {
                return (Entity)x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        checkEntities.foreach((Function1)new Serializable(this, end, closestEntityMOP, closetDistance){
            private final /* synthetic */ Vector3 $outer;
            private final Vector3 end$1;
            private final ObjectRef closestEntityMOP$1;
            private final DoubleRef closetDistance$1;

            public final void apply(Entity entity) {
                float border;
                AxisAlignedBB bounds;
                MovingObjectPosition hit;
                if (entity != null && entity.func_70067_L() && entity.field_70121_D != null && (hit = (bounds = entity.field_70121_D.func_72314_b((double)(border = entity.func_70111_Y()), (double)border, (double)border)).func_72327_a(this.$outer.toVec3(), this.end$1.toVec3())) != null) {
                    if (bounds.func_72318_a(this.$outer.toVec3())) {
                        if (0.0 < this.closetDistance$1.elem || this.closetDistance$1.elem == 0.0) {
                            this.closestEntityMOP$1.elem = new MovingObjectPosition(entity);
                            ((MovingObjectPosition)this.closestEntityMOP$1.elem).field_72307_f = hit.field_72307_f;
                            this.closetDistance$1.elem = 0.0;
                        }
                    } else {
                        double dist = this.$outer.distance(new Vector3(hit.field_72307_f));
                        if (dist < this.closetDistance$1.elem || this.closetDistance$1.elem == 0.0) {
                            this.closestEntityMOP$1.elem = new MovingObjectPosition(entity);
                            ((MovingObjectPosition)this.closestEntityMOP$1.elem).field_72307_f = hit.field_72307_f;
                            this.closetDistance$1.elem = dist;
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.end$1 = end$1;
                this.closestEntityMOP$1 = closestEntityMOP$1;
                this.closetDistance$1 = closetDistance$1;
            }
        });
        return (MovingObjectPosition)closestEntityMOP.elem;
    }

    public Block getBlock(IBlockAccess world) {
        return world == null ? null : world.func_147439_a(this.xi(), this.yi(), this.zi());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world == null ? 0 : world.func_72805_g(this.xi(), this.yi(), this.zi());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world == null ? null : world.func_147438_o(this.xi(), this.yi(), this.zi());
    }

    public boolean setBlock(World world, Block block, int metadata, int notify) {
        return world == null || block == null ? false : world.func_147465_d(this.xi(), this.yi(), this.zi(), block, metadata, notify);
    }

    public boolean setBlock(World world, Block block, int metadata) {
        return this.setBlock(world, block, metadata, 3);
    }

    public boolean setBlock(World world, Block block) {
        return this.setBlock(world, block, 0);
    }

    public boolean setBlockToAir(World world) {
        return world.func_147468_f(this.xi(), this.yi(), this.zi());
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.x());
        long y = Double.doubleToLongBits(this.y());
        long z = Double.doubleToLongBits(this.z());
        long hash = x ^ x >>> 32;
        hash = 31L * hash + y ^ y >>> 32;
        hash = 31L * hash + z ^ z >>> 32;
        return (int)hash;
    }

    public boolean equals(Object o) {
        if (o instanceof IVector3) {
            IVector3 other = (IVector3)o;
            return other.x() == this.x() && other.y() == this.y() && other.z() == this.z();
        }
        return false;
    }

    public Vector3 clone() {
        return new Vector3(this.x(), this.y(), this.z());
    }

    public String toString() {
        return new StringBuilder().append((Object)"Vector3[").append((Object)BoxesRunTime.boxToDouble((double)this.x())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.y())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.z())).append((Object)"]").toString();
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double amount) {
        this(amount, amount, amount);
    }

    public Vector3(double yaw, double pitch) {
        this(-Math.sin(Math.toRadians(yaw)), Math.sin(Math.toRadians(pitch)), -Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public Vector3(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public Vector3(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector3(IVector3 vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Vector3(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Vector3(ByteBuf data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Vector3(ForgeDirection dir) {
        this(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vector3(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public Vector3(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public Vector3(Seq<Object> par) {
        this(BoxesRunTime.unboxToDouble((Object)par.apply(0)), BoxesRunTime.unboxToDouble((Object)par.apply(1)), BoxesRunTime.unboxToDouble((Object)par.apply(2)));
    }

    public Vector3(Tuple3<Object, Object, Object> par) {
        this(BoxesRunTime.unboxToDouble((Object)par._1()), BoxesRunTime.unboxToDouble((Object)par._2()), BoxesRunTime.unboxToDouble((Object)par._3()));
    }

    public Vector3(ByteArrayDataInput data) {
        this(data.readInt(), data.readInt(), data.readInt());
    }
}

