/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Group<J> {
    protected final Set<J> members = new LinkedHashSet<J>();
    private String name;

    public Group(String name, J ... js) {
        this.name = name;
        if (js != null) {
            for (J obj : js) {
                this.addMemeber(obj);
            }
        }
    }

    public Set<J> getMembers() {
        return this.members;
    }

    protected boolean isValid(J obj) {
        return obj != null && !this.members.contains(obj);
    }

    public boolean addMemeber(J obj) {
        if (this.isValid(obj)) {
            return this.members.add(obj);
        }
        return false;
    }

    public void addMemebers(Collection<J> members) {
        for (J mem : members) {
            this.addMemeber(mem);
        }
    }

    public boolean removeMemeber(J obj) {
        return this.members.remove(obj);
    }

    public boolean isMemeber(J obj) {
        return this.members.contains(obj);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Group && ((Group)obj).getName().equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "[Group:" + this.getName() + "]";
    }
}

