/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeNode<S extends TreeNode> {
    public S parent;
    public Set<S> children = new HashSet<S>();

    public S addChild(S perm) {
        this.children.add(perm);
        ((TreeNode)perm).parent = this;
        return perm;
    }

    public Set<S> getAllChildren() {
        HashSet<TreeNode<S>> perms = new HashSet<TreeNode<S>>();
        for (TreeNode child : this.children) {
            perms.add(child);
            perms.addAll(child.getAllChildren());
        }
        return perms;
    }

    public boolean exists(S targetPerm) {
        if (this.equals(targetPerm)) {
            return true;
        }
        for (TreeNode perm : this.children) {
            if (!perm.exists(targetPerm)) continue;
            return true;
        }
        return false;
    }

    public List<S> getHierarchy() {
        ArrayList<S> hiearchy = new ArrayList<S>();
        S currentParent = this.parent;
        while (currentParent != null) {
            hiearchy.add(currentParent);
            currentParent = ((TreeNode)currentParent).parent;
        }
        return Lists.reverse(hiearchy);
    }
}

