/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import buildcraft.api.tools.IToolWrench;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import resonant.engine.content.ItemScrewdriver;

public class WrenchUtility {
    public static boolean isHoldingWrench(EntityPlayer player) {
        return WrenchUtility.isWrench(player.func_70694_bm());
    }

    public static boolean isWrench(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IToolWrench) {
                return true;
            }
            if (itemStack.func_77973_b() instanceof ItemScrewdriver) {
                return true;
            }
            try {
                Class<?> wrenchClass = itemStack.func_77973_b().getClass();
                if (wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrench") || wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrenchElectric")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUsableWrench(EntityPlayer player, int x, int y, int z) {
        return WrenchUtility.isUsableWrench(player, player.func_70694_bm(), x, y, z);
    }

    public static boolean isUsableWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
        if (player != null && itemStack != null) {
            if (itemStack.func_77973_b() instanceof IToolWrench) {
                return ((IToolWrench)itemStack.func_77973_b()).canWrench(player, x, y, z);
            }
            if (itemStack.func_77973_b() instanceof ItemScrewdriver) {
                return true;
            }
            try {
                Class<?> wrenchClass = itemStack.func_77973_b().getClass();
                if (wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrench") || wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrenchElectric")) {
                    return itemStack.func_77960_j() < itemStack.func_77958_k();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean damageWrench(EntityPlayer player, int x, int y, int z) {
        return WrenchUtility.damageWrench(player, player.func_70694_bm(), x, y, z);
    }

    public static boolean damageWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
        if (WrenchUtility.isUsableWrench(player, itemStack, x, y, z)) {
            if (itemStack.func_77973_b() instanceof IToolWrench) {
                ((IToolWrench)itemStack.func_77973_b()).wrenchUsed(player, x, y, z);
                return true;
            }
            try {
                Class<?> wrenchClass = itemStack.func_77973_b().getClass();
                if (wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrench") || wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrenchElectric")) {
                    Method methodWrenchDamage = wrenchClass.getMethod("damage", ItemStack.class, Integer.TYPE, EntityPlayer.class);
                    methodWrenchDamage.invoke((Object)itemStack.func_77973_b(), itemStack, 1, player);
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }
}

