/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api;

import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.ICrucibleMold;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.api.book.BookPage;
import flaxbeard.steamcraft.api.book.ICraftingPage;
import flaxbeard.steamcraft.api.enhancement.IEnhancement;
import flaxbeard.steamcraft.api.enhancement.IRocket;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.MutablePair;

public class SteamcraftRegistry {
    public static ArrayList<ICrucibleMold> molds = new ArrayList();
    public static ArrayList<CrucibleLiquid> liquids = new ArrayList();
    public static HashMap<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> smeltThings = new HashMap();
    public static HashMap<Tuple3, MutablePair<Integer, ItemStack>> dunkThings = new HashMap();
    public static HashMap<MutablePair<Item, IEnhancement>, IIcon> enhancementIcons = new HashMap();
    public static HashMap<String, IEnhancement> enhancements = new HashMap();
    public static ArrayList<IRocket> rockets = new ArrayList();
    public static ArrayList<String> categories = new ArrayList();
    public static ArrayList<MutablePair<String, String>> research = new ArrayList();
    public static HashMap<String, BookPage[]> researchPages = new HashMap();
    public static HashMap<ItemStack, MutablePair<String, Integer>> bookRecipes = new HashMap();
    public static HashMap<String, ExosuitPlate> plates = new HashMap();
    public static HashMap<MutablePair<Integer, ExosuitPlate>, IIcon> plateIcons = new HashMap();
    public static HashMap<MutablePair<Item, Integer>, MutablePair<Item, Integer>> steamedFoods = new HashMap();
    private static int nextEnhancementID = 0;

    public static void addSteamFood(Item food1, int i, Item food2, int j) {
        steamedFoods.put((MutablePair<Item, Integer>)MutablePair.of((Object)food1, (Object)i), (MutablePair<Item, Integer>)MutablePair.of((Object)food2, (Object)j));
    }

    public static void addSteamFood(Item food1, Item food2) {
        steamedFoods.put((MutablePair<Item, Integer>)MutablePair.of((Object)food1, (Object)-1), (MutablePair<Item, Integer>)MutablePair.of((Object)food2, (Object)-1));
    }

    public static void addExosuitPlate(ExosuitPlate plate) {
        plates.put(plate.getIdentifier(), plate);
    }

    public static void addCarvableMold(ICrucibleMold mold) {
        molds.add(mold);
    }

    public static void addCategory(String string) {
        categories.add(string);
    }

    public static void addResearch(String string, String category, BookPage ... pages) {
        if (!category.substring(0, 1).equals("!")) {
            research.add((MutablePair<String, String>)MutablePair.of((Object)string, (Object)category));
            researchPages.put(string, pages);
            int pageNum = 0;
            for (BookPage page : pages) {
                if (page instanceof ICraftingPage) {
                    for (ItemStack craftedItem : ((ICraftingPage)((Object)page)).getCraftedItem()) {
                        bookRecipes.put(craftedItem, (MutablePair<String, Integer>)MutablePair.of((Object)string, (Object)pageNum));
                    }
                }
                ++pageNum;
            }
        } else {
            BookPage[] targetPages = researchPages.get(category.substring(1));
            int pageNum = targetPages.length;
            for (BookPage page : pages) {
                if (page instanceof ICraftingPage) {
                    for (ItemStack craftedItem : ((ICraftingPage)((Object)page)).getCraftedItem()) {
                        bookRecipes.put(craftedItem, (MutablePair<String, Integer>)MutablePair.of((Object)category.substring(1), (Object)pageNum));
                    }
                }
                ++pageNum;
            }
            ArrayList<BookPage> pages2 = new ArrayList<BookPage>(Arrays.asList(targetPages));
            for (BookPage page : pages) {
                pages2.add(page);
            }
            researchPages.put(category.substring(1), pages2.toArray(new BookPage[0]));
        }
    }

    public static CrucibleLiquid getLiquidFromName(String name) {
        for (CrucibleLiquid liquid : liquids) {
            if (!liquid.name.equals(name)) continue;
            return liquid;
        }
        return null;
    }

    public static void registerDunkThing(Item item, int meta, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        dunkThings.put(new Tuple3(item, meta, liquid), (MutablePair<Integer, ItemStack>)MutablePair.of((Object)liquidAmount, (Object)result));
    }

    public static void registerDunkThing(Item item, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        dunkThings.put(new Tuple3(item, -1, liquid), (MutablePair<Integer, ItemStack>)MutablePair.of((Object)liquidAmount, (Object)result));
    }

    public static void registerDunkThingOredict(String dict, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.registerDunkThing(ore.func_77973_b(), ore.func_77960_j(), liquid, liquidAmount, result);
        }
    }

    public static void registerSmeltThing(Item item, int i, CrucibleLiquid liquid, int m) {
        smeltThings.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)i), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)m));
    }

    public static void registerSmeltThing(Item item, CrucibleLiquid liquid, int m) {
        smeltThings.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)-1), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)m));
    }

    public static void registerSmeltThingOredict(String dict, CrucibleLiquid liquid, int m) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.registerSmeltThing(ore.func_77973_b(), ore.func_77960_j(), liquid, m);
        }
    }

    public static void registerSmeltTool(Item item, CrucibleLiquid liquid, int m) {
        for (int i = 0; i < item.func_77612_l(); ++i) {
            smeltThings.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)i), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)MathHelper.func_76128_c((double)((float)m * ((float)(item.func_77612_l() - i) / (float)item.func_77612_l())))));
        }
    }

    public static void registerLiquid(CrucibleLiquid liquid) {
        liquids.add(liquid);
    }

    public static void registerEnhancement(IEnhancement enhancement) {
        enhancements.put(enhancement.getID(), enhancement);
    }

    public static void registerRocket(IRocket rocket) {
        rockets.add(rocket);
    }
}

