/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api.enhancement;

import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.enhancement.IEnhancement;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.tuple.MutablePair;

public class UtilEnhancements {
    public static void registerEnhancementsForItem(IIconRegister registry, Item item) {
        for (IEnhancement enhancement : SteamcraftRegistry.enhancements.values()) {
            if (!enhancement.canApplyTo(new ItemStack(item))) continue;
            SteamcraftRegistry.enhancementIcons.put((MutablePair<Item, IEnhancement>)MutablePair.of((Object)item, (Object)enhancement), registry.func_94245_a(enhancement.getIcon(item)));
        }
    }

    public static boolean hasEnhancement(ItemStack item) {
        return UtilEnhancements.getEnhancementFromItem(item) != null;
    }

    public static IEnhancement getEnhancementFromItem(ItemStack item) {
        if (item.func_77942_o() && item.field_77990_d.func_74764_b("enhancements")) {
            return SteamcraftRegistry.enhancements.get(item.field_77990_d.func_74775_l("enhancements").func_74779_i("id"));
        }
        return null;
    }

    public static IIcon getIconFromEnhancement(ItemStack item, IEnhancement enhancement) {
        return SteamcraftRegistry.enhancementIcons.get(MutablePair.of((Object)item.func_77973_b(), (Object)enhancement));
    }

    public static IIcon getIconFromEnhancement(ItemStack item) {
        return UtilEnhancements.getIconFromEnhancement(item, UtilEnhancements.getEnhancementFromItem(item));
    }

    public static String getNameFromEnhancement(ItemStack item, IEnhancement enhancement) {
        return enhancement.getName(item.func_77973_b());
    }

    public static String getNameFromEnhancement(ItemStack item) {
        return UtilEnhancements.getNameFromEnhancement(item, UtilEnhancements.getEnhancementFromItem(item));
    }

    public static String getEnhancementNameFromEnhancement(ItemStack item, IEnhancement enhancement) {
        return enhancement.getEnhancementName(item.func_77973_b());
    }

    public static String getEnhancementNameFromEnhancement(ItemStack item) {
        return UtilEnhancements.getEnhancementNameFromEnhancement(item, UtilEnhancements.getEnhancementFromItem(item));
    }

    public static String getEnhancementDisplayText(ItemStack item) {
        if (UtilEnhancements.hasEnhancement(item)) {
            return EnumChatFormatting.RED + new ItemStack((Item)UtilEnhancements.getEnhancementFromItem(item)).func_82833_r();
        }
        return "";
    }

    public static boolean canEnhance(ItemStack item) {
        if (!item.func_77942_o()) {
            return true;
        }
        return !item.field_77990_d.func_74764_b("enhancements");
    }

    public static ItemStack getEnhancedItem(ItemStack item, ItemStack enhancement) {
        ItemStack output = item.func_77946_l();
        if (!output.func_77942_o()) {
            output.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound enhancements = new NBTTagCompound();
        enhancements.func_74778_a("id", ((IEnhancement)enhancement.func_77973_b()).getID());
        output.field_77990_d.func_74782_a("enhancements", (NBTBase)enhancements);
        return output;
    }

    public static void removeEnhancement(ItemStack item) {
        if (item.func_77942_o() && item.field_77990_d.func_74764_b("enhancements")) {
            item.field_77990_d.func_82580_o("enhancements");
        }
    }
}

