/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api.tile;

import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.steamnet.SteamNetworkRegistry;
import flaxbeard.steamcraft.api.util.Coord4;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.block.BlockRuptureDisc;
import flaxbeard.steamcraft.block.BlockSteamGauge;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SteamTransporterTileEntity
extends TileEntity
implements ISteamTransporter {
    public String name = "SteamTransporterTileEntity";
    public float pressureResistance = 0.8f;
    public float lastPressure = -1.0f;
    public float pressure;
    public int capacity = 10000;
    protected SPLog log = Steamcraft.log;
    protected String networkName;
    protected SteamNetwork network;
    protected ForgeDirection[] distributionDirections;
    protected boolean shouldJoin = false;
    private int steam = 0;
    private ArrayList<ForgeDirection> gaugeSideBlacklist = new ArrayList();
    private boolean isInitialized = false;

    public SteamTransporterTileEntity() {
        this(ForgeDirection.VALID_DIRECTIONS);
    }

    public SteamTransporterTileEntity(ForgeDirection[] distributionDirections) {
        this.distributionDirections = distributionDirections;
    }

    public SteamTransporterTileEntity(int capacity, ForgeDirection[] distributionDirections) {
        this(distributionDirections);
        this.capacity = capacity;
    }

    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound access = new NBTTagCompound();
        if (this.networkName != null) {
            access.func_74778_a("networkName", this.networkName);
            access.func_74776_a("pressure", this.getPressure());
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound access = new NBTTagCompound();
        if (this.networkName != null) {
            access.func_74778_a("networkName", this.networkName);
            access.func_74776_a("pressure", this.getPressure());
        }
        return access;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        if (access.func_74764_b("networkName")) {
            this.networkName = access.func_74779_i("networkName");
            this.pressure = access.func_74760_g("pressure");
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("steam")) {
            this.steam = compound.func_74762_e("steam");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("steam", this.steam);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public float getPressure() {
        return this.network != null ? this.network.getPressure() : this.pressure;
    }

    public void func_145845_h() {
        if (!this.isInitialized || this.shouldJoin) {
            this.refresh();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.steam != this.getSteamShare()) {
                this.steam = this.getSteamShare();
                this.func_70296_d();
            }
            if (this.hasGauge() && this.network != null && Math.abs(this.getPressure() - this.lastPressure) > 0.01f) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastPressure = this.getPressure();
                this.network.markDirty();
            }
        }
    }

    @Override
    public void insertSteam(int amount, ForgeDirection face) {
        if (this.network != null) {
            this.network.addSteam(amount);
        }
    }

    @Override
    public void decrSteam(int i) {
        if (this.network != null) {
            this.network.decrSteam(i);
        }
    }

    @Override
    public void explode() {
        this.network.decrSteam((int)((float)this.network.getSteam() * 0.1f));
        this.network.split(this, true);
        this.field_145850_b.func_72876_a(null, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 4.0f, true);
    }

    private boolean isValidSteamSide(ForgeDirection face) {
        for (ForgeDirection d : this.distributionDirections) {
            if (d != face) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canInsert(ForgeDirection face) {
        return this.isValidSteamSide(face);
    }

    public void addSideToGaugeBlacklist(ForgeDirection face) {
        this.gaugeSideBlacklist.add(face);
    }

    public void addSidesToGaugeBlacklist(ForgeDirection[] faces) {
        for (ForgeDirection face : faces) {
            this.addSideToGaugeBlacklist(face);
        }
    }

    @Override
    public boolean doesConnect(ForgeDirection face) {
        return this.isValidSteamSide(face);
    }

    @Override
    public boolean acceptsGauge(ForgeDirection face) {
        return !this.gaugeSideBlacklist.contains(face);
    }

    @Override
    public float getPressureResistance() {
        return this.pressureResistance;
    }

    protected void setPressureResistance(float resistance) {
        this.pressureResistance = resistance;
    }

    public void setDistributionDirections(ForgeDirection[] faces) {
        this.distributionDirections = faces;
    }

    @Override
    public HashSet<ForgeDirection> getConnectionSides() {
        HashSet<ForgeDirection> out = new HashSet<ForgeDirection>();
        for (ForgeDirection d : this.distributionDirections) {
            out.add(d);
        }
        return out;
    }

    @Override
    public Coord4 getCoords() {
        return new Coord4(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public String getNetworkName() {
        return this.networkName;
    }

    @Override
    public void setNetworkName(String name) {
        this.networkName = name;
    }

    @Override
    public SteamNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SteamNetwork network) {
        this.network = network;
    }

    @Override
    public int getSteamShare() {
        if (this.network != null) {
            int mySteam = (int)Math.floor((double)this.getCapacity() * (double)this.network.getPressure());
            return mySteam;
        }
        return 0;
    }

    @Override
    public int getSteam() {
        return this.steam;
    }

    public boolean hasGauge() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block block;
            if (!this.acceptsGauge(dir) || !((block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof BlockSteamGauge) && !(block instanceof BlockRuptureDisc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
        if (this.network == null && !this.field_145850_b.field_72995_K && SteamNetworkRegistry.getInstance().isInitialized(this.getDimension())) {
            SteamNetwork.newOrJoin(this);
            this.isInitialized = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public void updateSteam(int amount) {
        this.steam = amount;
    }

    protected void shouldJoin() {
        this.shouldJoin = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void wasAdded() {
    }
}

