/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.block.BlockSteamTransporter;
import flaxbeard.steamcraft.client.render.BlockSteamPipeRenderer;
import flaxbeard.steamcraft.tile.TileEntityBoiler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockBoiler
extends BlockSteamTransporter
implements IWrenchable {
    @SideOnly(value=Side.CLIENT)
    public static IIcon steamIcon;
    private static boolean field_149934_M;
    private final Random rand = new Random();
    private final boolean field_149932_b;
    public IIcon camoIcon;
    public IIcon camoOnIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon field_149935_N;
    @SideOnly(value=Side.CLIENT)
    private IIcon field_149936_O;
    private IIcon boilerOnIcon;
    private IIcon boilerOffIcon;

    public BlockBoiler(boolean on) {
        super(Material.field_151573_f);
        this.field_149932_b = on;
    }

    public static void updateFurnaceBlockState(boolean isOn, World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        field_149934_M = true;
        if (isOn) {
            world.func_147449_b(x, y, z, SteamcraftBlocks.boilerOn);
        } else {
            world.func_147449_b(x, y, x, SteamcraftBlocks.boiler);
        }
        field_149934_M = false;
        world.func_72921_c(x, y, x, l, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, x, tileentity);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return Steamcraft.boilerRenderID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        int x2 = x + dir.offsetX;
        int y2 = y + dir.offsetY;
        int z2 = z + dir.offsetZ;
        if (world.func_147438_o(x2, y2, z2) instanceof TileEntityBoiler) {
            TileEntityBoiler boiler = (TileEntityBoiler)world.func_147438_o(x2, y2, z2);
            int l = world.func_72805_g(x2, y2, z2);
            if (boiler != null && boiler.disguiseBlock != null && boiler.disguiseBlock != Blocks.field_150350_a && !BlockSteamPipeRenderer.updateWrenchStatus()) {
                return side == l ? super.func_149646_a(world, x, y, z, side) : false;
            }
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityBoiler boiler = (TileEntityBoiler)world.func_147438_o(x, y, z);
        if (boiler.isBurning()) {
            int l = world.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.func_149930_e(world, x, y, z);
    }

    private void func_149930_e(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z);
        if (meta == 0) {
            meta = 3;
        }
        if (side == meta) {
            TileEntityBoiler boiler = (TileEntityBoiler)block.func_147438_o(x, y, z);
            return boiler.isBurning() ? this.boilerOnIcon : this.boilerOffIcon;
        }
        return side == 1 ? this.field_149935_N : this.field_149761_L;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            meta = 3;
        }
        return side == 1 ? this.field_149935_N : (side == 0 ? this.field_149935_N : (side != meta ? this.field_149761_L : this.boilerOffIcon));
    }

    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("steamcraft:blockBrass");
        steamIcon = ir.func_94245_a("steamcraft:steam");
        this.boilerOnIcon = ir.func_94245_a("steamcraft:boilerOn");
        this.boilerOffIcon = ir.func_94245_a("steamcraft:boiler");
        this.camoOnIcon = ir.func_94245_a("steamcraft:boilerCamoOn");
        this.camoIcon = ir.func_94245_a("steamcraft:boilerCamo");
        this.field_149935_N = ir.func_94245_a("steamcraft:blockBrass");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase elb, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(elb.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (stack.func_82837_s()) {
            // empty if block
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityBoiler();
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityBoiler tileentityboiler = (TileEntityBoiler)par1World.func_147438_o(par2, par3, par4);
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151131_as) {
            if (tileentityboiler != null) {
                int num = tileentityboiler.fill(ForgeDirection.UP, new FluidStack(FluidRegistry.WATER, 1000), true);
                if (!player.field_71075_bZ.field_75098_d && num != 0) {
                    player.field_71071_by.func_146026_a(Items.field_151131_as);
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar));
                    player.field_71069_bz.func_75142_b();
                }
            }
            return true;
        }
        if (par1World.field_72995_K) {
            return true;
        }
        if (tileentityboiler != null) {
            player.openGui((Object)Steamcraft.instance, 0, par1World, par2, par3, par4);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityBoiler tileentityboiler;
        if (!field_149934_M && (tileentityboiler = (TileEntityBoiler)world.func_147438_o(x, y, z)) != null) {
            for (int i1 = 0; i1 < tileentityboiler.func_70302_i_(); ++i1) {
                ItemStack itemstack = tileentityboiler.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.rand.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(SteamcraftBlocks.boiler);
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        int meta = world.func_72805_g(x, y, z);
        if (player.func_70093_af()) {
            return true;
        }
        if (side != 0 && side != 1) {
            world.func_72921_c(x, y, z, side == meta ? ForgeDirection.getOrientation((int)side).getOpposite().ordinal() : side, 2);
            return true;
        }
        return false;
    }
}

