/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.block.BlockSteamTransporter;
import flaxbeard.steamcraft.tile.TileEntityBlockPlacer;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPlacer
extends BlockSteamTransporter
implements IWrenchable {
    IIcon frontIcon;
    private final Random rand = new Random();

    public BlockPlacer() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int someInt) {
        return new TileEntityBlockPlacer();
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == meta ? this.frontIcon : this.field_149761_L;
    }

    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("steamcraft:testSide");
        this.frontIcon = ir.func_94245_a("steamcraft:testFront");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int meta = BlockPlacer.determineOrientation(world, x, y, z, player);
        world.func_72921_c(x, y, z, meta, 2);
    }

    @Override
    public void func_149725_f(World world, int x, int y, int z, int meta) {
        super.func_149725_f(world, x, y, z, meta);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityBlockPlacer) {
            TileEntityBlockPlacer bp = (TileEntityBlockPlacer)te;
            for (int i = 0; i < bp.func_70302_i_(); ++i) {
                ItemStack stack = bp.func_70301_a(i);
                if (stack == null) continue;
                float offsetX = this.rand.nextFloat() * 0.8f + 0.1f;
                float offsetY = this.rand.nextFloat() * 0.8f + 0.1f;
                float offsetZ = this.rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float scale = 0.05f;
                entityitem.field_70159_w = (float)this.rand.nextGaussian() * scale;
                entityitem.field_70181_x = (float)this.rand.nextGaussian() * scale + 0.2f;
                entityitem.field_70179_y = (float)this.rand.nextGaussian() * scale;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static int determineOrientation(World world, int x, int y, int z, EntityLivingBase player) {
        int l;
        if (MathHelper.func_76135_e((float)((float)player.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)player.field_70161_v - (float)z)) < 2.0f) {
            double d0 = player.field_70163_u + 1.82 - (double)player.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return 1;
            }
            if ((double)y - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        int meta = world.func_72805_g(x, y, z);
        world.func_72921_c(x, y, z, side == meta ? ForgeDirection.getOrientation((int)side).getOpposite().ordinal() : side, 2);
        return true;
    }
}

