/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.client.render;

import flaxbeard.steamcraft.item.tool.steam.ItemSteamAxe;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamDrill;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamShovel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemSteamToolRenderer
implements IItemRenderer {
    private static RenderItem renderItem = new RenderItem();
    private final int toolType;

    public ItemSteamToolRenderer(int type) {
        this.toolType = type;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        Entity player;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.field_77990_d.func_74768_a("player", -1);
        }
        IIcon icon = itemStack.func_77954_c();
        int oldPlayer = itemStack.field_77990_d.func_74762_e("player");
        if (oldPlayer != -1 && (player = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(oldPlayer)) != null && player instanceof EntityPlayer) {
            icon = itemStack.func_77973_b().getIcon(itemStack, 0, (EntityPlayer)player, itemStack, 0);
        }
        GL11.glEnable((int)3008);
        renderItem.func_94149_a(0, 0, icon, 16, 16);
        GL11.glDisable((int)3008);
        if (oldPlayer != -1 && (player = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(oldPlayer)) != null && player instanceof EntityPlayer) {
            int use = 0;
            switch (this.toolType) {
                case 0: {
                    use = (Integer)ItemSteamDrill.stuff.get((Object)Integer.valueOf((int)oldPlayer)).right;
                    break;
                }
                case 1: {
                    use = (Integer)ItemSteamAxe.stuff.get((Object)Integer.valueOf((int)oldPlayer)).right;
                    break;
                }
                case 2: {
                    use = (Integer)ItemSteamShovel.stuff.get((Object)Integer.valueOf((int)oldPlayer)).right;
                }
            }
            double health = (1000.0 - (double)use) / 1000.0;
            if (use > 0 && itemStack == Minecraft.func_71410_x().field_71439_g.func_70694_bm()) {
                GL11.glPushMatrix();
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator tessellator = Tessellator.field_78398_a;
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.renderQuad(tessellator, 2, 10, 13, 2, 0);
                this.renderQuad(tessellator, 2, 10, 12, 1, i1);
                this.renderQuad(tessellator, 2, 10, j1, 1, l);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderQuad(Tessellator par1Tessellator, int par2, int par3, int par4, int par5, int par6) {
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78378_d(par6);
        par1Tessellator.func_78377_a((double)(par2 + 0), (double)(par3 + 0), 0.0);
        par1Tessellator.func_78377_a((double)(par2 + 0), (double)(par3 + par5), 0.0);
        par1Tessellator.func_78377_a((double)(par2 + par4), (double)(par3 + par5), 0.0);
        par1Tessellator.func_78377_a((double)(par2 + par4), (double)(par3 + 0), 0.0);
        par1Tessellator.func_78381_a();
    }
}

