/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.block.BlockSteamcraftCrucible;
import flaxbeard.steamcraft.client.render.IInventoryTESR;
import flaxbeard.steamcraft.client.render.model.ModelCrucible;
import flaxbeard.steamcraft.tile.TileEntityCrucible;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityCrucibleRenderer
extends TileEntitySpecialRenderer
implements IInventoryTESR {
    private static final ModelCrucible model = new ModelCrucible();
    private static final ResourceLocation texture = new ResourceLocation("steamcraft:textures/models/crucible.png");
    private static final ResourceLocation textureHell = new ResourceLocation("steamcraft:textures/models/crucible2.png");
    private static final ResourceLocation texture2 = new ResourceLocation("minecraft:textures/blocks/cobblestone.png");
    private static float px = 0.0625f;
    private boolean isNether = false;

    public TileEntityCrucibleRenderer(boolean isHell) {
        this.isNether = isHell;
    }

    public void func_147500_a(TileEntity var1, double x, double y, double z, float var8) {
        TileEntityCrucible crucible = (TileEntityCrucible)var1;
        int meta = crucible.func_145831_w().func_72805_g(var1.field_145851_c, var1.field_145848_d, var1.field_145849_e);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int ticks = crucible.tipTicks;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture2);
        GL11.glRotatef((float)(90.0f * (float)(meta + meta % 2 * 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        model.renderNoRotate();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(crucible.func_145831_w().func_147439_a(crucible.field_145851_c, crucible.field_145848_d, crucible.field_145849_e) == SteamcraftBlocks.hellCrucible ? textureHell : texture);
        if (ticks > 135) {
            ticks = (int)((float)(ticks - 90) / 5.0f * 90.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)ticks / 90.0f)))) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (ticks > 120) {
            ticks = (int)((float)(ticks - 90) / 15.0f * 90.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)ticks / 90.0f)))) * 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (ticks > 90) {
            ticks = (int)((float)(ticks - 90) / 30.0f * 90.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)ticks / 90.0f)))) * 30.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)((float)(Math.PI * (double)((float)ticks / 90.0f)))) * 75.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        model.renderAll();
        float height = (-5.0f + (float)crucible.getFill() / 90.0f * 11.0f) / 16.0f;
        if (crucible.getFill() > 0) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)height);
            this.renderLiquid(crucible);
        }
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glPopMatrix();
    }

    private void renderLiquid(TileEntityCrucible crucible) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IIcon icon = ((BlockSteamcraftCrucible)SteamcraftBlocks.crucible).liquidIcon;
        Tessellator tessellator = Tessellator.field_78398_a;
        float f1 = (float)((double)icon.func_94209_e() + (double)(icon.func_94212_f() - icon.func_94209_e()) * 0.8);
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94209_e();
        float f4 = (float)((double)icon.func_94206_g() + (double)(icon.func_94210_h() - icon.func_94206_g()) * 0.8);
        float pix2 = 0.125f;
        tessellator.func_78382_b();
        CrucibleLiquid liquid = crucible.contents.get(0);
        tessellator.func_78370_a(liquid.cr, liquid.cg, liquid.cb, 256);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(0.125, 0.125, 0.0, (double)f1, (double)f4);
        tessellator.func_78374_a(0.875, 0.125, 0.0, (double)f3, (double)f4);
        tessellator.func_78374_a(0.875, 0.875, 0.0, (double)f3, (double)f2);
        tessellator.func_78374_a(0.125, 0.875, 0.0, (double)f1, (double)f2);
        tessellator.func_78381_a();
    }

    @Override
    public void renderInventoryTileEntityAt(TileEntity var1, double x, double y, double z, float var8) {
        TileEntityCrucible crucible = (TileEntityCrucible)var1;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture2);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        model.renderNoRotate();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.isNether ? textureHell : texture);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        model.renderAll();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glPopMatrix();
    }
}

