/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.client.render.model.exosuit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.exosuit.IExosuitUpgrade;
import flaxbeard.steamcraft.api.exosuit.ModelExosuitUpgrade;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.client.ExosuitTexture;
import flaxbeard.steamcraft.client.Texture;
import flaxbeard.steamcraft.client.render.model.ModelPointer;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.misc.ComparatorUpgrade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ModelExosuit
extends ModelBiped {
    public static final ModelPointer MODEL_POINTER = new ModelPointer();
    public static final ComparatorUpgrade COMPARATOR_UPGRADE = new ComparatorUpgrade();
    public static String[] DYES = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    private final Map<Class<? extends ModelExosuitUpgrade>, ModelExosuitUpgrade> internalModelCache = Maps.newHashMap();
    private ModelRenderer[] horn1;
    private ModelRenderer[] horn2;
    private ModelRenderer[] horn3;
    private ModelRenderer penguinBody;
    private ModelRenderer penguinHead;
    private ModelRenderer penguinArm1;
    private ModelRenderer penguinArm2;
    private ModelRenderer penguinNose;
    private ModelRenderer hornLeftBase;
    private ModelRenderer hornLeftPart1;
    private ModelRenderer hornLeftPart2;
    private ModelRenderer hornLeftPart3;
    private ModelRenderer hornLeftPart4;
    private ModelRenderer hornLeftPart5;
    private ModelRenderer hornRightBase;
    private ModelRenderer hornRightPart1;
    private ModelRenderer hornRightPart2;
    private ModelRenderer hornRightPart3;
    private ModelRenderer hornRightPart4;
    private ModelRenderer hornRightPart5;
    private final List<ResourceLocation> overlayTextures = Lists.newArrayList();
    private final List<Class<? extends ModelExosuitUpgrade>> modelClasses = Lists.newArrayList();
    private ResourceLocation plateOverlayTexture;
    private float shroudModifier = 0.0f;
    private int dye = -1;
    private int armor;
    private boolean shroudEnabled = false;
    private boolean yetiHorns = false;
    private boolean hasPlateOverlay = false;

    private ModelExosuitUpgrade getModel(Class<? extends ModelExosuitUpgrade> clazz) {
        if (!this.internalModelCache.containsKey(clazz)) {
            try {
                this.internalModelCache.put(clazz, clazz.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.internalModelCache.get(clazz);
    }

    public ModelExosuit(int armorType) {
        super(armorType == 3 ? 1.0f : 0.5f, 0.0f, 64, 32);
        this.armor = armorType;
        this.horn1 = this.addPairHorns(-8.0f, 35.0f);
        this.horn2 = this.addPairHorns(-6.0f, 15.0f);
        this.horn3 = this.addPairHorns(-4.0f, -5.0f);
        this.penguinBody = new ModelRenderer((ModelBase)this, 0, 16).func_78787_b(64, 32);
        this.penguinBody.func_78789_a(-1.5f, -14.0f, -1.5f, 3, 5, 3);
        this.field_78116_c.func_78792_a(this.penguinBody);
        this.penguinArm1 = new ModelRenderer((ModelBase)this, 28, 16).func_78787_b(64, 32);
        this.penguinArm1.func_78789_a(-2.5f, -14.0f, -1.0f, 1, 3, 2);
        this.field_78116_c.func_78792_a(this.penguinArm1);
        this.penguinArm2 = new ModelRenderer((ModelBase)this, 28, 16).func_78787_b(64, 32);
        this.penguinArm2.func_78789_a(1.5f, -14.0f, -1.0f, 1, 3, 2);
        this.field_78116_c.func_78792_a(this.penguinArm2);
        this.penguinHead = new ModelRenderer((ModelBase)this, 12, 16).func_78787_b(64, 32);
        this.penguinHead.func_78789_a(-2.0f, -18.0f, -2.0f, 4, 4, 4);
        this.field_78116_c.func_78792_a(this.penguinHead);
        this.penguinNose = new ModelRenderer((ModelBase)this, 34, 16).func_78787_b(64, 32);
        this.penguinNose.func_78789_a(-0.5f, -16.5f, -4.0f, 1, 1, 2);
        this.field_78116_c.func_78792_a(this.penguinNose);
        this.hornLeftBase = new ModelRenderer((ModelBase)this, 0, 0);
        this.hornLeftBase.func_78789_a(3.0f, -9.0f, -2.0f, 2, 2, 2);
        this.hornLeftBase.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hornLeftPart1 = new ModelRenderer((ModelBase)this, 0, 4);
        this.hornLeftPart1.func_78789_a(4.0f, -10.0f, -1.0f, 2, 2, 4);
        this.hornLeftBase.func_78792_a(this.hornLeftPart1);
        this.hornLeftPart2 = new ModelRenderer((ModelBase)this, 0, 10);
        this.hornLeftPart2.func_78789_a(5.0f, -9.0f, 1.0f, 2, 2, 3);
        this.hornLeftBase.func_78792_a(this.hornLeftPart2);
        this.hornLeftPart3 = new ModelRenderer((ModelBase)this, 0, 15);
        this.hornLeftPart3.func_78789_a(6.0f, -8.0f, 2.0f, 2, 3, 2);
        this.hornLeftBase.func_78792_a(this.hornLeftPart3);
        this.hornLeftPart4 = new ModelRenderer((ModelBase)this, 0, 20);
        this.hornLeftPart4.func_78789_a(7.0f, -6.0f, 1.0f, 2, 2, 2);
        this.hornLeftBase.func_78792_a(this.hornLeftPart4);
        this.hornLeftPart5 = new ModelRenderer((ModelBase)this, 0, 24);
        this.hornLeftPart5.func_78789_a(6.0f, -5.0f, -2.0f, 2, 2, 4);
        this.hornLeftBase.func_78792_a(this.hornLeftPart5);
        this.hornRightBase = new ModelRenderer((ModelBase)this, 0, 0);
        this.hornRightBase.func_78789_a(-5.0f, -9.0f, -2.0f, 2, 2, 2);
        this.hornRightBase.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hornRightPart1 = new ModelRenderer((ModelBase)this, 0, 4);
        this.hornRightPart1.func_78789_a(-6.0f, -10.0f, -1.0f, 2, 2, 4);
        this.hornRightBase.func_78792_a(this.hornRightPart1);
        this.hornRightPart2 = new ModelRenderer((ModelBase)this, 0, 10);
        this.hornRightPart2.func_78789_a(-7.0f, -9.0f, 1.0f, 2, 2, 3);
        this.hornRightBase.func_78792_a(this.hornRightPart2);
        this.hornRightPart3 = new ModelRenderer((ModelBase)this, 0, 15);
        this.hornRightPart3.func_78789_a(-8.0f, -8.0f, 2.0f, 2, 3, 2);
        this.hornRightBase.func_78792_a(this.hornRightPart3);
        this.hornRightPart4 = new ModelRenderer((ModelBase)this, 0, 20);
        this.hornRightPart4.func_78789_a(-9.0f, -6.0f, 1.0f, 2, 2, 2);
        this.hornRightBase.func_78792_a(this.hornRightPart4);
        this.hornRightPart5 = new ModelRenderer((ModelBase)this, 0, 24);
        this.hornRightPart5.func_78789_a(-8.0f, -5.0f, -2.0f, 2, 2, 4);
        this.hornRightBase.func_78792_a(this.hornRightPart5);
    }

    public void updateModel(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ItemExosuitArmor exosuitArmor = (ItemExosuitArmor)itemStack.func_77973_b();
        this.yetiHorns = this.armor == 0 ? exosuitArmor.hasPlates(itemStack) && UtilPlates.getPlate(itemStack.field_77990_d.func_74779_i("plate")).getIdentifier().equals("Yeti") : false;
        if (exosuitArmor.hasPlates(itemStack)) {
            this.hasPlateOverlay = true;
            this.plateOverlayTexture = new ResourceLocation(UtilPlates.getPlate(itemStack.func_77978_p().func_74779_i("plate")).getArmorLocation(exosuitArmor, this.armor));
        } else {
            this.hasPlateOverlay = false;
        }
        if (exosuitArmor.hasUpgrade(itemStack, SteamcraftItems.enderShroud)) {
            this.shroudEnabled = true;
            this.shroudModifier = entityLivingBase.field_70737_aN != 0 ? (float)entityLivingBase.field_70737_aN / 9.0f : 0.0f;
        } else {
            this.shroudEnabled = false;
        }
        this.dye = -1;
        if (exosuitArmor.getStackInSlot(itemStack, 2) != null) {
            int[] ids;
            ItemStack vanity = exosuitArmor.getStackInSlot(itemStack, 2);
            block0: for (int id : ids = OreDictionary.getOreIDs((ItemStack)vanity)) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.contains("dye")) continue;
                for (int i = 0; i < DYES.length; ++i) {
                    if (!DYES[i].equals(str.substring(3))) continue;
                    this.dye = 15 - i;
                    break block0;
                }
            }
        }
        this.overlayTextures.clear();
        this.modelClasses.clear();
        ArrayList<IExosuitUpgrade> upgrades = new ArrayList<IExosuitUpgrade>(Arrays.asList(exosuitArmor.getUpgrades(itemStack)));
        Collections.sort(upgrades, COMPARATOR_UPGRADE);
        for (IExosuitUpgrade upgrade : upgrades) {
            ResourceLocation overlay = upgrade.getOverlay();
            Class<? extends ModelExosuitUpgrade> model = upgrade.getModel();
            if (overlay != null) {
                this.overlayTextures.add(overlay);
            }
            if (model == null) continue;
            this.modelClasses.add(model);
            upgrade.updateModel(this, entityLivingBase, itemStack, this.getModel(model));
        }
    }

    public void func_78088_a(Entity entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        GL11.glPushMatrix();
        for (ModelRenderer horn : this.horn1) {
            horn.field_78806_j = this.yetiHorns;
        }
        for (ModelRenderer horn : this.horn2) {
            horn.field_78806_j = this.yetiHorns;
        }
        for (ModelRenderer horn : this.horn3) {
            horn.field_78806_j = this.yetiHorns;
        }
        if (this.shroudEnabled) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.shroudModifier);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
        }
        this.func_78087_a(par2, par3, par4, par5, par6, par7, entity);
        this.field_78116_c.func_78785_a(par7);
        this.field_78115_e.func_78785_a(par7);
        this.field_78112_f.func_78785_a(par7);
        this.field_78113_g.func_78785_a(par7);
        this.field_78123_h.func_78785_a(par7);
        this.field_78124_i.func_78785_a(par7);
        this.field_78114_d.func_78785_a(par7);
        this.penguinBody.field_78806_j = false;
        this.penguinArm1.field_78806_j = false;
        this.penguinArm2.field_78806_j = false;
        this.penguinHead.field_78806_j = false;
        this.penguinNose.field_78806_j = false;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70005_c_().equals("joshiejack")) {
            this.penguinBody.field_78806_j = true;
            this.penguinArm1.field_78806_j = true;
            this.penguinArm2.field_78806_j = true;
            this.penguinHead.field_78806_j = true;
            this.penguinNose.field_78806_j = true;
            this.field_78116_c.func_78785_a(par7);
        }
        if (this.armor == 0 && entity instanceof EntityPlayer && entity.func_70005_c_().equals("Succubism")) {
            this.hornLeftBase.field_78796_g = this.field_78116_c.field_78796_g;
            this.hornLeftBase.field_78795_f = this.field_78116_c.field_78795_f;
            this.hornRightBase.field_78796_g = this.field_78116_c.field_78796_g;
            this.hornRightBase.field_78795_f = this.field_78116_c.field_78795_f;
            Texture.HORNS.bindTexture();
            this.hornLeftBase.func_78785_a(par7);
            this.hornRightBase.func_78785_a(par7);
        }
        if (this.hasPlateOverlay) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.plateOverlayTexture);
            this.field_78116_c.func_78785_a(par7);
            this.field_78115_e.func_78785_a(par7);
            this.field_78112_f.func_78785_a(par7);
            this.field_78113_g.func_78785_a(par7);
            this.field_78123_h.func_78785_a(par7);
            this.field_78124_i.func_78785_a(par7);
            this.field_78114_d.func_78785_a(par7);
        }
        if (this.dye != -1) {
            float[] color = EntitySheep.field_70898_d[this.dye];
            GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
            if (this.armor == 2) {
                ExosuitTexture.EXOSUIT_GREY.bindTexturePart(2);
            } else {
                ExosuitTexture.EXOSUIT_GREY.bindTexturePart(1);
            }
            this.field_78116_c.func_78785_a(par7);
            this.field_78115_e.func_78785_a(par7);
            this.field_78112_f.func_78785_a(par7);
            this.field_78113_g.func_78785_a(par7);
            this.field_78123_h.func_78785_a(par7);
            this.field_78124_i.func_78785_a(par7);
            this.field_78114_d.func_78785_a(par7);
            if (this.armor == 0 && entity instanceof EntityPlayer && entity.func_70005_c_().equals("Succubism")) {
                this.hornLeftBase.field_78796_g = this.field_78116_c.field_78796_g;
                this.hornLeftBase.field_78795_f = this.field_78116_c.field_78795_f;
                this.hornRightBase.field_78796_g = this.field_78116_c.field_78796_g;
                this.hornRightBase.field_78795_f = this.field_78116_c.field_78795_f;
                Texture.HORNS.bindTexture();
                this.hornLeftBase.func_78785_a(par7);
                this.hornRightBase.func_78785_a(par7);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (ResourceLocation resourceLocation : this.overlayTextures) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
            this.field_78116_c.func_78785_a(par7);
            this.field_78115_e.func_78785_a(par7);
            this.field_78112_f.func_78785_a(par7);
            this.field_78113_g.func_78785_a(par7);
            this.field_78123_h.func_78785_a(par7);
            this.field_78124_i.func_78785_a(par7);
            this.field_78114_d.func_78785_a(par7);
        }
        for (Class clazz : this.modelClasses) {
            this.getModel(clazz).renderModel(this, (EntityLivingBase)entity);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    private ModelRenderer[] addPairHorns(float height, float zangle) {
        ModelRenderer[] hornParts = new ModelRenderer[4];
        ModelRenderer horn1a = new ModelRenderer((ModelBase)this, 0, 19);
        horn1a.func_78789_a(-3.0f, -1.5f, -1.5f, 3, 3, 3);
        horn1a.func_78793_a(-4.5f, height, -1.0f);
        horn1a.field_78796_g = -0.5235988f;
        horn1a.field_78808_h = zangle / 57.295776f;
        this.field_78116_c.func_78792_a(horn1a);
        hornParts[0] = horn1a;
        ModelRenderer horn1b = new ModelRenderer((ModelBase)this, 0, 26);
        horn1b.func_78789_a(-4.0f, -1.0f, -1.0f, 5, 2, 2);
        horn1b.func_78793_a(-3.0f, 0.0f, 0.0f);
        horn1b.field_78796_g = -0.3490659f;
        horn1b.field_78808_h = zangle / 57.295776f;
        horn1a.func_78792_a(horn1b);
        hornParts[1] = horn1b;
        ModelRenderer horn2a = new ModelRenderer((ModelBase)this, 0, 19);
        horn2a.func_78789_a(0.0f, -1.5f, -1.5f, 3, 3, 3);
        horn2a.func_78793_a(4.5f, height, -1.0f);
        horn2a.field_78796_g = 0.5235988f;
        horn2a.field_78808_h = -zangle / 57.295776f;
        this.field_78116_c.func_78792_a(horn2a);
        hornParts[2] = horn2a;
        ModelRenderer horn2b = new ModelRenderer((ModelBase)this, 0, 26);
        horn2b.func_78789_a(-1.0f, -1.0f, -1.0f, 5, 2, 2);
        horn2b.func_78793_a(3.0f, 0.0f, 0.0f);
        horn2b.field_78796_g = 0.3490659f;
        horn2b.field_78808_h = -zangle / 57.295776f;
        horn2a.func_78792_a(horn2b);
        hornParts[3] = horn2b;
        return hornParts;
    }

    public void func_78087_a(float par1, float par2, float par3, float par4, float par5, float par6, Entity par7Entity) {
        EntityLivingBase living = (EntityLivingBase)par7Entity;
        boolean bl = this.field_78117_n = living != null ? living.func_70093_af() : false;
        if (living != null && living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            int n = this.field_78120_m = itemstack != null ? 1 : 0;
            if (itemstack != null && player.func_71052_bv() > 0) {
                EnumAction enumaction = itemstack.func_77975_n();
                if (enumaction == EnumAction.block) {
                    this.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    this.field_78118_o = true;
                }
            }
        }
        super.func_78087_a(par1, par2, par3, par4, par5, par6, par7Entity);
    }
}

