/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.SteamcraftRecipes;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.book.BookRecipeRegistry;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.exosuit.ExosuitSlot;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.ItemExosuitUpgrade;
import flaxbeard.steamcraft.misc.SteamcraftPlayerController;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import vazkii.botania.api.item.IExtendedPlayerController;
import vazkii.botania.api.wand.IWandHUD;

public class BotaniaIntegration {
    public static final String[] NET_CLIENT_HANDLER = new String[]{"netClientHandler", "field_78774_b", "b"};
    public static final String[] CURRENT_GAME_TYPE = new String[]{"currentGameType", "field_78779_k", "k"};
    public static Item twigWand;
    public static Item petal;
    public static Item manaResource;
    public static Item floralLaurel;

    @SideOnly(value=Side.CLIENT)
    public static void displayThings(MovingObjectPosition pos, RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        Block block = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (block instanceof IWandHUD) {
            ((IWandHUD)block).renderHUD(mc, event.resolution, (World)mc.field_71441_e, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        }
    }

    public static void grabItems() {
        twigWand = GameRegistry.findItem((String)"Botania", (String)"twigWand");
        petal = GameRegistry.findItem((String)"Botania", (String)"petal");
        manaResource = GameRegistry.findItem((String)"Botania", (String)"manaResource");
    }

    public static Item twigWand() {
        return twigWand;
    }

    public static void addBotaniaLiquid() {
        floralLaurel = new ItemExosuitUpgrade(ExosuitSlot.headHelm, "steamcraft:textures/models/armor/floralLaurel.png", null, 5).func_77637_a(Steamcraft.tab).func_77655_b("steamcraft:floralLaurel").func_111206_d("steamcraft:floralLaurel");
        GameRegistry.registerItem((Item)floralLaurel, (String)"floralLaurel");
        CrucibleLiquid liquidTerrasteel = new CrucibleLiquid("terrasteel", new ItemStack(manaResource, 1, 4), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 6), null, null, 64, 191, 13);
        SteamcraftRegistry.liquids.add(liquidTerrasteel);
        SteamcraftRegistry.registerSmeltThingOredict("ingotTerrasteel", liquidTerrasteel, 9);
        SteamcraftRegistry.registerSmeltThingOredict("nuggetTerrasteel", liquidTerrasteel, 1);
        SteamcraftRegistry.registerSmeltThingOredict("plateSteamcraftTerrasteel", liquidTerrasteel, 6);
        if (Config.enableTerrasteelPlate) {
            SteamcraftRegistry.addExosuitPlate(new ExosuitPlate("Terrasteel", new ItemStack(SteamcraftItems.exosuitPlate, 1, 6), "Terrasteel", "Terrasteel", "steamcraft.plate.terrasteel", new DamageSource[0]));
            SteamcraftRecipes.addExosuitPlateRecipes("exoTerrasteel", "plateSteamcraftTerrasteel", new ItemStack(SteamcraftItems.exosuitPlate, 1, 6), liquidTerrasteel);
        }
        CrucibleLiquid liquidElementium = new CrucibleLiquid("Elementium", new ItemStack(manaResource, 1, 7), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 7), null, null, 230, 66, 247);
        SteamcraftRecipes.addExosuitPlateRecipes("exoElementium", "plateSteamcraftElementium", new ItemStack(SteamcraftItems.exosuitPlate, 1, 7), liquidElementium);
        SteamcraftRegistry.liquids.add(liquidElementium);
        for (int i = 0; i < 16; ++i) {
            BookRecipeRegistry.addRecipe("floralLaurel" + i, (IRecipe)new ShapedOreRecipe(new ItemStack(floralLaurel), new Object[]{"fff", "flf", "fff", Character.valueOf('f'), new ItemStack(petal, 1, i), Character.valueOf('l'), new ItemStack(manaResource, 1, 3)}));
        }
        SteamcraftRegistry.registerSmeltThing(manaResource, 7, liquidElementium, 9);
        SteamcraftRegistry.registerSmeltThingOredict("ingotElementium", liquidElementium, 9);
        SteamcraftRegistry.registerSmeltThingOredict("nuggetElementium", liquidElementium, 1);
        SteamcraftRegistry.registerSmeltThingOredict("plateSteamcraftElementium", liquidElementium, 6);
        if (Config.enableElementiumPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoElementium", "plateSteamcraftElementium", new ItemStack(SteamcraftItems.exosuitPlate, 1, 7), liquidElementium);
            SteamcraftRegistry.addExosuitPlate(new ExosuitPlate("Elementium", new ItemStack(SteamcraftItems.exosuitPlate, 1, 7), "Elementum", "Elementum", "steamcraft.plate.elementum", new DamageSource[0]));
        }
    }

    public static Multimap addModifiers(Multimap map, ItemStack stack, int armorType) {
        if (((ItemExosuitArmor)stack.func_77973_b()).hasPlates(stack) && UtilPlates.getPlate(stack.field_77990_d.func_74779_i("plate")).getIdentifier() == "Terrasteel") {
            int hp = 1;
            switch (armorType) {
                case 0: {
                    hp = 2;
                    break;
                }
                case 1: {
                    hp = 4;
                    break;
                }
                case 2: {
                    hp = 2;
                    break;
                }
                case 4: {
                    hp = 2;
                }
            }
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(new UUID(171328L, armorType), "Armor modifier" + armorType, (double)hp, 0));
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public static void extendRange(Entity entity, float amount) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71442_b instanceof IExtendedPlayerController)) {
            WorldSettings.GameType type = (WorldSettings.GameType)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])CURRENT_GAME_TYPE);
            NetHandlerPlayClient net = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])NET_CLIENT_HANDLER);
            SteamcraftPlayerController controller = new SteamcraftPlayerController(mc, net);
            controller.func_78746_a(type);
            mc.field_71442_b = controller;
        }
        ((IExtendedPlayerController)mc.field_71442_b).setReachDistanceExtension(((IExtendedPlayerController)mc.field_71442_b).getReachDistanceExtension() + amount);
    }

    @SideOnly(value=Side.CLIENT)
    public static void checkRange(EntityLivingBase entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71442_b instanceof IExtendedPlayerController)) {
            WorldSettings.GameType type = (WorldSettings.GameType)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])CURRENT_GAME_TYPE);
            NetHandlerPlayClient net = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])NET_CLIENT_HANDLER);
            SteamcraftPlayerController controller = new SteamcraftPlayerController(mc, net);
            controller.func_78746_a(type);
            mc.field_71442_b = controller;
        }
        if (((IExtendedPlayerController)mc.field_71442_b).getReachDistanceExtension() <= 2.0f) {
            BotaniaIntegration.extendRange((Entity)entity, 2.0f - ((IExtendedPlayerController)mc.field_71442_b).getReachDistanceExtension());
        }
    }
}

