/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.firearm;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.api.IEngineerable;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.UtilMisc;
import flaxbeard.steamcraft.api.enhancement.IEnhancement;
import flaxbeard.steamcraft.api.enhancement.IEnhancementRocketLauncher;
import flaxbeard.steamcraft.api.enhancement.UtilEnhancements;
import flaxbeard.steamcraft.entity.EntityRocket;
import flaxbeard.steamcraft.gui.GuiEngineeringTable;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.firearm.ItemEnhancementAirStrike;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;

public class ItemRocketLauncher
extends Item
implements IEngineerable {
    public float explosionSize;
    public int reloadTime;
    public int shellCount;
    public float accuracy;
    public Object repairMaterial = null;
    private int timeBetweenFire;
    private boolean wasSprinting = false;

    public ItemRocketLauncher(float sizeExplosion, int timeReload, int fireTime, float rocketAccuracy, int rocketCount) {
        this.field_77777_bU = 1;
        this.func_77656_e(384);
        this.explosionSize = sizeExplosion;
        this.reloadTime = timeReload;
        this.timeBetweenFire = fireTime;
        this.accuracy = rocketAccuracy;
        this.shellCount = rocketCount;
    }

    public ItemRocketLauncher(float sizeExplosion, int timeReload, int fireTime, float rocketAccuracy, int rocketCount, Object repair) {
        this.field_77777_bU = 1;
        this.func_77656_e(384);
        this.explosionSize = sizeExplosion;
        this.reloadTime = timeReload;
        this.timeBetweenFire = fireTime;
        this.accuracy = rocketAccuracy;
        this.shellCount = rocketCount;
        this.repairMaterial = repair;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            list.add(UtilEnhancements.getEnhancementDisplayText(stack));
        }
        super.func_77624_a(stack, player, list, par4);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(stack, world, entity, par4, par5);
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("fireDelay")) {
            int delay = stack.field_77990_d.func_74762_e("fireDelay");
            if (delay > 0) {
                --delay;
            }
            stack.field_77990_d.func_74768_a("fireDelay", delay);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getNameFromEnhancement(stack);
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        UtilEnhancements.registerEnhancementsForItem(ir, this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getIconFromEnhancement(stack);
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getIconFromEnhancement(stack);
        }
        return super.func_77650_f(stack);
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        boolean crouched = par3EntityPlayer.func_70093_af();
        if (nbt.func_74767_n("done")) {
            nbt.func_74768_a("loaded", nbt.func_74762_e("numloaded"));
            nbt.func_74757_a("done", false);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        boolean var5 = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
        int enhancementShells = 0;
        if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementRocketLauncher) {
            enhancementShells = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getClipSizeChange(this);
        }
        int selectedRocketType = 0;
        if (nbt.func_74764_b("rocketType")) {
            selectedRocketType = nbt.func_74762_e("rocketType");
        }
        if ((var5 || par3EntityPlayer.field_71071_by.func_146028_b((Item)SteamcraftRegistry.rockets.get(selectedRocketType))) && !nbt.func_74767_n("done")) {
            nbt.func_74768_a("numloaded", 1);
            if (var5) {
                nbt.func_74768_a("numloaded", this.shellCount + enhancementShells);
            } else {
                par3EntityPlayer.field_71071_by.func_146026_a((Item)SteamcraftRegistry.rockets.get(selectedRocketType));
                if (this.shellCount + enhancementShells > 1) {
                    for (int i = 1; i < this.shellCount + enhancementShells; ++i) {
                        if (!par3EntityPlayer.field_71071_by.func_146028_b((Item)SteamcraftRegistry.rockets.get(selectedRocketType))) continue;
                        par3EntityPlayer.field_71071_by.func_146026_a((Item)SteamcraftRegistry.rockets.get(selectedRocketType));
                        nbt.func_74768_a("numloaded", nbt.func_74762_e("numloaded") + 1);
                    }
                }
            }
            nbt.func_74757_a("done", true);
            par2World.func_72956_a((Entity)par3EntityPlayer, "random.click", UtilEnhancements.getEnhancementFromItem(par1ItemStack) != null && UtilEnhancements.getEnhancementFromItem(par1ItemStack).getID() == "Silencer" ? 0.4f : 1.0f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return par1ItemStack;
    }

    public boolean func_77662_d() {
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        NBTTagCompound nbt;
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            nbt = par1ItemStack.func_77978_p();
            nbt.func_74768_a("loaded", 0);
            nbt.func_74768_a("numloaded", 0);
        }
        nbt = par1ItemStack.func_77978_p();
        int enhancementReload = 0;
        if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementRocketLauncher) {
            enhancementReload = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getReloadChange(this);
        }
        if (nbt.func_74762_e("loaded") > 0 || nbt.func_74767_n("done")) {
            return 72000;
        }
        return this.reloadTime + enhancementReload;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        NBTTagCompound nbt;
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            nbt = par1ItemStack.func_77978_p();
            nbt.func_74768_a("loaded", 0);
            nbt.func_74768_a("numloaded", 0);
        }
        if ((nbt = par1ItemStack.func_77978_p()).func_74762_e("loaded") > 0) {
            return EnumAction.bow;
        }
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        System.out.println("1 - " + par3EntityPlayer.field_70170_p.field_72995_K);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        boolean crouched = par3EntityPlayer.func_70093_af();
        if (!crouched) {
            if (!par1ItemStack.func_77942_o()) {
                par1ItemStack.func_77982_d(new NBTTagCompound());
                nbt = par1ItemStack.func_77978_p();
                nbt.func_74768_a("loaded", 0);
                nbt.func_74757_a("done", false);
                nbt.func_74768_a("numloaded", 0);
            }
            System.out.println("2 - " + par3EntityPlayer.field_70170_p.field_72995_K);
            if (nbt.func_74762_e("loaded") > 0 || par3EntityPlayer.field_71075_bZ.field_75098_d) {
                System.out.println("3 - " + par3EntityPlayer.field_70170_p.field_72995_K);
                if (!par1ItemStack.field_77990_d.func_74764_b("fireDelay") || par1ItemStack.field_77990_d.func_74762_e("fireDelay") == 0) {
                    float var7;
                    System.out.println("4 - " + par3EntityPlayer.field_70170_p.field_72995_K);
                    float enhancementAccuracy = 0.0f;
                    float enhancementExplosionSize = 0.0f;
                    int enhancementDelay = 0;
                    if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementRocketLauncher) {
                        enhancementAccuracy = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getAccuracyChange(this);
                        enhancementExplosionSize = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getExplosionChange(this);
                        enhancementDelay = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getFireDelayChange(par1ItemStack);
                    }
                    if ((double)(var7 = 1.0f) < 0.1) {
                        return par1ItemStack;
                    }
                    if (var7 > 1.0f) {
                        var7 = 1.0f;
                    }
                    EntityRocket var8 = new EntityRocket(par2World, par3EntityPlayer, 1.0f + this.accuracy + enhancementAccuracy - var7, this.explosionSize + enhancementExplosionSize);
                    int selectedRocketType = 0;
                    if (par1ItemStack.func_77942_o() && par1ItemStack.field_77990_d.func_74764_b("rocketType")) {
                        selectedRocketType = par1ItemStack.field_77990_d.func_74762_e("rocketType");
                    }
                    var8 = SteamcraftRegistry.rockets.get(selectedRocketType).changeBullet(var8);
                    if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementRocketLauncher) {
                        var8 = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).changeBullet(var8);
                    }
                    par1ItemStack.func_77972_a(1, (EntityLivingBase)par3EntityPlayer);
                    par2World.func_72956_a((Entity)par3EntityPlayer, "steamcraft:rocket", 0.4f * (UtilEnhancements.getEnhancementFromItem(par1ItemStack) != null && UtilEnhancements.getEnhancementFromItem(par1ItemStack).getID() == "Silencer" ? 0.4f : 1.0f), 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
                    if (!par2World.field_72995_K) {
                        par2World.func_72838_d((Entity)var8);
                    }
                    nbt.func_74768_a("loaded", nbt.func_74762_e("loaded") - 1);
                    if (par2World.field_72995_K && !par3EntityPlayer.field_71075_bZ.field_75098_d) {
                        boolean crouching = par3EntityPlayer.func_70093_af();
                    }
                    if (!SteamcraftEventHandler.isJumping(par3EntityPlayer) || par3EntityPlayer.field_71075_bZ.field_75100_b || !UtilEnhancements.hasEnhancement(par1ItemStack) || !(UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof ItemEnhancementAirStrike)) {
                        par1ItemStack.field_77990_d.func_74768_a("fireDelay", this.timeBetweenFire + enhancementDelay);
                    }
                }
            } else {
                NBTTagCompound nbtt = par1ItemStack.func_77978_p();
                if (par3EntityPlayer.field_71075_bZ.field_75098_d) {
                    int enhancementShells = 0;
                    if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementRocketLauncher) {
                        enhancementShells = ((IEnhancementRocketLauncher)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getClipSizeChange(this);
                    }
                    nbtt.func_74768_a("loaded", 1);
                    nbtt.func_74768_a("numloaded", this.shellCount + enhancementShells);
                }
                par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
            }
        } else {
            if (!par1ItemStack.func_77942_o()) {
                par1ItemStack.func_77982_d(new NBTTagCompound());
                nbt = par1ItemStack.func_77978_p();
                nbt.func_74768_a("loaded", 0);
                nbt.func_74757_a("done", false);
                nbt.func_74768_a("numloaded", 0);
            }
            int selectedRocketType = 0;
            if (par1ItemStack.func_77942_o() && par1ItemStack.field_77990_d.func_74764_b("rocketType")) {
                selectedRocketType = par1ItemStack.field_77990_d.func_74762_e("rocketType");
            }
            int prevRocketType = selectedRocketType;
            selectedRocketType = (selectedRocketType + 1) % SteamcraftRegistry.rockets.size();
            nbt.func_74768_a("rocketType", selectedRocketType);
            if (selectedRocketType != prevRocketType && par1ItemStack.field_77990_d.func_74762_e("loaded") > 0) {
                ItemStack stack = new ItemStack((Item)SteamcraftRegistry.rockets.get(prevRocketType), nbt.func_74762_e("loaded"), 0);
                if (!par3EntityPlayer.field_70170_p.field_72995_K) {
                    EntityItem entityItem = new EntityItem(par3EntityPlayer.field_70170_p, par3EntityPlayer.field_70165_t, par3EntityPlayer.field_70163_u, par3EntityPlayer.field_70161_v, stack);
                    par3EntityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                }
                nbt.func_74768_a("loaded", 0);
            }
        }
        return par1ItemStack;
    }

    @Override
    public MutablePair<Integer, Integer>[] engineerCoordinates() {
        return new MutablePair[]{MutablePair.of((Object)53, (Object)29)};
    }

    @Override
    public ItemStack getStackInSlot(ItemStack me, int var1) {
        if (UtilEnhancements.hasEnhancement(me)) {
            Item item = (Item)UtilEnhancements.getEnhancementFromItem(me);
            return new ItemStack(item);
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(ItemStack me, int var1, ItemStack stack) {
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (stack != null) {
            IEnhancement enhancement = (IEnhancement)stack.func_77973_b();
            NBTTagCompound enhancements = new NBTTagCompound();
            enhancements.func_74778_a("id", enhancement.getID());
            me.field_77990_d.func_74782_a("enhancements", (NBTBase)enhancements);
        }
    }

    @Override
    public boolean isItemValidForSlot(ItemStack me, int var1, ItemStack var2) {
        return true;
    }

    @Override
    public ItemStack decrStackSize(ItemStack me, int var1, int var2) {
        if (UtilEnhancements.hasEnhancement(me)) {
            Item item = (Item)UtilEnhancements.getEnhancementFromItem(me);
            UtilEnhancements.removeEnhancement(me);
            return new ItemStack(item);
        }
        return null;
    }

    @Override
    public void drawSlot(GuiContainer guiEngineeringTable, int slotnum, int i, int j) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(GuiEngineeringTable.furnaceGuiTextures);
        guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
    }

    @Override
    public boolean canPutInSlot(ItemStack me, int slotNum, ItemStack upgrade) {
        return upgrade.func_77973_b() instanceof IEnhancement && ((IEnhancement)upgrade.func_77973_b()).canApplyTo(me);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        if (this.repairMaterial != null) {
            if (this.repairMaterial instanceof ItemStack) {
                return par2ItemStack.func_77969_a((ItemStack)this.repairMaterial) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
            }
            if (this.repairMaterial instanceof String) {
                return UtilMisc.doesMatch(par2ItemStack, (String)this.repairMaterial) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
            }
        }
        return super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public void drawBackground(GuiEngineeringTable guiEngineeringTable, int i, int j, int k) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(ItemExosuitArmor.largeIcons);
        guiEngineeringTable.func_73729_b(j + 26, k + 3, 192, 64, 64, 64);
    }
}

