/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.tool.steam;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.api.ISteamChargable;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.commons.lang3.tuple.MutablePair;

public class ItemSteamDrill
extends ItemPickaxe
implements ISteamChargable {
    public static HashMap<Integer, MutablePair<Integer, Integer>> stuff = new HashMap();
    public IIcon[] icon = new IIcon[2];
    private boolean hasBrokenBlock = false;

    public ItemSteamDrill() {
        super(EnumHelper.addToolMaterial((String)"DRILL", (int)2, (int)320, (float)1.0f, (float)-1.0f, (int)0));
    }

    public static void checkNBT(EntityPlayer player) {
        if (!stuff.containsKey(player.func_145782_y())) {
            stuff.put(player.func_145782_y(), (MutablePair<Integer, Integer>)MutablePair.of((Object)0, (Object)0));
        }
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack me, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(me, player, list, par4);
        list.add(EnumChatFormatting.WHITE + "" + (me.func_77958_k() - me.func_77960_j()) * this.steamPerDurability() + "/" + me.func_77958_k() * this.steamPerDurability() + " SU");
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        this.hasBrokenBlock = true;
        return true;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        ItemSteamDrill.checkNBT(player);
        MutablePair<Integer, Integer> info = stuff.get(player.func_145782_y());
        int ticks = (Integer)info.left;
        return this.icon[ticks > 50 ? 0 : 1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon[0] = this.field_77791_bV = ir.func_94245_a("steamcraft:drill0");
        this.icon[1] = ir.func_94245_a("steamcraft:drill1");
    }

    public void func_77663_a(ItemStack stack, World par2World, Entity player, int par4, boolean par5) {
        int oldPlayer;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("player")) {
            stack.field_77990_d.func_74768_a("player", -1);
        }
        if ((oldPlayer = stack.field_77990_d.func_74762_e("player")) != player.func_145782_y()) {
            stack.field_77990_d.func_74768_a("player", player.func_145782_y());
        }
        if (player instanceof EntityPlayer) {
            ItemSteamDrill.checkNBT((EntityPlayer)player);
            MutablePair<Integer, Integer> info = stuff.get(player.func_145782_y());
            int ticks = (Integer)info.left;
            int speed = (Integer)info.right;
            if (this.hasBrokenBlock) {
                speed -= 10;
                this.hasBrokenBlock = false;
            }
            int addedTicks = Math.min(Double.valueOf(Math.floor((double)speed / 1000.0 * 25.0)).intValue(), 50);
            ticks += addedTicks;
            if (speed > 0) {
                --speed;
            } else {
                ticks = ticks <= 0 ? 0 : --ticks;
            }
            stuff.put(player.func_145782_y(), (MutablePair<Integer, Integer>)MutablePair.of((Object)(ticks %= 100), (Object)speed));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World par2World, EntityPlayer player) {
        ItemSteamDrill.checkNBT(player);
        if (stack.func_77960_j() < stack.func_77958_k() - 1) {
            MutablePair<Integer, Integer> info = stuff.get(player.func_145782_y());
            int ticks = (Integer)info.left;
            int speed = (Integer)info.right;
            if (speed <= 1000) {
                speed += Math.min(90, 1000 - speed);
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            stuff.put(player.func_145782_y(), (MutablePair<Integer, Integer>)MutablePair.of((Object)ticks, (Object)speed));
        }
        return stack;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return 1.0f;
    }

    @Override
    public int steamPerDurability() {
        return 800;
    }

    @Override
    public boolean canCharge(ItemStack me) {
        return true;
    }
}

