/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.packet;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.misc.ExplosionRocket;
import flaxbeard.steamcraft.packet.SteamcraftServerPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SteamcraftClientPacketHandler
extends SteamcraftServerPacketHandler {
    private static SPLog log = Steamcraft.log;

    public static void sendSpacePacket(Entity player) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(0);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendCamoPacket(Entity player, MovingObjectPosition pos) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(3);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
            out.writeInt(pos.field_72311_b);
            out.writeInt(pos.field_72312_c);
            out.writeInt(pos.field_72309_d);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendConnectPacket(Entity player, int x, int y, int z, MovingObjectPosition pos) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(4);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
            out.writeInt(x);
            out.writeInt(y);
            out.writeInt(z);
            out.writeInt(pos.subHit);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendNoSpacePacket(Entity player) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(2);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendItemNamePacket(World worldObj, int x, int y, int z, String s, EntityPlayer player) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(1);
            out.writeInt(worldObj.field_73011_w.field_76574_g);
            out.writeInt(x);
            out.writeInt(y);
            out.writeInt(z);
            out.writeUTF(s);
            out.writeInt(player.func_145782_y());
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendGrapplePacket(EntityPlayer player, int x, int y, int z) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(5);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
            out.writeInt(x);
            out.writeInt(y);
            out.writeInt(z);
            out.writeDouble(player.field_70165_t);
            out.writeDouble(player.field_70163_u);
            out.writeDouble(player.field_70161_v);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToServer(packet);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBufInputStream bbis = new ByteBufInputStream(event.packet.payload());
        try {
            byte packetType = bbis.readByte();
            int dimension = bbis.readInt();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (packetType == 2) {
                this.handleRocketJumpHackyPacket(bbis, (World)world);
            }
            if (packetType == 3) {
                this.handleExplodePacket(bbis, (World)world);
            }
            bbis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void handleRocketJumpHackyPacket(ByteBufInputStream dat, World world) {
        try {
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null) {
                double motionX = dat.readDouble();
                double motionY = dat.readDouble();
                double motionZ = dat.readDouble();
                Minecraft.func_71410_x().field_71439_g.field_70159_w += motionX;
                Minecraft.func_71410_x().field_71439_g.field_70181_x += motionY;
                Minecraft.func_71410_x().field_71439_g.field_70179_y += motionZ;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void handleExplodePacket(ByteBufInputStream dat, World world) {
        try {
            this.newExplosion(world, null, dat.readDouble(), dat.readDouble(), dat.readDouble(), dat.readFloat(), true, world.func_82736_K().func_82766_b("mobGriefing"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public Explosion newExplosion(World world, Entity entity, double p_72885_2_, double p_72885_4_, double p_72885_6_, float p_72885_8_, boolean p_72885_9_, boolean p_72885_10_) {
        ExplosionRocket explosion = new ExplosionRocket(world, entity, p_72885_2_, p_72885_4_, p_72885_6_, p_72885_8_);
        ((Explosion)explosion).field_77286_a = p_72885_9_;
        ((Explosion)explosion).field_82755_b = p_72885_10_;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }
}

