/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.packet;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.block.IDisguisableBlock;
import flaxbeard.steamcraft.entity.EntityRocket;
import flaxbeard.steamcraft.gui.ContainerSteamAnvil;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.tile.TileEntitySteamHammer;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SteamcraftServerPacketHandler {
    public static void sendRocketJumpHackyPacket(EntityPlayerMP player, double xChange, double yChange, double zChange) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(2);
            out.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            out.writeInt(player.func_145782_y());
            out.writeDouble(xChange);
            out.writeDouble(yChange);
            out.writeDouble(zChange);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendTo(packet, player);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendPipeConnectDisconnectPacket(int dimension, double x, double y, double z) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(1);
            out.writeInt(dimension);
            out.writeByte(0);
            out.writeDouble(x);
            out.writeDouble(y);
            out.writeDouble(z);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, z));
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendExplodePacket(EntityRocket entityRocket) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        try {
            out.writeByte(3);
            out.writeInt(entityRocket.field_70170_p.field_73011_w.field_76574_g);
            out.writeDouble(entityRocket.field_70165_t);
            out.writeDouble(entityRocket.field_70163_u);
            out.writeDouble(entityRocket.field_70161_v);
            out.writeFloat(entityRocket.explosionSize);
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket packet = new FMLProxyPacket(buf, "steamcraft");
        Steamcraft.channel.sendToDimension(packet, entityRocket.field_70170_p.field_73011_w.field_76574_g);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleSpacePacket(ByteBufInputStream dat, World world) {
        try {
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null) {
                ItemExosuitArmor item;
                ItemStack armor2;
                ItemExosuitArmor item2;
                ItemStack armor;
                ItemExosuitArmor chest;
                if (player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)player.func_71124_b(3).func_77973_b()).hasUpgrade(player.func_71124_b(3), SteamcraftItems.pitonDeployer) && player.func_71124_b((int)3).field_77990_d.func_74764_b("grappled") && player.func_71124_b((int)3).field_77990_d.func_74767_n("grappled")) {
                    player.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", false);
                }
                if ((armor = player.func_82169_q(2)) != null && armor.func_77973_b() == SteamcraftItems.exoArmorBody && (item2 = (ItemExosuitArmor)armor.func_77973_b()).hasUpgrade(armor, SteamcraftItems.jetpack) && SteamcraftEventHandler.hasPower((EntityLivingBase)player, 5) && !player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                    player.field_70181_x += 0.06;
                    player.field_70143_R = 0.0f;
                    SteamcraftEventHandler.drainSteam(player.func_82169_q(2), Config.jetpackConsumption);
                }
                if ((armor2 = player.func_82169_q(0)) != null && armor2.func_77973_b() == SteamcraftItems.exoArmorFeet && (item = (ItemExosuitArmor)armor2.func_77973_b()).hasUpgrade(armor2, SteamcraftItems.doubleJump) && SteamcraftEventHandler.hasPower((EntityLivingBase)player, 15)) {
                    if (!armor2.field_77990_d.func_74764_b("usedJump")) {
                        armor2.field_77990_d.func_74757_a("usedJump", false);
                    }
                    if (!armor2.field_77990_d.func_74764_b("releasedSpace")) {
                        armor2.field_77990_d.func_74757_a("releasedSpace", false);
                    }
                    if (!player.field_70122_E && armor2.field_77990_d.func_74767_n("releasedSpace") && !armor2.field_77990_d.func_74767_n("usedJump") && !player.field_71075_bZ.field_75100_b) {
                        armor2.field_77990_d.func_74757_a("usedJump", true);
                        player.field_70181_x += 0.3;
                        double rotation = Math.toRadians(player.field_70761_aq);
                        player.field_70143_R = 0.0f;
                        SteamcraftEventHandler.drainSteam(player.func_82169_q(2), 10);
                    }
                    armor2.field_77990_d.func_74757_a("releasedSpace", false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void handleCamoPacket(ByteBufInputStream dat, World world) {
        try {
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null) {
                int x = dat.readInt();
                int y = dat.readInt();
                int z = dat.readInt();
                Block block = Block.func_149634_a((Item)player.func_70694_bm().func_77973_b());
                TileEntity tile = world.func_147438_o(x, y, z);
                if (!(block instanceof BlockContainer) && !(block instanceof ITileEntityProvider) && (block.func_149645_b() == 0 || block.func_149645_b() == 39 || block.func_149645_b() == 31) && block.func_149662_c() && (block.func_149686_d() || block == Blocks.field_150359_w && tile instanceof TileEntitySteamPipe)) {
                    EntityItem entityItem;
                    Object pipe;
                    if (!world.field_72995_K && tile instanceof TileEntitySteamPipe) {
                        pipe = (TileEntitySteamPipe)tile;
                        if (((TileEntitySteamPipe)pipe).disguiseBlock != block || ((TileEntitySteamPipe)pipe).disguiseMeta != ((ItemBlock)player.func_70694_bm().func_77973_b()).func_77647_b(player.func_70694_bm().func_77960_j())) {
                            if (((TileEntitySteamPipe)pipe).disguiseBlock != Blocks.field_150350_a && !player.field_71075_bZ.field_75098_d) {
                                entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(((TileEntitySteamPipe)pipe).disguiseBlock, 1, ((TileEntitySteamPipe)pipe).disguiseMeta));
                                world.func_72838_d((Entity)entityItem);
                                ((TileEntitySteamPipe)pipe).disguiseBlock = null;
                            }
                            ((TileEntitySteamPipe)pipe).disguiseBlock = block;
                            if (!player.field_71075_bZ.field_75098_d) {
                                --player.field_71071_by.func_70448_g().field_77994_a;
                                player.field_71069_bz.func_75142_b();
                            }
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                            ((TileEntitySteamPipe)pipe).disguiseMeta = ((ItemBlock)player.func_70694_bm().func_77973_b()).func_77647_b(player.func_70694_bm().func_77960_j());
                            world.func_147471_g(x, y, z);
                        }
                    }
                    if (!world.field_72995_K && tile instanceof IDisguisableBlock && ((pipe = (IDisguisableBlock)tile).getDisguiseBlock() != block || pipe.getDisguiseMeta() != ((ItemBlock)player.func_70694_bm().func_77973_b()).func_77647_b(player.func_70694_bm().func_77960_j()))) {
                        if (pipe.getDisguiseBlock() != Blocks.field_150350_a && !player.field_71075_bZ.field_75098_d) {
                            entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(pipe.getDisguiseBlock(), 1, pipe.getDisguiseMeta()));
                            world.func_72838_d((Entity)entityItem);
                            pipe.setDisguiseBlock(null);
                        }
                        pipe.setDisguiseBlock(block);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.field_71071_by.func_70448_g().field_77994_a;
                            player.field_71069_bz.func_75142_b();
                        }
                        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                        pipe.setDisguiseMeta(((ItemBlock)player.func_70694_bm().func_77973_b()).func_77647_b(player.func_70694_bm().func_77960_j()));
                        world.func_147471_g(x, y, z);
                    }
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void handleDRPacket(ByteBufInputStream dat, World world) {
        try {
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null) {
                int x = dat.readInt();
                int y = dat.readInt();
                int z = dat.readInt();
                int subHit = dat.readInt();
                if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntitySteamPipe) {
                    ((TileEntitySteamPipe)world.func_147438_o(x, y, z)).connectDisconnect(world, x, y, z, subHit);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void handleNoSpacePacket(ByteBufInputStream dat, World world) {
        try {
            ItemExosuitArmor item;
            ItemStack armor2;
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null && (armor2 = player.func_82169_q(0)) != null && armor2.func_77973_b() == SteamcraftItems.exoArmorFeet && (item = (ItemExosuitArmor)armor2.func_77973_b()).hasUpgrade(armor2, SteamcraftItems.doubleJump) && !player.field_70122_E) {
                armor2.field_77990_d.func_74757_a("releasedSpace", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void handleItemNamePacket(ByteBufInputStream dat, World world) {
        try {
            TileEntitySteamHammer hammer;
            int x = dat.readInt();
            int y = dat.readInt();
            int z = dat.readInt();
            String s = dat.readUTF();
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            if (player != null && (hammer = (TileEntitySteamHammer)world.func_147438_o(x, y, z)) != null) {
                hammer.itemName = s;
                ContainerSteamAnvil anvil = (ContainerSteamAnvil)player.field_71070_bA;
                anvil.updateItemName(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void handleGrapplePacket(ByteBufInputStream dat, World world) {
        try {
            int id = dat.readInt();
            EntityPlayer player = (EntityPlayer)world.func_73045_a(id);
            int x = dat.readInt();
            int y = dat.readInt();
            int z = dat.readInt();
            double playerX = dat.readDouble();
            double playerY = dat.readDouble();
            double playerZ = dat.readDouble();
            if (player != null) {
                player.func_71124_b((int)3).field_77990_d.func_74776_a("x", (float)playerX);
                player.func_71124_b((int)3).field_77990_d.func_74776_a("z", (float)playerZ);
                player.func_71124_b((int)3).field_77990_d.func_74776_a("y", (float)playerY);
                player.func_71124_b((int)3).field_77990_d.func_74768_a("blockX", x);
                player.func_71124_b((int)3).field_77990_d.func_74768_a("blockY", y);
                player.func_71124_b((int)3).field_77990_d.func_74768_a("blockZ", z);
                player.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", true);
                player.field_70159_w = 0.0;
                player.field_70181_x = 0.0;
                player.field_70179_y = 0.0;
                player.field_70143_R = 0.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream bbis = new ByteBufInputStream(event.packet.payload());
        try {
            byte packetID = bbis.readByte();
            int dimension = bbis.readInt();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (packetID == 0) {
                this.handleSpacePacket(bbis, (World)world);
            }
            if (packetID == 2) {
                this.handleNoSpacePacket(bbis, (World)world);
            }
            if (packetID == 1) {
                this.handleItemNamePacket(bbis, (World)world);
            }
            if (packetID == 3) {
                this.handleCamoPacket(bbis, (World)world);
            }
            if (packetID == 4) {
                this.handleDRPacket(bbis, (World)world);
            }
            if (packetID == 5) {
                this.handleGrapplePacket(bbis, (World)world);
            }
            bbis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

