/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityFan
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable,
IWrenchDisplay {
    public boolean active;
    public boolean powered = false;
    public boolean lastSteam = false;
    public int rotateTicks = 0;
    public int range = 9;
    private boolean isInitialized = false;

    public TileEntityFan() {
        this.addSidesToGaugeBlacklist(ForgeDirection.VALID_DIRECTIONS);
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        access.func_74757_a("powered", this.powered);
        access.func_74777_a("range", (short)this.range);
    }

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        this.powered = access.func_74767_n("powered");
        this.range = access.func_74765_d("range");
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74757_a("active", this.getSteamShare() > 0 && !this.powered);
        access.func_74777_a("range", (short)this.range);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.active = access.func_74767_n("active");
        this.range = access.func_74765_d("range");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        if (this.lastSteam != this.getSteamShare() > 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        boolean bl = this.lastSteam = this.getSteamShare() > 0;
        if (!this.isInitialized) {
            this.powered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.setDistributionDirections(new ForgeDirection[]{ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getOpposite()});
            this.isInitialized = true;
        }
        super.func_145845_h();
        if (this.active && this.field_145850_b.field_72995_K) {
            ++this.rotateTicks;
        }
        if (this.active && this.field_145850_b.field_72995_K || this.getSteamShare() > 0 && !this.powered) {
            if (!this.field_145850_b.field_72995_K) {
                this.decrSteam(1);
            }
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + (dir.offsetX == 0 ? Math.random() : 0.5), (double)this.field_145848_d + (dir.offsetY == 0 ? Math.random() : 0.5), (double)this.field_145849_e + (dir.offsetZ == 0 ? Math.random() : 0.5), (double)((float)dir.offsetX * 0.2f), (double)((float)dir.offsetY * 0.2f), (double)((float)dir.offsetZ * 0.2f));
            int blocksInFront = 0;
            boolean blocked = false;
            for (int i = 1; i < this.range; ++i) {
                int x = this.field_145851_c + dir.offsetX * i;
                int y = this.field_145848_d + dir.offsetY * i;
                int z = this.field_145849_e + dir.offsetZ * i;
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(20) == 0 && !blocked && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150350_a && this.field_145850_b.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || this.field_145850_b.func_147439_a(x, y, z) instanceof BlockCrops) {
                    int tMeta = this.field_145850_b.func_72805_g(x, y, z);
                    this.field_145850_b.func_147439_a(x, y, z).func_149697_b(this.field_145850_b, x, y, z, tMeta, 0);
                    for (int v = 0; v < 5; ++v) {
                        Steamcraft.proxy.spawnBreakParticles(this.field_145850_b, (float)(this.field_145851_c + dir.offsetX * i) + 0.5f, (float)(this.field_145848_d + dir.offsetY * i) + 0.5f, (float)(this.field_145849_e + dir.offsetZ * i) + 0.5f, this.field_145850_b.func_147439_a(x, y, z), 0.0f, 0.0f, 0.0f);
                    }
                    this.field_145850_b.func_147468_f(x, y, z);
                }
                if (!blocked && (this.field_145850_b.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || this.field_145850_b.func_147437_c(x, y, z) || this.field_145850_b.func_147439_a(x, y, z) instanceof BlockTrapDoor || this.field_145850_b.func_147439_a(x, y, z).func_149668_a(this.field_145850_b, x, y, z) == null)) {
                    blocksInFront = i;
                    if (i == this.range - 1) continue;
                    this.field_145850_b.func_72869_a("smoke", (double)(this.field_145851_c + dir.offsetX * i) + (dir.offsetX == 0 ? Math.random() : 0.5), (double)(this.field_145848_d + dir.offsetY * i) + (dir.offsetY == 0 ? Math.random() : 0.5), (double)(this.field_145849_e + dir.offsetZ * i) + (dir.offsetZ == 0 ? Math.random() : 0.5), (double)((float)dir.offsetX * 0.2f), (double)((float)dir.offsetY * 0.2f), (double)((float)dir.offsetZ * 0.2f));
                    continue;
                }
                blocked = true;
            }
            List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c + (dir.offsetX < 0 ? dir.offsetX * blocksInFront : 0)), (double)(this.field_145848_d + (dir.offsetY < 0 ? dir.offsetY * blocksInFront : 0)), (double)(this.field_145849_e + (dir.offsetZ < 0 ? dir.offsetZ * blocksInFront : 0)), (double)(this.field_145851_c + 1 + (dir.offsetX > 0 ? dir.offsetX * blocksInFront : 0)), (double)(this.field_145848_d + 1 + (dir.offsetY > 0 ? dir.offsetY * blocksInFront : 0)), (double)(this.field_145849_e + 1 + (dir.offsetZ > 0 ? dir.offsetZ * blocksInFront : 0))));
            for (Object obj : entities) {
                Entity entity = (Entity)obj;
                if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
                if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) {
                    entity.field_70159_w += (double)((float)dir.offsetX * 0.025f);
                    entity.field_70181_x += (double)((float)dir.offsetY * 0.05f);
                    entity.field_70179_y += (double)((float)dir.offsetZ * 0.025f);
                } else {
                    entity.field_70159_w += (double)((float)dir.offsetX * 0.075f);
                    entity.field_70181_x += (double)((float)dir.offsetY * 0.1f);
                    entity.field_70179_y += (double)((float)dir.offsetZ * 0.075f);
                }
                entity.field_70143_R = 0.0f;
            }
        }
    }

    public void updateRedstoneState(boolean flag) {
        if (flag != this.powered) {
            this.powered = flag;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            switch (this.range) {
                case 9: {
                    this.range = 11;
                    break;
                }
                case 11: {
                    this.range = 13;
                    break;
                }
                case 13: {
                    this.range = 15;
                    break;
                }
                case 15: {
                    this.range = 17;
                    break;
                }
                case 17: {
                    this.range = 19;
                    break;
                }
                case 19: {
                    this.range = 5;
                    break;
                }
                case 5: {
                    this.range = 7;
                    break;
                }
                case 7: {
                    this.range = 9;
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        int steam = this.getSteamShare();
        this.getNetwork().split(this, true);
        this.setDistributionDirections(new ForgeDirection[]{ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getOpposite()});
        SteamNetwork.newOrJoin(this);
        this.getNetwork().addSteam(steam);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayWrench(RenderGameOverlayEvent.Post event) {
        GL11.glPushMatrix();
        int color = Minecraft.func_71410_x().field_71439_g.func_70093_af() ? 0xC6C6C6 : 0x777777;
        int x = event.resolution.func_78326_a() / 2 - 8;
        int y = event.resolution.func_78328_b() / 2 - 8;
        Minecraft.func_71410_x().field_71466_p.func_78261_a(StatCollector.func_74838_a((String)"steamcraft.fan.range") + " " + this.range + " " + StatCollector.func_74838_a((String)"steamcraft.fan.blocks"), x + 15, y + 13, color);
        GL11.glPopMatrix();
    }
}

