/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import flaxbeard.steamcraft.entity.EntityFloatingItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFishGenocideMachine
extends SteamTransporterTileEntity
implements ISteamTransporter {
    private static final List field_146036_f = Arrays.asList(new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));

    public TileEntityFishGenocideMachine() {
        super(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN});
        this.addSidesToGaugeBlacklist(ForgeDirection.VALID_DIRECTIONS);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
    }

    @Override
    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound access = new NBTTagCompound();
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int calcSourceBlocks() {
        int water = 0;
        for (int x = -3; x < 4; ++x) {
            for (int z = -3; z < 4; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) != Blocks.field_150355_j) continue;
                ++water;
            }
        }
        return water;
    }

    public ChunkCoordinates randSourceBlock() {
        ArrayList<ChunkCoordinates> cc = new ArrayList<ChunkCoordinates>();
        for (int x = -3; x < 4; ++x) {
            for (int z = -3; z < 4; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) != Blocks.field_150355_j) continue;
                cc.add(new ChunkCoordinates(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z));
            }
        }
        return (ChunkCoordinates)cc.get(this.field_145850_b.field_73012_v.nextInt(cc.size()));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int src = this.calcSourceBlocks();
        if (this.getSteamShare() > src) {
            this.decrSteam(src);
            if (this.field_145850_b.field_73012_v.nextInt((int)(300.0f / (float)src)) == 0 && !this.field_145850_b.field_72995_K) {
                ItemStack fish;
                ChunkCoordinates loc = this.randSourceBlock();
                ItemStack output = fish = ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, (Collection)field_146036_f)).func_150708_a(this.field_145850_b.field_73012_v);
                if (FurnaceRecipes.func_77602_a().func_151395_a(fish) != null) {
                    output = FurnaceRecipes.func_77602_a().func_151395_a(fish);
                }
                this.dropItem(output, (float)loc.field_71574_a + 0.5f, (float)this.field_145848_d + 1.0f, (float)loc.field_71573_c + 0.5f);
            }
        }
    }

    public void dropItem(ItemStack item) {
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.25f), (double)((float)this.field_145849_e + 0.5f), item);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public void dropItem(ItemStack item, float x, float y, float z) {
        EntityFloatingItem entityItem = new EntityFloatingItem(this.field_145850_b, x, y, z, item);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }
}

