/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.tile.TileEntityBoiler;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFlashBoiler
extends TileEntityBoiler
implements IFluidHandler,
ISidedInventory,
ISteamTransporter {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{0, 1};
    private static final int[] slotsSides = new int[]{0, 1};
    private static final int CAPACITY = 12500;
    private static int[][] bbl = new int[][]{{0, 0, 0}, {1, 0, 0}, {0, 0, 1}, {1, 0, 1}, {0, 1, 0}, {1, 1, 0}, {0, 1, 1}, {1, 1, 1}};
    private static int[][] tbl = new int[][]{{0, -1, 0}, {1, -1, 0}, {0, -1, 1}, {1, -1, 1}, {0, 0, 0}, {1, 0, 0}, {0, 0, 1}, {1, 0, 1}};
    private static int[][] bbr = new int[][]{{-1, 0, 0}, {0, 0, 0}, {-1, 0, 1}, {0, 0, 1}, {-1, 1, 0}, {0, 1, 0}, {-1, 1, 1}, {0, 1, 1}};
    private static int[][] tbr = new int[][]{{-1, -1, 0}, {0, -1, 0}, {-1, -1, 1}, {0, -1, 1}, {-1, 0, 0}, {0, 0, 0}, {-1, 0, 1}, {0, 0, 1}};
    private static int[][] btl = new int[][]{{0, 0, -1}, {1, 0, -1}, {0, 0, 0}, {1, 0, 0}, {0, 1, -1}, {1, 1, -1}, {0, 1, 0}, {1, 1, 0}};
    private static int[][] ttl = new int[][]{{0, -1, -1}, {1, -1, -1}, {0, -1, 0}, {1, -1, 0}, {0, 0, -1}, {1, 0, -1}, {0, 0, 0}, {1, 0, 0}};
    private static int[][] btr = new int[][]{{-1, 0, -1}, {0, 0, -1}, {-1, 0, 0}, {0, 0, 0}, {-1, 1, -1}, {0, 1, -1}, {-1, 1, 0}, {0, 1, 0}};
    private static int[][] ttr = new int[][]{{-1, -1, -1}, {0, -1, -1}, {-1, -1, 0}, {0, -1, 0}, {-1, 0, -1}, {0, 0, -1}, {-1, 0, 0}, {0, 0, 0}};
    private static int[][][] validConfigs = new int[][][]{bbl, tbl, bbr, tbr, btl, ttl, btr, ttr};
    public int furnaceCookTime;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int heat;
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    private String field_145958_o;
    private boolean wasBurning = false;
    private boolean shouldExplode = false;
    private boolean waitOneTick = true;
    private int frontSide = -1;
    private boolean loaded = false;
    private boolean burning;

    public TileEntityFlashBoiler() {
        super(12500);
        this.myTank = new FluidTank(new FluidStack(FluidRegistry.WATER, 1), 80000);
        this.setPressureResistance(0.5f);
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        this.frontSide = access.func_74762_e("frontSide");
        NBTTagList nbttaglist = (NBTTagList)access.func_74781_a("Items");
        this.furnaceItemStacks = new ItemStack[2];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound compound = nbttaglist.func_150305_b(i);
            byte b0 = compound.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.furnaceBurnTime = access.func_74765_d("BurnTime");
        this.furnaceCookTime = access.func_74765_d("CookTime");
        this.currentItemBurnTime = access.func_74765_d("cIBT");
        if (access.func_74764_b("CustomName")) {
            this.field_145958_o = access.func_74779_i("CustomName");
        }
        if (access.func_74764_b("water")) {
            this.myTank.setFluid(new FluidStack(FluidRegistry.WATER, (int)access.func_74765_d("water")));
        }
        if (access.func_74764_b("heat")) {
            this.heat = access.func_74765_d("heat");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        access.func_74768_a("frontSide", this.frontSide);
        access.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        access.func_74777_a("water", (short)this.myTank.getFluidAmount());
        access.func_74777_a("heat", (short)this.heat);
        access.func_74777_a("CookTime", (short)this.furnaceCookTime);
        access.func_74777_a("cIBT", (short)this.currentItemBurnTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        access.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            access.func_74778_a("CustomName", this.field_145958_o);
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74768_a("frontSide", this.frontSide);
        access.func_74768_a("water", this.myTank.getFluidAmount());
        access.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        access.func_74777_a("CookTime", (short)this.furnaceCookTime);
        access.func_74777_a("cIBT", (short)this.currentItemBurnTime);
        access.func_74757_a("burning", this.burning);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.frontSide = access.func_74762_e("frontSide");
        this.myTank.setFluid(new FluidStack(FluidRegistry.WATER, access.func_74762_e("water")));
        this.furnaceBurnTime = access.func_74765_d("BurnTime");
        this.currentItemBurnTime = access.func_74765_d("cIBT");
        this.furnaceCookTime = access.func_74765_d("CookTime");
        this.burning = access.func_74767_n("burning");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void checkMultiblock(boolean isBreaking, int frontSide) {
        int[] validClusters;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        boolean isMultiblock = false;
        boolean isTooManyBlocks = false;
        if (!this.field_145850_b.field_72995_K && !isBreaking && (validClusters = this.getValidClusters()).length == 1) {
            this.updateMultiblock(validClusters[0], true, frontSide);
        }
    }

    public void destroyMultiblock() {
        this.updateMultiblock(this.getValidClusterFromMetadata(), false, -1);
    }

    private int getValidClusterFromMetadata() {
        int validCluster = -1;
        switch (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            case 1: {
                validCluster = 0;
                break;
            }
            case 2: {
                validCluster = 2;
                break;
            }
            case 3: {
                validCluster = 4;
                break;
            }
            case 4: {
                validCluster = 6;
                break;
            }
            case 5: {
                validCluster = 1;
                break;
            }
            case 6: {
                validCluster = 3;
                break;
            }
            case 7: {
                validCluster = 5;
                break;
            }
            case 8: {
                validCluster = 7;
            }
        }
        return validCluster;
    }

    private int checkCluster(int[][] cluster) {
        int count = 0;
        for (int pos = 0; pos < 8; ++pos) {
            int x = cluster[pos][0] + this.field_145851_c;
            int y = cluster[pos][1] + this.field_145848_d;
            int z = cluster[pos][2] + this.field_145849_e;
            Block b = this.field_145850_b.func_147439_a(x, y, z);
            if (b != SteamcraftBlocks.flashBoiler) continue;
            TileEntityFlashBoiler fb = (TileEntityFlashBoiler)this.field_145850_b.func_147438_o(x, y, z);
            if (this.field_145850_b.func_72805_g(x, y, z) > 0) continue;
            ++count;
        }
        return count;
    }

    private int[] getValidClusters() {
        int[] valid = new int[8];
        int count = 0;
        for (int clusterIndex = 0; clusterIndex < 8; ++clusterIndex) {
            boolean isValid = false;
            if (this.checkCluster(validConfigs[clusterIndex]) != 8) continue;
            valid[count] = clusterIndex;
            ++count;
            isValid = true;
        }
        int[] out = new int[count];
        for (int i = 0; i < count; ++i) {
            out[i] = valid[i];
        }
        return out;
    }

    private int[][] getClusterCoords(int clusterIndex) {
        int[][] cluster = validConfigs[clusterIndex];
        int[][] out = new int[8][3];
        for (int pos = 0; pos < 8; ++pos) {
            out[pos] = new int[]{cluster[pos][0] + this.field_145851_c, cluster[pos][1] + this.field_145848_d, cluster[pos][2] + this.field_145849_e};
        }
        return out;
    }

    private void updateMultiblock(int clusterIndex, boolean isMultiblock, int frontSide) {
        int[][] cluster = this.getClusterCoords(clusterIndex);
        HashSet<TileEntityFlashBoiler> boilers = new HashSet<TileEntityFlashBoiler>();
        for (int pos = 7; pos >= 0; --pos) {
            int x = cluster[pos][0];
            int y = cluster[pos][1];
            int z = cluster[pos][2];
            if (this.field_145850_b.func_147439_a(x, y, z) != SteamcraftBlocks.flashBoiler) continue;
            this.field_145850_b.func_72921_c(cluster[pos][0], cluster[pos][1], cluster[pos][2], isMultiblock ? pos + 1 : 0, 2);
            TileEntityFlashBoiler boiler = (TileEntityFlashBoiler)this.field_145850_b.func_147438_o(cluster[pos][0], cluster[pos][1], cluster[pos][2]);
            boiler.setFront(frontSide, false);
            boilers.add(boiler);
        }
        for (TileEntityFlashBoiler boiler : boilers) {
            if (isMultiblock) {
                SteamNetwork.newOrJoin(boiler);
                continue;
            }
            if (this.getNetwork() == null) continue;
            this.getNetwork().split(boiler, true);
        }
    }

    public TileEntityFlashBoiler getMasterTileEntity() {
        int[][] cluster = this.getClusterCoords(this.getValidClusterFromMetadata());
        int x = cluster[0][0];
        int y = cluster[0][1];
        int z = cluster[0][2];
        TileEntityFlashBoiler boiler = null;
        if (this.field_145850_b.func_147439_a(x, y, z) == SteamcraftBlocks.flashBoiler && this.field_145850_b.func_72805_g(x, y, z) > 0) {
            boiler = (TileEntityFlashBoiler)this.field_145850_b.func_147438_o(x, y, z);
        }
        return boiler;
    }

    public void setFront(int frontSide, boolean print) {
        if (!this.field_145850_b.field_72995_K) {
            this.frontSide = frontSide;
        }
    }

    public int getFront() {
        return this.frontSide;
    }

    @Override
    public void func_145845_h() {
        super.superUpdateOnly();
        if (this.capacity != 12500) {
            int steamToLose = Math.abs(this.capacity - 12500);
            this.decrSteam(steamToLose);
            this.capacity = 12500;
        }
        if (this.shouldExplode) {
            this.getNetwork().split(this, true);
            this.field_145850_b.func_72876_a(null, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 4.0f, true);
            return;
        }
        if (this.waitOneTick) {
            this.waitOneTick = false;
        } else if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            if (this.func_70301_a(1) != null && (this.func_70301_a(1).func_77973_b() == Items.field_151131_as || this.func_70301_a(1).func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)this.func_70301_a(1).func_77973_b()).getFluid(this.func_70301_a(1)) != null && ((IFluidContainerItem)this.func_70301_a(1).func_77973_b()).getFluid(this.func_70301_a(1)).getFluid() == FluidRegistry.WATER) && this.canDrainItem(this.func_70301_a(1))) {
                if (this.func_70301_a(1).func_77973_b() == Items.field_151131_as) {
                    this.func_70299_a(1, new ItemStack(Items.field_151133_ar));
                    this.myTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                }
                if (this.func_70301_a(1).func_77973_b() instanceof IFluidContainerItem) {
                    int maxDrain = this.getTankInfo((ForgeDirection)ForgeDirection.UP)[0].capacity - this.getTankInfo((ForgeDirection)ForgeDirection.UP)[0].fluid.amount;
                    this.myTank.fill(new FluidStack(FluidRegistry.WATER, ((IFluidContainerItem)this.func_70301_a((int)1).func_77973_b()).drain((ItemStack)this.func_70301_a((int)1), (int)maxDrain, (boolean)true).amount), true);
                }
            }
            boolean flag = this.furnaceBurnTime > 0;
            boolean flag1 = false;
            int maxThisTick = 10;
            if (this.furnaceBurnTime > 0) {
                maxThisTick = Math.min(this.furnaceBurnTime, 10);
                this.furnaceBurnTime -= maxThisTick;
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFlashBoiler.getItemBurnTime(this.furnaceItemStacks[0]);
                    if (this.furnaceBurnTime > 0) {
                        flag1 = true;
                        if (this.furnaceItemStacks[0] != null) {
                            --this.furnaceItemStacks[0].field_77994_a;
                            if (this.furnaceItemStacks[0].field_77994_a == 0) {
                                this.furnaceItemStacks[0] = this.furnaceItemStacks[0].func_77973_b().getContainerItem(this.furnaceItemStacks[0]);
                            }
                        }
                    }
                }
                if (!this.isBurning() && this.heat > 0) {
                    this.heat -= Math.min(this.heat, 10);
                }
                if (this.isBurning() && this.heat < 1600) {
                    ++this.heat;
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime > 0) {
                        int maxSteamThisTick = (int)((float)maxThisTick * 0.7f + (float)maxThisTick * 0.3f * 1.0f);
                        for (int i = 0; i < maxSteamThisTick && this.isBurning() && this.canSmelt(); ++i) {
                            this.insertSteam(10);
                            this.myTank.drain(2, true);
                        }
                        this.furnaceCookTime = 0;
                        flag1 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
                if (flag != this.furnaceBurnTime > 0) {
                    flag1 = true;
                }
            }
            if (this.isBurning() != this.wasBurning) {
                this.wasBurning = this.isBurning();
                this.burning = this.isBurning();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    private void insertSteam(int i) {
        if (this.getNetwork() != null) {
            this.getNetwork().addSteam(i);
        }
    }

    private boolean canSmelt() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.myTank.getFluidAmount() > 9 : (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().canSmelt() : false);
    }

    private boolean canDrainItem(ItemStack stack) {
        return stack.field_77994_a == 1;
    }

    @Override
    public boolean isBurning() {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            return this.furnaceBurnTime > 0;
        }
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            if (this.getMasterTileEntity() != null) {
                return this.getMasterTileEntity().isBurning();
            }
            return false;
        }
        return false;
    }

    public boolean hasMaster() {
        return this.getMasterTileEntity() != null;
    }

    @Override
    public int func_70302_i_() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.furnaceItemStacks.length : (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().func_70302_i_() : 0);
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.furnaceItemStacks[slot] : (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().func_70301_a(slot) : null);
    }

    @Override
    public ItemStack func_70298_a(int par1, int par2) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            if (this.furnaceItemStacks[par1] != null) {
                if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                    ItemStack itemstack = this.furnaceItemStacks[par1];
                    this.furnaceItemStacks[par1] = null;
                    return itemstack;
                }
                ItemStack itemstack = this.furnaceItemStacks[par1].func_77979_a(par2);
                if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                    this.furnaceItemStacks[par1] = null;
                }
                return itemstack;
            }
            return null;
        }
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().func_70298_a(par1, par2) : null;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            if (this.furnaceItemStacks[par1] != null) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return itemstack;
            }
            return null;
        }
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().func_70304_b(par1) : null;
    }

    public boolean isInCluster(int x, int y, int z) {
        int[][] cluster = this.getClusterCoords(this.getValidClusterFromMetadata());
        for (int pos = 0; pos < cluster.length; ++pos) {
            if (x != cluster[pos][0] || y != cluster[pos][1] || z != cluster[pos][1]) continue;
            return this.field_145850_b.func_147439_a(x, y, z) == SteamcraftBlocks.flashBoiler && this.field_145850_b.func_72805_g(x, y, z) > 0;
        }
        return false;
    }

    @Override
    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            this.furnaceItemStacks[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
                par2ItemStack.field_77994_a = this.func_70297_j_();
            }
        } else if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            this.getMasterTileEntity().func_70299_a(par1, par2ItemStack);
        }
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.field_145958_o : "container.furnace";
    }

    @Override
    public boolean func_145818_k_() {
        return this.field_145958_o != null && this.field_145958_o.length() > 0;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 ? TileEntityFlashBoiler.getItemBurnTime(stack) > 0 : stack.func_77973_b() == Items.field_151131_as || FluidContainerRegistry.isEmptyContainer((ItemStack)stack) || stack.func_77973_b() instanceof IFluidContainerItem;
    }

    @Override
    public float getPressure() {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            if (this.field_145850_b.field_72995_K) {
                return this.pressure;
            }
            if (this.getNetwork() != null) {
                return super.getPressure();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean canInsert(ForgeDirection face) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 4 && face != this.myDir();
    }

    @Override
    public int getCapacity() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.capacity : 0;
    }

    @Override
    public int getSteamShare() {
        if (this.func_145832_p() > 0) {
            return super.getSteamShare();
        }
        return 0;
    }

    @Override
    public int getSteam() {
        int steamOut = super.getSteam();
        this.log.debug("Getting FB steam: " + steamOut);
        return steamOut;
    }

    @Override
    public void insertSteam(int amount, ForgeDirection face) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 && this.getNetwork() != null) {
            this.getNetwork().addSteam(amount);
        } else if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            this.getMasterTileEntity().insertSteam(amount, face);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            if (this.currentItemBurnTime == 0) {
                this.currentItemBurnTime = 200;
            }
            return this.furnaceBurnTime * scale / this.currentItemBurnTime;
        }
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().getBurnTimeRemainingScaled(scale) : 0;
    }

    @Override
    public void decrSteam(int i) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 && this.getNetwork() != null) {
            this.getNetwork().decrSteam(i);
        } else if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            this.getMasterTileEntity().decrSteam(i);
        }
    }

    @Override
    public boolean doesConnect(ForgeDirection face) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 4;
    }

    @Override
    public boolean acceptsGauge(ForgeDirection face) {
        if (face != ForgeDirection.UP && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 4 && face != ForgeDirection.UP) {
                return true;
            }
            if (face != this.myDir()) {
                return true;
            }
        }
        return false;
    }

    public ForgeDirection myDir() {
        int meta = this.frontSide;
        switch (meta) {
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.NORTH;
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        int[] accessibleSlots = this.func_94128_d(side);
        boolean isAccessibleSlot = false;
        for (int i = 0; i < accessibleSlots.length; ++i) {
            if (accessibleSlots[i] != slot) continue;
            isAccessibleSlot = true;
        }
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.func_94041_b(slot, stack) && isAccessibleSlot : false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            return stack.func_77973_b() == Items.field_151133_ar;
        }
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().func_102008_b(slot, stack, side) : false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.furnaceCookTime * scale / 200 : (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster() ? this.getMasterTileEntity().getCookProgressScaled(scale) : 0);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == 1) {
            return this.myTank.fill(resource, doFill);
        }
        if (meta > 0 && this.hasMaster()) {
            return this.getMasterTileEntity().fill(from, resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = new FluidTankInfo((IFluidTank)this.myTank);
        } else if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 && this.hasMaster()) {
            fluidTankInfoArray = this.getMasterTileEntity().getTankInfo(from);
        } else {
            FluidTankInfo[] fluidTankInfoArray3 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray3;
            fluidTankInfoArray3[0] = new FluidTankInfo((IFluidTank)new FluidTank(0));
        }
        return fluidTankInfoArray;
    }

    @Override
    public void explode() {
        int clusterIndex;
        TileEntityFlashBoiler boiler = (TileEntityFlashBoiler)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (boiler != null && (clusterIndex = boiler.getValidClusterFromMetadata()) >= 0) {
            int[][] cluster = boiler.getClusterCoords(boiler.getValidClusterFromMetadata());
            for (int pos = 0; pos < cluster.length; ++pos) {
                TileEntityFlashBoiler otherBoiler;
                int x = cluster[pos][0];
                int y = cluster[pos][1];
                int z = cluster[pos][2];
                if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || (otherBoiler = (TileEntityFlashBoiler)this.field_145850_b.func_147438_o(x, y, z)) == null) continue;
                otherBoiler.secondaryExplosion();
            }
        }
        super.explode();
    }

    @Override
    public HashSet<ForgeDirection> getConnectionSides() {
        int meta = this.func_145832_p();
        HashSet<ForgeDirection> sides = new HashSet<ForgeDirection>();
        if (meta > 0) {
            if (meta > 4) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    sides.add(side);
                }
            } else {
                sides.add(ForgeDirection.UP);
            }
        }
        return sides;
    }

    public void secondaryExplosion() {
        this.shouldExplode = true;
    }

    public boolean getBurning() {
        int meta = this.func_145832_p();
        if (meta > 0) {
            if (meta == 1) {
                return this.burning;
            }
            if (this.hasMaster()) {
                return this.getMasterTileEntity().isBurning();
            }
        }
        return false;
    }

    @Override
    public FluidTank getTank() {
        if (this.func_145832_p() > 0) {
            if (this.func_145832_p() == 1) {
                return this.myTank;
            }
            if (this.hasMaster()) {
                return this.getMasterTileEntity().getTank();
            }
        }
        return null;
    }
}

