/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.common.Loader;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityFluidSteamConverter
extends SteamTransporterTileEntity
implements ISteamTransporter,
IFluidHandler,
IWrenchable {
    public int runTicks = 0;
    private FluidTank dummyTank;
    private FluidTank ic2DummyTank;
    private boolean isInitialized = false;
    private boolean lastRunning = false;
    public boolean pushing = false;
    private static final int PUSH_MAX = 250;

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74777_a("runTicks", (short)this.runTicks);
        access.func_74757_a("pushing", this.pushing);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        if (this.runTicks == 0 && access.func_74765_d("runTicks") != 0) {
            this.runTicks = access.func_74765_d("runTicks");
        }
        this.pushing = access.func_74767_n("pushing");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("pushing", this.pushing);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.pushing = par1NBTTagCompound.func_74767_n("pushing");
    }

    @Override
    public void func_145845_h() {
        if (this.runTicks > 0) {
            --this.runTicks;
        }
        if (this.runTicks > 0 != this.lastRunning) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        boolean bl = this.lastRunning = this.runTicks > 0;
        if (!this.isInitialized) {
            this.setDistributionDirections(new ForgeDirection[]{ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getOpposite()});
        }
        if (this.pushing) {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            SteamNetwork steamNetwork = this.getNetwork();
            if (tileEntity != null && tileEntity instanceof IFluidHandler && steamNetwork != null) {
                IFluidHandler tank = (IFluidHandler)tileEntity;
                int maxDrain = (int)(250.0f * steamNetwork.getPressure());
                if (maxDrain > 0) {
                    FluidStack avail = this.drain(dir, maxDrain, false);
                    int taken = tank.fill(dir.getOpposite(), avail, true);
                    steamNetwork.decrSteam(taken);
                }
            }
        }
        super.func_145845_h();
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            this.pushing = !this.pushing;
        } else {
            int steam = this.getSteamShare();
            this.getNetwork().split(this, true);
            this.setDistributionDirections(new ForgeDirection[]{ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getOpposite()});
            SteamNetwork.newOrJoin(this);
            this.getNetwork().addSteam(steam);
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (from.ordinal() != meta) {
            return 0;
        }
        if (this.pushing) {
            return 0;
        }
        if (resource.fluidID == FluidRegistry.getFluid((String)"steam").getID()) {
            if (doFill) {
                this.insertSteam(resource.amount, from);
                this.runTicks = this.runTicks > 0 ? this.runTicks : 100;
            }
            return resource.amount;
        }
        if (Loader.isModLoaded((String)"IC2") && Config.enableIC2Integration && resource.fluidID == FluidRegistry.getFluid((String)"ic2steam").getID()) {
            if (doFill) {
                this.insertSteam(resource.amount, from);
                this.runTicks = this.runTicks > 0 ? this.runTicks : 100;
            }
            return resource.amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (from.ordinal() != meta) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)"steam");
        int drained = resource.amount;
        if (this.getSteamShare() < drained) {
            drained = this.getSteamShare();
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            this.decrSteam(drained);
            int n = stack.amount > 0 ? (this.runTicks > 0 ? this.runTicks : 100) : (this.runTicks = this.runTicks);
        }
        if (Loader.isModLoaded((String)"IC2") && Config.enableIC2Integration) {
            Fluid ic2Fluid = FluidRegistry.getFluid((String)"ic2steam");
            int ic2Drained = resource.amount;
            if (this.getSteamShare() < ic2Drained) {
                ic2Drained = this.getSteamShare();
            }
            FluidStack ic2Stack = new FluidStack(ic2Fluid, ic2Drained);
            if (doDrain) {
                this.decrSteam(ic2Drained);
                this.runTicks = ic2Stack.amount > 0 ? (this.runTicks > 0 ? this.runTicks : 100) : this.runTicks;
            }
        }
        return stack;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (from.ordinal() != meta) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)"steam");
        int drained = maxDrain;
        if (this.getSteamShare() < drained) {
            drained = this.getSteamShare();
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            this.decrSteam(drained);
            int n = stack.amount > 0 ? (this.runTicks > 0 ? this.runTicks : 100) : (this.runTicks = this.runTicks);
        }
        if (Loader.isModLoaded((String)"IC2") && Config.enableIC2Integration) {
            Fluid ic2Fluid = FluidRegistry.getFluid((String)"ic2steam");
            int ic2Drained = maxDrain;
            if (this.getSteamShare() > ic2Drained) {
                ic2Drained = this.getSteamShare();
            }
            FluidStack ic2Stack = new FluidStack(ic2Fluid, ic2Drained);
            if (doDrain) {
                this.decrSteam(ic2Drained);
                this.runTicks = ic2Stack.amount > 0 ? (this.runTicks > 0 ? this.runTicks : 100) : this.runTicks;
            }
        }
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.pushing) {
            return false;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return from.ordinal() != meta;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return from.ordinal() != meta;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Object[] fti = new FluidTankInfo[]{};
        if (from.ordinal() != meta) {
            return fti;
        }
        Fluid steam = FluidRegistry.getFluid((String)"steam");
        if (steam != null) {
            fti = (FluidTankInfo[])ArrayUtils.add((Object[])fti, (Object)new FluidTank(new FluidStack(steam, this.getSteamShare()), this.getCapacity()).getInfo());
        }
        if ((steam = FluidRegistry.getFluid((String)"ic2steam")) != null) {
            fti = (FluidTankInfo[])ArrayUtils.add((Object[])fti, (Object)new FluidTank(new FluidStack(steam, this.getSteamShare()), this.getCapacity()).getInfo());
        }
        return fti;
    }
}

