/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class TileEntitySaw
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable,
IWrenchDisplay {
    private boolean hasBeenSet = false;
    private boolean hasBlockUpdate = false;
    private boolean isInitialized = false;
    public int spinup = 0;
    public float extendedLength = 0.0f;
    public Block sawingBlock;
    public int sawingMeta;
    public int extendedTicks = 0;
    public ArrayList<ItemStack> sawingStack;
    private boolean shouldStop = false;
    private boolean isActive = false;
    private boolean running = false;
    private boolean sawNextRound = false;
    private boolean isSawing = false;

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        this.hasBeenSet = access.func_74767_n("hasBeenSet");
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        access.func_74757_a("hasBeenSet", this.hasBeenSet);
        NBTTagList nbttaglist = new NBTTagList();
    }

    @Override
    public void displayWrench(RenderGameOverlayEvent.Post event) {
        GL11.glPushMatrix();
        int color = Minecraft.func_71410_x().field_71439_g.func_70093_af() ? 0xC6C6C6 : 0x777777;
        int x = event.resolution.func_78326_a() / 2 - 8;
        int y = event.resolution.func_78328_b() / 2 - 8;
        GL11.glPopMatrix();
    }

    private int[] getTarget(int distance) {
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        int opposite = 0;
        int meta = this.func_145832_p();
        opposite = meta % 2 == 0 ? meta + 1 : meta - 1;
        switch (meta) {
            case 2: {
                z -= distance;
                opposite = 3;
                break;
            }
            case 3: {
                z += distance;
                opposite = 2;
                break;
            }
            case 4: {
                x -= distance;
                opposite = 5;
                break;
            }
            case 5: {
                x += distance;
                opposite = 4;
                break;
            }
        }
        return new int[]{x, z, opposite};
    }

    public ForgeDirection myDir() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (meta) {
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.NORTH;
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            this.hasBeenSet = true;
            int[] target = this.getTarget(2);
            int x2 = target[0];
            int y2 = this.field_145848_d;
            int z2 = target[1];
            int opposite = target[2];
            if (this.field_145850_b.func_147439_a(x2, y2, z2) == SteamcraftBlocks.saw && this.field_145850_b.func_72805_g(x2, y2, z2) == opposite) {
                ((TileEntitySaw)this.field_145850_b.func_147438_o((int)x2, (int)y2, (int)z2)).hasBeenSet = true;
                this.field_145850_b.func_147471_g(x2, y2, z2);
            }
            this.field_145850_b.func_147471_g(x, y, z);
            return true;
        }
        int steam = this.getSteamShare();
        this.getNetwork().split(this, true);
        ForgeDirection[] directions = new ForgeDirection[5];
        int i = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (direction == this.myDir() || direction == ForgeDirection.UP) continue;
            directions[i] = direction;
            ++i;
        }
        this.setDistributionDirections(directions);
        SteamNetwork.newOrJoin(this);
        this.getNetwork().addSteam(steam);
        return true;
    }

    @Override
    public void func_145845_h() {
        if (!this.isInitialized) {
            ForgeDirection myDir = this.myDir();
            this.addSideToGaugeBlacklist(myDir);
            ForgeDirection[] directions = new ForgeDirection[5];
            int i = 0;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (direction == myDir || direction == ForgeDirection.UP) continue;
                directions[i] = direction;
                ++i;
            }
            this.setDistributionDirections(directions);
            this.isInitialized = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int[] target = this.getTarget(1);
            int x = target[0];
            int y = this.field_145848_d;
            int z = target[1];
            if (this.spinup == 1) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:hiss", Block.field_149788_p.func_150497_c(), 0.9f);
            }
            if (this.extendedTicks > 15) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:leaking", 2.0f, 0.9f);
            }
            if (this.extendedTicks == 5) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.break", 0.5f, (float)(0.75 + Math.random() * (double)0.1f));
            }
            if (this.extendedTicks > 0 && this.extendedTicks < 6 && this.sawingBlock != null && this.sawingBlock.field_149762_H != null) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), this.sawingBlock.field_149762_H.func_150495_a(), 0.5f, (float)(0.75 + Math.random() * (double)0.1f));
            }
            if (this.shouldStop) {
                this.spinup = 0;
                this.extendedLength = 0.0f;
                this.extendedTicks = 0;
                this.isActive = false;
                this.shouldStop = false;
                this.isSawing = false;
                this.running = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!this.sawNextRound && this.hasStuffToSaw() && this.getSteamShare() > 1000 && !this.isActive) {
                this.sawNextRound = true;
                return;
            }
            boolean sawThisRound = false;
            if (this.sawNextRound) {
                sawThisRound = true;
                this.sawNextRound = true;
            }
            if (sawThisRound && this.hasStuffToSaw() && !this.isActive) {
                this.decrSteam(750);
                this.running = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.isActive = true;
                this.isSawing = true;
            }
            if (this.isActive && this.isSawing) {
                if (!this.hasStuffToSaw() && this.spinup < 40 && this.func_145832_p() % 2 == 0) {
                    this.shouldStop = true;
                    int[] target2 = this.getTarget(2);
                    return;
                }
                if (this.spinup < 41) {
                    if (this.spinup == 40) {
                        if (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150364_r && this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150363_s && this.func_145832_p() % 2 == 0) {
                            try {
                                this.sawingBlock = this.field_145850_b.func_147439_a(x, y, z);
                                this.sawingMeta = this.field_145850_b.func_72805_g(x, y, z);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (this.extendedTicks < 25) {
                        ++this.extendedTicks;
                    }
                } else {
                    this.spinup = 0;
                    this.extendedTicks = 0;
                }
            }
        }
    }

    private void spawnItems(int x, int y, int z) {
        if (this.sawingBlock != null) {
            for (ItemStack itemStack : this.sawingStack) {
                int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
                boolean isWood = false;
                int id = 0;
                if (ids != null && ids.length > 0) {
                    id = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
                }
                if (Block.func_149634_a((Item)itemStack.func_77973_b()) != Blocks.field_150364_r) continue;
                boolean duplicateLogs = this.field_145850_b.field_73012_v.nextInt(Config.duplicateLogs) == 0;
                ItemStack items = new ItemStack(Blocks.field_150344_f);
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)x + 0.5f), (double)((float)y + 0.1f), (double)((float)z + 0.5f), items);
                this.field_145850_b.func_72838_d((Entity)entityItem);
                this.sawingBlock = null;
            }
        }
    }

    private boolean hasStuffToSaw() {
        int z;
        int y;
        int[] target = this.getTarget(1);
        int x = target[0];
        return this.field_145850_b.func_147439_a(x, y = this.field_145848_d, z = target[1]) == Blocks.field_150364_r;
    }

    public void blockUpdate() {
        this.hasBlockUpdate = true;
    }
}

