/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import flaxbeard.steamcraft.block.BlockPipe;
import flaxbeard.steamcraft.client.render.BlockSteamPipeRenderer;
import flaxbeard.steamcraft.codechicken.lib.raytracer.IndexedCuboid6;
import flaxbeard.steamcraft.codechicken.lib.raytracer.RayTracer;
import flaxbeard.steamcraft.codechicken.lib.vec.Cuboid6;
import flaxbeard.steamcraft.packet.SteamcraftClientPacketHandler;
import flaxbeard.steamcraft.packet.SteamcraftServerPacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySteamPipe
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable {
    public ArrayList<Integer> blacklistedSides = new ArrayList();
    public Block disguiseBlock = null;
    public int disguiseMeta = 0;
    public boolean isOriginalPipe = false;
    public boolean isOtherPipe = false;
    protected boolean isLeaking = false;
    private boolean isSplitting = false;
    private int mySteam = 0;
    private boolean lastWrench = false;

    public TileEntitySteamPipe() {
        super(ForgeDirection.values());
        this.name = "Pipe";
    }

    public TileEntitySteamPipe(int capacity) {
        this();
        this.capacity = capacity;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74757_a("isLeaking", this.isLeaking);
        NBTTagCompound list = new NBTTagCompound();
        int g = 0;
        for (int i : this.blacklistedSides) {
            list.func_74768_a(Integer.toString(g), i);
            ++g;
        }
        list.func_74768_a("size", g);
        access.func_74782_a("blacklistedSides", (NBTBase)list);
        access.func_74768_a("disguiseBlock", Block.func_149682_b((Block)this.disguiseBlock));
        access.func_74768_a("disguiseMeta", this.disguiseMeta);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.isLeaking = access.func_74767_n("isLeaking");
        NBTTagCompound sidesList = access.func_74775_l("blacklistedSides");
        int length = sidesList.func_74762_e("size");
        Integer[] sidesInt = new Integer[length];
        for (int i = 0; i < length; ++i) {
            sidesInt[i] = sidesList.func_74762_e(Integer.toString(i));
        }
        this.blacklistedSides = new ArrayList<Integer>(Arrays.asList(sidesInt));
        this.disguiseBlock = Block.func_149729_e((int)access.func_74762_e("disguiseBlock"));
        this.disguiseMeta = access.func_74762_e("disguiseMeta");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        NBTTagCompound sidesList = access.func_74775_l("blacklistedSides");
        int length = sidesList.func_74762_e("size");
        Integer[] sidesInt = new Integer[length];
        for (int i = 0; i < length; ++i) {
            sidesInt[i] = sidesList.func_74762_e(Integer.toString(i));
        }
        this.blacklistedSides = new ArrayList<Integer>(Arrays.asList(sidesInt));
        this.disguiseBlock = Block.func_149729_e((int)access.func_74762_e("disguiseBlock"));
        this.disguiseMeta = access.func_74762_e("disguiseMeta");
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        NBTTagCompound list = new NBTTagCompound();
        int g = 0;
        for (int i : this.blacklistedSides) {
            list.func_74768_a(Integer.toString(g), i);
            ++g;
        }
        list.func_74768_a("size", g);
        access.func_74782_a("blacklistedSides", (NBTBase)list);
        access.func_74768_a("disguiseBlock", Block.func_149682_b((Block)this.disguiseBlock));
        access.func_74768_a("disguiseMeta", this.disguiseMeta);
    }

    public void superUpdate() {
        super.func_145845_h();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            boolean hasWrench = BlockSteamPipeRenderer.updateWrenchStatus();
            if (hasWrench != this.lastWrench && this.disguiseBlock != null && this.disguiseBlock != Blocks.field_150350_a) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.lastWrench = hasWrench;
        }
        ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
        for (ForgeDirection direction : ForgeDirection.values()) {
            ISteamTransporter target;
            if (!this.doesConnect(direction) || this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) == null) continue;
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tile instanceof ISteamTransporter) {
                target = (ISteamTransporter)tile;
                if (!target.doesConnect(direction.getOpposite())) continue;
                myDirections.add(direction);
                continue;
            }
            if (!(tile instanceof IFluidHandler) || !Steamcraft.steamRegistered || !(target = (IFluidHandler)tile).canDrain(direction.getOpposite(), FluidRegistry.getFluid((String)"steam")) && !target.canFill(direction.getOpposite(), FluidRegistry.getFluid((String)"steam"))) continue;
            myDirections.add(direction);
        }
        int i = 0;
        if (myDirections.size() > 0) {
            ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
            while (!this.doesConnect(direction) || direction == myDirections.get(0)) {
                direction = ForgeDirection.getOrientation((int)((direction.ordinal() + 1) % 5));
            }
            if (!this.field_145850_b.field_72995_K) {
                if (myDirections.size() == 2 && this.getSteamShare() > 0 && i < 10 && (this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) || !this.field_145850_b.isSideSolid(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction.getOpposite()))) {
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:leaking", 2.0f, 0.9f);
                    if (!this.isLeaking) {
                        this.isLeaking = true;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.func_70296_d();
                    }
                } else if (this.isLeaking) {
                    this.isLeaking = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_70296_d();
                }
                while (myDirections.size() == 2 && this.getPressure() > 0.0f && i < 10 && (this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) || !this.field_145850_b.isSideSolid(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction.getOpposite()))) {
                    if (this.field_145850_b.field_72995_K) {
                        // empty if block
                    }
                    this.decrSteam(10);
                    ++i;
                }
            }
            if (this.field_145850_b.field_72995_K && this.isLeaking) {
                this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), (double)((float)direction.offsetX * 0.1f), (double)((float)direction.offsetY * 0.1f), (double)((float)direction.offsetZ * 0.1f));
            }
        }
    }

    @Override
    public HashSet<ForgeDirection> getConnectionSides() {
        HashSet<ForgeDirection> out = new HashSet<ForgeDirection>();
        HashSet<ForgeDirection> blacklist = new HashSet<ForgeDirection>();
        for (int i : this.blacklistedSides) {
            blacklist.add(ForgeDirection.getOrientation((int)i));
        }
        for (ForgeDirection d : this.distributionDirections) {
            if (blacklist.contains(d)) continue;
            out.add(d);
        }
        return out;
    }

    @Override
    public boolean doesConnect(ForgeDirection face) {
        for (int i : this.blacklistedSides) {
            if (ForgeDirection.getOrientation((int)i) != face) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSteamShare() {
        if (this.getNetwork() == null) {
            this.network = null;
            this.networkName = null;
            return 0;
        }
        return (int)Math.floor((double)this.getNetwork().getPressure() * (double)this.capacity);
    }

    public MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, MovingObjectPosition fullblock) {
        return fullblock;
    }

    private int canConnectSide(int side) {
        TileEntity tile;
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) != null && (tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) instanceof ISteamTransporter) {
            ISteamTransporter target = (ISteamTransporter)tile;
            if (target.doesConnect(direction.getOpposite())) {
                return target instanceof TileEntitySteamPipe ? 2 : 1;
            }
            if (target instanceof TileEntitySteamPipe && ((TileEntitySteamPipe)target).blacklistedSides.contains(direction.getOpposite().ordinal())) {
                return 2;
            }
        }
        return 0;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        float top;
        float bottom;
        float min = 0.25f;
        float max = 0.75f;
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.canConnectSide(0) > 0) {
            bottom = this.canConnectSide(0) == 2 ? -0.3125f : 0.0f;
            cuboids.add(new IndexedCuboid6(0, new Cuboid6((float)this.field_145851_c + min, (float)this.field_145848_d + bottom, (float)this.field_145849_e + min, (float)this.field_145851_c + max, (float)this.field_145848_d + 0.3125f, (float)this.field_145849_e + max)));
        }
        if (this.canConnectSide(1) > 0) {
            top = this.canConnectSide(1) == 2 ? 1.3125f : 1.0f;
            cuboids.add(new IndexedCuboid6(1, new Cuboid6((float)this.field_145851_c + min, (float)this.field_145848_d + 0.6875f, (float)this.field_145849_e + min, (float)this.field_145851_c + max, (float)this.field_145848_d + top, (float)this.field_145849_e + max)));
        }
        if (this.canConnectSide(2) > 0) {
            bottom = this.canConnectSide(2) == 2 ? -0.3125f : 0.0f;
            cuboids.add(new IndexedCuboid6(2, new Cuboid6((float)this.field_145851_c + min, (float)this.field_145848_d + min, (float)this.field_145849_e + bottom, (float)this.field_145851_c + max, (float)this.field_145848_d + max, (float)this.field_145849_e + 0.3125f)));
        }
        if (this.canConnectSide(3) > 0) {
            top = this.canConnectSide(3) == 2 ? 1.3125f : 1.0f;
            cuboids.add(new IndexedCuboid6(3, new Cuboid6((float)this.field_145851_c + min, (float)this.field_145848_d + min, (float)this.field_145849_e + 0.6875f, (float)this.field_145851_c + max, (float)this.field_145848_d + max, (float)this.field_145849_e + top)));
        }
        if (this.canConnectSide(4) > 0) {
            bottom = this.canConnectSide(4) == 2 ? -0.3125f : 0.0f;
            cuboids.add(new IndexedCuboid6(4, new Cuboid6((float)this.field_145851_c + bottom, (float)this.field_145848_d + min, (float)this.field_145849_e + min, (float)this.field_145851_c + 0.3125f, (float)this.field_145848_d + max, (float)this.field_145849_e + max)));
        }
        if (this.canConnectSide(5) > 0) {
            top = this.canConnectSide(5) == 2 ? 1.3125f : 1.0f;
            cuboids.add(new IndexedCuboid6(5, new Cuboid6((float)this.field_145851_c + 0.6875f, (float)this.field_145848_d + min, (float)this.field_145849_e + min, (float)this.field_145851_c + top, (float)this.field_145848_d + max, (float)this.field_145849_e + max)));
        }
        cuboids.add(new IndexedCuboid6(6, new Cuboid6((float)this.field_145851_c + 0.3125f, (float)this.field_145848_d + 0.3125f, (float)this.field_145849_e + 0.3125f, (float)this.field_145851_c + 0.6875f, (float)this.field_145848_d + 0.6875f, (float)this.field_145849_e + 0.6875f)));
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            if (this.disguiseBlock != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(this.disguiseBlock, 1, this.disguiseMeta));
                    world.func_72838_d((Entity)entityItem);
                }
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.disguiseBlock.field_149762_H.func_150495_a(), (this.disguiseBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.disguiseBlock.field_149762_H.func_150494_d() * 0.8f);
                this.disguiseBlock = null;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        } else if (this.field_145850_b.field_72995_K) {
            MovingObjectPosition hit = RayTracer.retraceBlock(world, player, x, y, z);
            if (hit == null) {
                return false;
            }
            SteamcraftClientPacketHandler.sendConnectPacket((Entity)player, x, y, z, hit);
        }
        return false;
    }

    public void connectDisconnect(World world, int x, int y, int z, int subHit) {
        if (subHit >= 0 && subHit < 6 && world.func_147439_a(x, y, z) instanceof BlockPipe) {
            int sidesConnect = 0;
            for (int i = 0; i < 6; ++i) {
                if (!this.doesConnect(ForgeDirection.getOrientation((int)i))) continue;
                ++sidesConnect;
            }
            boolean netChange = false;
            if (this.doesConnect(ForgeDirection.getOrientation((int)subHit))) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)subHit);
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (tile instanceof TileEntitySteamPipe && ((TileEntitySteamPipe)tile).blacklistedSides.contains(direction.getOpposite().ordinal())) {
                    TileEntitySteamPipe pipe = (TileEntitySteamPipe)tile;
                    pipe.blacklistedSides.remove((Object)direction.getOpposite().ordinal());
                    int steam = pipe.getNetwork().split(pipe, false);
                    pipe.shouldJoin();
                    pipe.isOtherPipe = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                } else if (sidesConnect > 2) {
                    this.blacklistedSides.add(subHit);
                    ForgeDirection d = ForgeDirection.getOrientation((int)subHit);
                    TileEntity te = this.field_145850_b.func_147438_o(x + d.offsetX, y + d.offsetY, z + d.offsetZ);
                    if (te != null && te instanceof ISteamTransporter) {
                        ISteamTransporter p = (ISteamTransporter)te;
                        p.getNetwork().shouldRefresh();
                    }
                    this.isOriginalPipe = true;
                    int steam = this.getNetwork().split(this, false);
                    this.shouldJoin();
                    this.refreshNeighbors();
                    this.network.shouldRefresh();
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (!this.doesConnect(ForgeDirection.getOrientation((int)subHit)) && this.blacklistedSides.contains(subHit)) {
                this.blacklistedSides.remove((Object)subHit);
                int steam = this.getNetwork().split(this, false);
                this.shouldJoin();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.getSteamShare() > 0) {
                ForgeDirection d = ForgeDirection.getOrientation((int)subHit);
                SteamcraftServerPacketHandler.sendPipeConnectDisconnectPacket(this.getDimension(), (float)this.field_145851_c + 0.5f + (float)d.offsetX / 2.0f, (float)this.field_145848_d + 0.5f + (float)d.offsetY / 2.0f, (float)this.field_145849_e + 0.5f + (float)d.offsetZ / 2.0f);
            }
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "steamcraft:wrench", 2.0f, 0.9f);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.isOriginalPipe = false;
        this.isOtherPipe = false;
    }

    private void refreshNeighbors() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ISteamTransporter trans;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te == null || !(te instanceof ISteamTransporter) || (trans = (ISteamTransporter)te).getNetwork() == this.getNetwork()) continue;
            trans.getNetwork().shouldRefresh();
        }
    }
}

