/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityVacuum
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable,
IWrenchDisplay {
    private static int steamUsage = 3;
    public boolean active;
    public boolean powered = false;
    public boolean lastSteam = false;
    public int rotateTicks = 0;
    public int range = 9;
    private boolean isInitialized = false;

    public static boolean isLyingInCone(float[] x, float[] t, float[] b, float aperture) {
        float[] axisVect;
        boolean isInInfiniteCone;
        float halfAperture = aperture / 2.0f;
        float[] apexToXVect = TileEntityVacuum.dif(t, x);
        boolean bl = isInInfiniteCone = (double)(TileEntityVacuum.dotProd(apexToXVect, axisVect = TileEntityVacuum.dif(t, b)) / TileEntityVacuum.magn(apexToXVect) / TileEntityVacuum.magn(axisVect)) > Math.cos(halfAperture);
        if (!isInInfiniteCone) {
            return false;
        }
        boolean isUnderRoundCap = TileEntityVacuum.dotProd(apexToXVect, axisVect) / TileEntityVacuum.magn(axisVect) < TileEntityVacuum.magn(axisVect);
        return isUnderRoundCap;
    }

    public static float dotProd(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static float[] dif(float[] a, float[] b) {
        return new float[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
    }

    public static float magn(float[] a) {
        return (float)Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    @Override
    public void func_145845_h() {
        block26: {
            if (this.lastSteam != this.getSteamShare() > steamUsage) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            boolean bl = this.lastSteam = this.getSteamShare() > steamUsage;
            if (!this.isInitialized) {
                this.powered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ForgeDirection myDir = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                ForgeDirection[] directions = new ForgeDirection[5];
                int i = 0;
                for (ForgeDirection direction : ForgeDirection.values()) {
                    if (direction == myDir || direction == myDir.getOpposite()) continue;
                    directions[i] = direction;
                    ++i;
                }
                this.setDistributionDirections(directions);
                this.isInitialized = true;
            }
            super.func_145845_h();
            if (!this.field_145850_b.field_72995_K) {
                if (this.getSteamShare() < steamUsage || this.powered) {
                    this.active = false;
                } else {
                    this.active = true;
                    this.decrSteam(steamUsage);
                }
            }
            if (!this.active) break block26;
            if (this.field_145850_b.field_72995_K) {
                ++this.rotateTicks;
            }
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
            float[] M = new float[]{(float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f};
            float[] N = new float[]{(float)this.field_145851_c + 0.5f + (float)(this.range * dir.offsetX), (float)this.field_145848_d + 0.5f + (float)(this.range * dir.offsetY), (float)this.field_145849_e + 0.5f + (float)(this.range * dir.offsetZ)};
            float theta = 1.5707964f;
            List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20)));
            for (int i = 0; i < 200; ++i) {
                float[] X = new float[]{this.field_145850_b.field_73012_v.nextFloat() * 40.0f - 20.0f + (float)this.field_145851_c, this.field_145850_b.field_73012_v.nextFloat() * 40.0f - 20.0f + (float)this.field_145848_d, this.field_145850_b.field_73012_v.nextFloat() * 40.0f - 20.0f + (float)this.field_145849_e};
                if (!TileEntityVacuum.isLyingInCone(X, M, N, theta) || this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)X[0], (double)X[1], (double)X[2]), Vec3.func_72443_a((double)((float)this.field_145851_c + 0.5f + (float)dir.offsetX), (double)((float)this.field_145848_d + 0.5f + (float)dir.offsetY), (double)((float)this.field_145849_e + 0.5f + (float)dir.offsetZ))) != null) continue;
                Vec3 vec = Vec3.func_72443_a((double)(X[0] - M[0]), (double)(X[1] - M[1]), (double)(X[2] - M[2]));
                vec = vec.func_72432_b();
                this.field_145850_b.func_72869_a("smoke", (double)X[0], (double)X[1], (double)X[2], -vec.field_72450_a * 0.5, -vec.field_72448_b * 0.5, -vec.field_72449_c * 0.5);
            }
            for (Object obj : entities) {
                Entity entity = (Entity)obj;
                float[] X = new float[]{(float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v};
                if (!TileEntityVacuum.isLyingInCone(X, M, N, theta) || this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v), Vec3.func_72443_a((double)((float)this.field_145851_c + 0.5f + (float)dir.offsetX), (double)((float)this.field_145848_d + 0.5f + (float)dir.offsetY), (double)((float)this.field_145849_e + 0.5f + (float)dir.offsetZ))) != null || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
                Vec3 vec = Vec3.func_72443_a((double)(X[0] - M[0]), (double)(X[1] - M[1]), (double)(X[2] - M[2]));
                vec = vec.func_72432_b();
                vec.field_72448_b *= 1.0;
                if (entity.func_70093_af()) {
                    vec.field_72450_a *= 0.25;
                    vec.field_72448_b *= 0.25;
                    vec.field_72449_c *= 0.25;
                }
                entity.field_70159_w -= vec.field_72450_a * (double)0.025f;
                entity.field_70181_x -= vec.field_72448_b * (double)0.05f;
                entity.field_70179_y -= vec.field_72449_c * (double)0.025f;
                entity.field_70143_R = 0.0f;
            }
            List list = this.field_145850_b.func_82733_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + (float)dir.offsetX * 0.25f), (double)((float)this.field_145848_d + (float)dir.offsetY * 0.25f), (double)((float)this.field_145849_e + (float)dir.offsetZ * 0.25f), (double)((double)this.field_145851_c + 1.0 + (double)((float)dir.offsetX * 0.25f)), (double)((double)this.field_145848_d + 1.0 + (double)((float)dir.offsetY * 0.25f)), (double)((double)this.field_145849_e + 1.0 + (double)((float)dir.offsetZ * 0.25f))), IEntitySelector.field_94557_a);
            if (list.size() > 0) {
                ISidedInventory inv;
                EntityItem item = (EntityItem)list.get(0);
                if (this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ) != null && this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ) instanceof ISidedInventory) {
                    inv = (ISidedInventory)this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ);
                    int[] access = inv.func_94128_d(dir.getOpposite().flag);
                    for (int j = 0; j < access.length; ++j) {
                        int i = access[j];
                        ItemStack checkStack1 = null;
                        ItemStack checkStack2 = null;
                        if (inv.func_70301_a(i) != null) {
                            checkStack1 = inv.func_70301_a(i).func_77946_l();
                            checkStack1.field_77994_a = 1;
                            checkStack2 = item.func_92059_d().func_77946_l();
                            checkStack2.field_77994_a = 1;
                        }
                        if (inv.func_70301_a(i) != null) {
                            item.func_92059_d();
                            if (!ItemStack.func_77989_b((ItemStack)checkStack1, checkStack2) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d()) continue;
                        }
                        if (!inv.func_94041_b(i, item.func_92059_d()) || !inv.func_102007_a(i, item.func_92059_d(), dir.getOpposite().flag)) continue;
                        ItemStack stack = item.func_92059_d().func_77946_l();
                        boolean setDead = true;
                        if (inv.func_70301_a(i) != null) {
                            if (inv.func_70301_a((int)i).field_77994_a + stack.field_77994_a > stack.func_77976_d()) {
                                setDead = false;
                                int total = inv.func_70301_a((int)i).field_77994_a + stack.field_77994_a;
                                stack.field_77994_a = stack.func_77976_d();
                                checkStack2.field_77994_a = total -= stack.func_77976_d();
                                item.func_92058_a(checkStack2);
                            } else {
                                stack.field_77994_a = inv.func_70301_a((int)i).field_77994_a + item.func_92059_d().field_77994_a;
                            }
                        }
                        inv.func_70299_a(i, stack);
                        if (!setDead) break;
                        item.func_70106_y();
                        break;
                    }
                } else if (this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ) != null && this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ) instanceof IInventory) {
                    inv = (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d - dir.offsetY, this.field_145849_e - dir.offsetZ);
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack checkStack1 = null;
                        ItemStack checkStack2 = null;
                        if (inv.func_70301_a(i) != null) {
                            checkStack1 = inv.func_70301_a(i).func_77946_l();
                            checkStack1.field_77994_a = 1;
                            checkStack2 = item.func_92059_d().func_77946_l();
                            checkStack2.field_77994_a = 1;
                        }
                        if (inv.func_70301_a(i) != null) {
                            item.func_92059_d();
                            if (!ItemStack.func_77989_b((ItemStack)checkStack1, checkStack2) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d()) continue;
                        }
                        if (!inv.func_94041_b(i, item.func_92059_d())) continue;
                        ItemStack stack = item.func_92059_d().func_77946_l();
                        boolean setDead = true;
                        if (inv.func_70301_a(i) != null) {
                            if (inv.func_70301_a((int)i).field_77994_a + stack.field_77994_a > stack.func_77976_d()) {
                                setDead = false;
                                int total = inv.func_70301_a((int)i).field_77994_a + stack.field_77994_a;
                                stack.field_77994_a = stack.func_77976_d();
                                checkStack2.field_77994_a = total -= stack.func_77976_d();
                                item.func_92058_a(checkStack2);
                            } else {
                                stack.field_77994_a = inv.func_70301_a((int)i).field_77994_a + item.func_92059_d().field_77994_a;
                            }
                        }
                        inv.func_70299_a(i, stack);
                        if (!setDead) break;
                        item.func_70106_y();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        access.func_74757_a("powered", this.powered);
        access.func_74777_a("range", (short)this.range);
    }

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        this.powered = access.func_74767_n("powered");
        this.range = access.func_74765_d("range");
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74757_a("active", this.getSteamShare() > steamUsage && !this.powered);
        access.func_74777_a("range", (short)this.range);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.active = access.func_74767_n("active");
        this.range = access.func_74765_d("range");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void updateRedstoneState(boolean flag) {
        if (flag != this.powered) {
            this.powered = flag;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            switch (this.range) {
                case 9: {
                    this.range = 11;
                    break;
                }
                case 11: {
                    this.range = 13;
                    break;
                }
                case 13: {
                    this.range = 15;
                    break;
                }
                case 15: {
                    this.range = 17;
                    break;
                }
                case 17: {
                    this.range = 19;
                    break;
                }
                case 19: {
                    this.range = 5;
                    break;
                }
                case 5: {
                    this.range = 7;
                    break;
                }
                case 7: {
                    this.range = 9;
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        int steam = this.getSteamShare();
        this.getNetwork().split(this, true);
        ForgeDirection myDir = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        ForgeDirection[] directions = new ForgeDirection[5];
        int i = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (direction == myDir || direction == myDir.getOpposite()) continue;
            directions[i] = direction;
            ++i;
        }
        this.setDistributionDirections(directions);
        SteamNetwork.newOrJoin(this);
        this.getNetwork().addSteam(steam);
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayWrench(RenderGameOverlayEvent.Post event) {
        GL11.glPushMatrix();
        int color = Minecraft.func_71410_x().field_71439_g.func_70093_af() ? 0xC6C6C6 : 0x777777;
        int x = event.resolution.func_78326_a() / 2 - 8;
        int y = event.resolution.func_78328_b() / 2 - 8;
        Minecraft.func_71410_x().field_71466_p.func_78261_a(StatCollector.func_74838_a((String)"steamcraft.fan.range") + " " + this.range + " " + StatCollector.func_74838_a((String)"steamcraft.fan.blocks"), x + 15, y + 13, color);
        GL11.glPopMatrix();
    }
}

