/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.block.BlockRuptureDisc;
import flaxbeard.steamcraft.client.audio.ISoundTile;
import flaxbeard.steamcraft.client.audio.SoundTile;
import flaxbeard.steamcraft.client.audio.Sounds;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWhistle
extends TileEntity
implements ISoundTile {
    private static final ResourceLocation SOUND = new ResourceLocation("steamcraft:horn");
    private float volume = 0.0f;
    private boolean isSoundRegistered = false;
    private boolean isSounding = false;
    private int steamTick = 0;
    private boolean isReallyDead = false;

    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound access = new NBTTagCompound();
        access.func_74757_a("isSounding", this.isSounding);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.isSounding = access.func_74767_n("isSounding");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        } else if (this.shouldPlay()) {
            if (!this.isSounding) {
                this.isSounding = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.isSounding) {
            this.isSounding = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!this.isSoundRegistered) {
            if (this.field_145850_b.field_72995_K) {
                Sounds.addSoundTile(this);
            }
            this.isSoundRegistered = true;
        }
        if (this.isSounding) {
            if (this.steamTick == 0) {
                ForgeDirection d = this.myDir().getOpposite();
                Object source = null;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
                float offset = 0.125f;
                if (te != null && te instanceof TileEntitySteamPipe) {
                    offset = 0.375f;
                }
                float offset2 = 0.041666668f;
                float xOffset = (float)this.myDir().getOpposite().offsetX * offset;
                float zOffset = (float)this.myDir().getOpposite().offsetZ * offset;
                float xOffset2 = (float)this.myDir().getOpposite().offsetX * offset2;
                float zOffset2 = (float)this.myDir().getOpposite().offsetZ * offset2;
                this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5 + (double)zOffset, (double)(0.0f - xOffset2), (double)0.05f, (double)(0.0f - zOffset2));
            }
            ++this.steamTick;
            if (this.steamTick >= 4) {
                this.steamTick = 0;
            }
            if (this.volume < 0.75f) {
                this.volume += 0.01f;
            }
        } else {
            this.volume = this.volume > 0.0f ? (this.volume -= 0.25f) : 0.0f;
        }
    }

    private void drainSteam(int s) {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            source.decrSteam(s);
        }
    }

    private int getSteam() {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            if (this.field_145850_b.field_72995_K) {
                // empty if block
            }
            return source.getSteamShare();
        }
        return 0;
    }

    private float getPressure() {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            return source.getPressure();
        }
        return 0.0f;
    }

    private ForgeDirection myDir() {
        return ForgeDirection.getOrientation((int)BlockRuptureDisc.getMeta(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
    }

    public float getVolume() {
        return this.volume;
    }

    @Override
    public boolean shouldPlay() {
        return this.getPressure() > 1.02f;
    }

    @Override
    public ResourceLocation getSound() {
        return SOUND;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean handleUpdate() {
        return true;
    }

    @Override
    public void update(SoundTile soundTile) {
        soundTile.volume = this.getVolume();
    }
}

