/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.debughelper;

import cofh.thermaldynamics.debughelper.DebugTickHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class DebugHelper {
    public static boolean debug;
    public static final Logger log;
    public static long time;
    private static Random rand;
    static String[] glStates;
    @SideOnly(value=Side.CLIENT)
    public static int[] glCaps;
    public static TObjectLongHashMap<String> subTicks;
    public static TObjectLongHashMap<String> markTicks;
    public static TObjectIntHashMap<String> subTickCalls;

    public static void init() {
        if (!debug) {
            return;
        }
        FMLCommonHandler.instance().bus().register((Object)DebugTickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)DebugTickHandler.INSTANCE);
    }

    public static void info(Object object) {
        if (debug) {
            log.info(object);
        }
    }

    public static <T> T logObject(T t) {
        DebugHelper.info(t);
        return t;
    }

    public static void startTimer() {
        time = System.nanoTime();
    }

    public static void stopTimer(String string) {
        if (debug) {
            double d = (double)(System.nanoTime() - time) * 1.0E-6;
            log.info(string + ": " + d + " ms");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void showParticle(World world, double d, double d2, double d3, int n) {
        rand.setSeed(n);
        double d4 = rand.nextDouble();
        double d5 = rand.nextDouble();
        double d6 = rand.nextDouble();
        double d7 = 1.0 / (d4 > d5 ? (d6 > d4 ? d6 : d4) : (d6 > d5 ? d6 : d5));
        d4 *= d7;
        d5 *= d7;
        d6 *= d7;
        if (world == null) {
            world = Minecraft.func_71410_x().field_71441_e;
        }
        world.func_72869_a("reddust", d, d2, d3, d4, d5, d6);
    }

    public static void quit() {
        FMLCommonHandler.instance().exitJava(0, true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void initGLStates() {
        glCaps = new int[glStates.length];
        for (int i = 0; i < glStates.length; ++i) {
            DebugHelper.glCaps[i] = -1;
            try {
                DebugHelper.glCaps[i] = GL11.class.getField(glStates[i]).getInt(null);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void logGLStates() {
        if (glCaps == null) {
            DebugHelper.initGLStates();
        }
        for (int i = 0; i < glCaps.length; ++i) {
            if (glCaps[i] == -1 || !GL11.glIsEnabled((int)glCaps[i])) continue;
            DebugHelper.info(glStates[i]);
        }
    }

    public static void startTimerTick(String string) {
        subTickCalls.adjustOrPutValue((Object)string, 1, 1);
        long l = System.nanoTime();
        markTicks.put((Object)string, l);
    }

    public static void stopTimerTick(String string) {
        long l = System.nanoTime();
        long l2 = l - markTicks.get((Object)string);
        subTicks.adjustOrPutValue((Object)string, l2, l2);
    }

    static {
        try {
            World.class.getMethod("getBlock", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            debug = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug = false;
        }
        log = LogManager.getLogger((String)"ThermalDebug");
        time = 0L;
        rand = new Random();
        glStates = new String[]{"GL_ALPHA_TEST", "GL_AUTO_NORMAL", "GL_BLEND", "GL_CLIP_PLANE i", "GL_COLOR_ARRAY", "GL_COLOR_LOGIC_OP", "GL_COLOR_MATERIAL", "GL_CULL_FACE", "GL_DEPTH_TEST", "GL_DITHER", "GL_FOG", "GL_INDEX_ARRAY", "GL_INDEX_LOGIC_OP", "GL_LIGHT i", "GL_LIGHTING", "GL_LINE_SMOOTH", "GL_LINE_STIPPLE", "GL_MAP1_COLOR_4", "GL_MAP1_INDEX", "GL_MAP1_NORMAL", "GL_MAP1_TEXTURE_COORD_1", "GL_MAP1_TEXTURE_COORD_2", "GL_MAP1_TEXTURE_COORD_3", "GL_MAP1_TEXTURE_COORD_4", "GL_MAP1_VERTEX_3", "GL_MAP1_VERTEX_4", "GL_MAP2_COLOR_4", "GL_MAP2_INDEX", "GL_MAP2_NORMAL", "GL_MAP2_TEXTURE_COORD_1", "GL_MAP2_TEXTURE_COORD_2", "GL_MAP2_TEXTURE_COORD_3", "GL_MAP2_TEXTURE_COORD_4", "GL_MAP2_VERTEX_3", "GL_MAP2_VERTEX_4", "GL_NORMAL_ARRAY", "GL_NORMALIZE", "GL_POINT_SMOOTH", "GL_POLYGON_OFFSET_FILL", "GL_POLYGON_OFFSET_LINE", "GL_POLYGON_OFFSET_POINT", "GL_POLYGON_SMOOTH", "GL_POLYGON_STIPPLE", "GL_SCISSOR_TEST", "GL_STENCIL_TEST", "GL_TEXTURE_1D", "GL_TEXTURE_2D", "GL_TEXTURE_COORD_ARRAY", "GL_TEXTURE_GEN_Q", "GL_TEXTURE_GEN_R", "GL_TEXTURE_GEN_S", "GL_TEXTURE_GEN_T", "GL_VERTEX_ARRAY"};
        subTicks = new TObjectLongHashMap();
        markTicks = new TObjectLongHashMap();
        subTickCalls = new TObjectIntHashMap();
    }
}

