/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import cofh.lib.util.helpers.MathHelper;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.BlockRenderer;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ModelHelper {
    static Vector3[] axes = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    static int[] sideMasks = new int[]{3, 3, 12, 12, 48, 48};
    static BlockRenderer.BlockFace face = new BlockRenderer.BlockFace();
    static int[][] orthogonals = new int[][]{{6, 6, 4, 5, 2, 3}, {6, 6, 4, 5, 2, 3}, {4, 5, 6, 6, 0, 1}, {5, 4, 6, 6, 1, 0}, {2, 3, 0, 1, 6, 6}, {3, 2, 1, 0, 6, 6}};
    static int[][] edgePairs = new int[][]{{0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}};
    static int[][] cornerTriplets = new int[][]{{0, 2, 4}, {0, 2, 5}, {0, 3, 4}, {0, 3, 5}, {1, 2, 4}, {1, 2, 5}, {1, 3, 4}, {1, 3, 5}};
    static int[][] orthogAxes = new int[][]{{2, 4}, {2, 4}, {0, 4}, {0, 4}, {0, 2}, {0, 2}};

    public static void finalizeModel(CCModel cCModel) {
        cCModel.shrinkUVs(9.765625E-4).computeNormals().computeLighting(LightModel.standardLightModel);
    }

    public static CCModel expandModel(CCModel cCModel, double d) {
        return ModelHelper.expandModel(cCModel, new Cuboid6(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), d);
    }

    public static CCModel expandModel(CCModel cCModel, Cuboid6 cuboid6, double d) {
        CCModel cCModel2 = CCModel.newModel((int)(cCModel.vp == 4 ? 7 : 3), (int)cCModel.verts.length);
        for (Vertex5 vertex5 : cCModel2.verts = (Vertex5[])cCModel.verts.clone()) {
            vertex5.vec.multiply(d);
            if (vertex5.vec.x < cuboid6.min.x) {
                vertex5.vec.x = cuboid6.min.x;
            }
            if (vertex5.vec.y < cuboid6.min.y) {
                vertex5.vec.y = cuboid6.min.y;
            }
            if (vertex5.vec.z < cuboid6.min.z) {
                vertex5.vec.z = cuboid6.min.z;
            }
            if (vertex5.vec.x > cuboid6.max.x) {
                vertex5.vec.x = cuboid6.max.x;
            }
            if (vertex5.vec.y > cuboid6.max.y) {
                vertex5.vec.y = cuboid6.max.y;
            }
            if (!(vertex5.vec.z > cuboid6.max.z)) continue;
            vertex5.vec.z = cuboid6.max.z;
        }
        return cCModel2.computeNormals();
    }

    public static void addSideFaces(LinkedList<Vertex5> linkedList, Cuboid6 cuboid6, int n) {
        for (int i = 0; i < 6; ++i) {
            if ((n & 1 << i) != 0) continue;
            ModelHelper.addSideFace(linkedList, cuboid6, i);
        }
    }

    public static LinkedList<Vertex5> addSideFace(LinkedList<Vertex5> linkedList, Cuboid6 cuboid6, int n) {
        face.loadCuboidFace(cuboid6.copy().add(Vector3.center), n);
        for (Vertex5 vertex5 : face.getVertices()) {
            linkedList.add(new Vertex5(vertex5.vec.copy().sub(Vector3.center), vertex5.uv.copy()));
        }
        return linkedList;
    }

    public static LinkedList<Vertex5> apply(LinkedList<Vertex5> linkedList, Transformation transformation) {
        LinkedList<Vertex5> linkedList2 = new LinkedList<Vertex5>();
        for (Vertex5 vertex5 : linkedList) {
            linkedList2.add(vertex5.copy().apply(transformation));
        }
        return linkedList2;
    }

    public static LinkedList<Vertex5> simplifyModel(LinkedList<Vertex5> linkedList) {
        Object object;
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        Iterator<Vertex5> iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = Face.loadFromIterator(iterator);
            Iterator iterator2 = linkedList2.iterator();
            while (iterator2.hasNext()) {
                Face face = (Face)iterator2.next();
                if (!((Face)object).attemptToCombine(face)) continue;
                iterator2.remove();
            }
            linkedList2.add(object);
        }
        object = new LinkedList();
        for (Face face : linkedList2) {
            Collections.addAll(object, face.verts);
        }
        return object;
    }

    public static class SideTubeGen {
        public double s;
        public double s2;
        public double h = 1.0;
        public static CCModel[] standardTubes = new SideTubeGen(0.1876).generateModels();
        public static CCModel[] standardTubesInner = new SideTubeGen(0.1876).contract(0.999).generateModels();

        public SideTubeGen(double d) {
            this(d, d + 0.09375);
        }

        public SideTubeGen(double d, double d2) {
            this.s = d;
            this.s2 = d2;
        }

        public SideTubeGen contract(double d) {
            this.h = d;
            return this;
        }

        public Cuboid6 newCube(Vector3 vector3, Vector3 vector32) {
            double d;
            if (vector3.x > vector32.x) {
                d = vector3.x;
                vector3.x = vector32.x;
                vector32.x = d;
            }
            if (vector3.y > vector32.y) {
                d = vector3.y;
                vector3.y = vector32.y;
                vector32.y = d;
            }
            if (vector3.z > vector32.z) {
                d = vector3.z;
                vector3.z = vector32.z;
                vector32.z = d;
            }
            if (this.h < 1.0) {
                Vector3 vector33 = vector3.copy().add(vector32).multiply(0.5);
                vector3.x = vector3.x <= -0.5 || vector3.x >= 0.5 ? vector3.x : (vector3.x - vector33.x) * this.h + vector33.x;
                vector3.y = vector3.y <= -0.5 || vector3.y >= 0.5 ? vector3.y : (vector3.y - vector33.y) * this.h + vector33.y;
                vector3.z = vector3.z <= -0.5 || vector3.z >= 0.5 ? vector3.z : (vector3.z - vector33.z) * this.h + vector33.z;
                vector32.x = vector32.x <= -0.5 || vector32.x >= 0.5 ? vector32.x : (vector32.x - vector33.x) * this.h + vector33.x;
                vector32.y = vector32.y <= -0.5 || vector32.y >= 0.5 ? vector32.y : (vector32.y - vector33.y) * this.h + vector33.y;
                vector32.z = vector32.z <= -0.5 || vector32.z >= 0.5 ? vector32.z : (vector32.z - vector33.z) * this.h + vector33.z;
            }
            return new Cuboid6(vector3, vector32);
        }

        private LinkedList<Vertex5> generateConnections(int n) {
            Cuboid6 cuboid6;
            int n2;
            int n3;
            LinkedList<Vertex5> linkedList = new LinkedList<Vertex5>();
            Vector3 vector3 = axes[n];
            Vector3 vector32 = axes[orthogAxes[n][0]];
            Vector3 vector33 = axes[orthogAxes[n][1]];
            for (n3 = -1; n3 <= 1; n3 += 2) {
                for (n2 = -1; n2 <= 1; n2 += 2) {
                    cuboid6 = this.newCube(vector3.copy().multiply(this.s2).add(vector32.copy().multiply(this.s * (double)n3)).add(vector33.copy().multiply(this.s * (double)n2)), vector3.copy().multiply(this.h / 2.0).add(vector32.copy().multiply(this.s2 * (double)n3)).add(vector33.copy().multiply(this.s2 * (double)n2)));
                    ModelHelper.addSideFaces(linkedList, cuboid6, 1 << n ^ 0x3F);
                }
            }
            for (n3 = 0; n3 < 6; ++n3) {
                if (n == n3 || (n ^ 1) == n3) continue;
                vector3 = axes[n];
                vector32 = axes[n3];
                n2 = orthogonals[n][n3];
                vector33 = axes[n2];
                cuboid6 = this.newCube(vector3.copy().multiply(this.h / 2.0 - (this.s2 - this.s)).add(vector32.copy().multiply(this.s)).add(vector33.copy().multiply(this.s)), vector3.copy().multiply(this.h / 2.0).add(vector32.copy().multiply(this.s2)).add(vector33.copy().multiply(-this.s)));
                ModelHelper.addSideFaces(linkedList, cuboid6, 1 << n2 | 1 << (n2 ^ 1));
            }
            return linkedList;
        }

        private LinkedList<Vertex5> generateIntersections(int n) {
            int n2;
            Cuboid6 cuboid6;
            Vector3 vector3;
            Vector3 vector32;
            Vector3 vector33;
            LinkedList<Vertex5> linkedList = new LinkedList<Vertex5>();
            boolean bl = false;
            for (int i = 0; i < 6; ++i) {
                if ((n & 1 << i) == 0) continue;
                vector33 = axes[i];
                vector32 = axes[orthogAxes[i][0]];
                vector3 = axes[orthogAxes[i][1]];
                for (int j = -1; j <= 1; j += 2) {
                    for (int k = -1; k <= 1; k += 2) {
                        cuboid6 = this.newCube(vector33.copy().multiply(this.s2).add(vector32.copy().multiply(this.s * (double)j)).add(vector3.copy().multiply(this.s * (double)k)), vector33.copy().multiply(this.h / 2.0).add(vector32.copy().multiply(this.s2 * (double)j)).add(vector3.copy().multiply(this.s2 * (double)k)));
                        ModelHelper.addSideFaces(linkedList, cuboid6, 1 << i | 1 << (i ^ 1));
                    }
                }
            }
            for (int[] nArray : edgePairs) {
                if (!bl && (n & 1 << nArray[0]) != 0 != ((n & 1 << nArray[1]) != 0)) continue;
                vector33 = axes[nArray[0]];
                vector32 = axes[nArray[1]];
                n2 = orthogonals[nArray[0]][nArray[1]];
                vector3 = axes[n2];
                cuboid6 = this.newCube(vector33.copy().multiply(this.s).add(vector32.copy().multiply(this.s)).add(vector3.copy().multiply(this.s)), vector33.copy().multiply(this.s2).add(vector32.copy().multiply(this.s2)).add(vector3.copy().multiply(-this.s)));
                ModelHelper.addSideFaces(linkedList, cuboid6, 1 << n2 | 1 << (n2 ^ 1));
            }
            for (int[] nArray : cornerTriplets) {
                vector33 = axes[nArray[0]];
                vector32 = axes[nArray[1]];
                vector3 = axes[nArray[2]];
                cuboid6 = this.newCube(vector33.copy().multiply(this.s).add(vector32.copy().multiply(this.s)).add(vector3.copy().multiply(this.s)), vector33.copy().multiply(this.s2).add(vector32.copy().multiply(this.s2)).add(vector3.copy().multiply(this.s2)));
                n2 = 1 << nArray[0] & n | 1 << nArray[1] & n | 1 << nArray[2] & n;
                if (bl || (n & 1 << nArray[1]) != 0 == ((n & 1 << nArray[2]) != 0)) {
                    n2 |= 1 << (nArray[0] ^ 1);
                }
                if (bl || (n & 1 << nArray[0]) != 0 == ((n & 1 << nArray[2]) != 0)) {
                    n2 |= 1 << (nArray[1] ^ 1);
                }
                if (bl || (n & 1 << nArray[0]) != 0 == ((n & 1 << nArray[1]) != 0)) {
                    n2 |= 1 << (nArray[2] ^ 1);
                }
                ModelHelper.addSideFaces(linkedList, cuboid6, n2);
            }
            return linkedList;
        }

        public CCModel[] generateModels() {
            Vertex5 vertex5;
            int n;
            int n2;
            LinkedList<Vertex5> linkedList;
            int n3;
            CCModel[] cCModelArray = new CCModel[70];
            for (n3 = 0; n3 < 64; ++n3) {
                linkedList = this.generateIntersections(n3);
                linkedList = ModelHelper.simplifyModel(linkedList);
                n2 = linkedList.size();
                cCModelArray[n3] = CCModel.newModel((int)7, (int)(n2 * 2));
                for (n = 0; n < n2; ++n) {
                    cCModelArray[n3].verts[n] = vertex5 = linkedList.get(n);
                }
                CCModel.generateBackface((CCModel)cCModelArray[n3], (int)0, (CCModel)cCModelArray[n3], (int)n2, (int)n2);
                ModelHelper.finalizeModel(cCModelArray[n3]);
            }
            for (n3 = 0; n3 < 6; ++n3) {
                linkedList = this.generateConnections(n3);
                linkedList = ModelHelper.simplifyModel(linkedList);
                n2 = linkedList.size();
                cCModelArray[64 + n3] = CCModel.newModel((int)7, (int)n2);
                for (n = 0; n < n2; ++n) {
                    cCModelArray[64 + n3].verts[n] = vertex5 = linkedList.get(n);
                }
                ModelHelper.finalizeModel(cCModelArray[64 + n3]);
            }
            return cCModelArray;
        }
    }

    public static class OctagonalTubeGen {
        double size;
        double innerSize;
        static final double outerWidth = 0.5;
        boolean frameOnly = false;
        Vector3[] octoFace;

        public OctagonalTubeGen(double d, boolean bl) {
            this(d, d * 0.414, bl);
        }

        public static int getBestSide(Vector3 vector3) {
            int n = 0;
            double d = 0.0;
            for (int i = 2; i < 6; ++i) {
                if (!(Math.abs(vector3.getSide(i)) > d)) continue;
                d = Math.abs(vector3.getSide(i));
                n = i;
            }
            return n;
        }

        public static Vertex5 toVertex5(Vector3 vector3) {
            return OctagonalTubeGen.toVertex5(vector3, OctagonalTubeGen.getBestSide(vector3));
        }

        public static Vertex5 toVertex5(Vector3 vector3, int n) {
            UV uV = n == 0 || n == 1 ? new UV(0.5 + vector3.x, 0.5 + vector3.z) : (n == 2 || n == 3 ? new UV(0.5 + vector3.x, 0.5 + vector3.y) : (n == 4 || n == 5 ? new UV(0.5 + vector3.z, 0.5 + vector3.y) : new UV(0.5, 0.5)));
            return new Vertex5(vector3, uV);
        }

        public OctagonalTubeGen(double d, double d2, boolean bl) {
            this.size = d;
            this.innerSize = d2;
            this.frameOnly = bl;
            this.octoFace = new Vector3[8];
            this.octoFace[0] = new Vector3(-d, -0.5, -d2);
            this.octoFace[1] = new Vector3(-d2, -0.5, -d);
            this.octoFace[2] = new Vector3(d2, -0.5, -d);
            this.octoFace[3] = new Vector3(d, -0.5, -d2);
            this.octoFace[4] = new Vector3(d, -0.5, d2);
            this.octoFace[5] = new Vector3(d2, -0.5, d);
            this.octoFace[6] = new Vector3(-d2, -0.5, d);
            this.octoFace[7] = new Vector3(-d, -0.5, d2);
        }

        public CCModel generateSideFace() {
            CCModel cCModel = CCModel.newModel((int)7, (int)24);
            cCModel.verts[0] = OctagonalTubeGen.toVertex5(this.octoFace[0].copy(), 0);
            cCModel.verts[1] = OctagonalTubeGen.toVertex5(this.octoFace[1].copy(), 0);
            cCModel.verts[2] = OctagonalTubeGen.toVertex5(this.octoFace[2].copy(), 0);
            cCModel.verts[3] = OctagonalTubeGen.toVertex5(this.octoFace[3].copy(), 0);
            cCModel.verts[4] = OctagonalTubeGen.toVertex5(this.octoFace[4].copy(), 0);
            cCModel.verts[5] = OctagonalTubeGen.toVertex5(this.octoFace[5].copy(), 0);
            cCModel.verts[6] = OctagonalTubeGen.toVertex5(this.octoFace[6].copy(), 0);
            cCModel.verts[7] = OctagonalTubeGen.toVertex5(this.octoFace[7].copy(), 0);
            cCModel.verts[8] = OctagonalTubeGen.toVertex5(this.octoFace[0].copy(), 0);
            cCModel.verts[9] = OctagonalTubeGen.toVertex5(this.octoFace[3].copy(), 0);
            cCModel.verts[10] = OctagonalTubeGen.toVertex5(this.octoFace[4].copy(), 0);
            cCModel.verts[11] = OctagonalTubeGen.toVertex5(this.octoFace[7].copy(), 0);
            for (int i = 0; i < 12; ++i) {
                cCModel.verts[i].vec.y = -0.5 * (this.frameOnly ? 0.75 : 0.99);
            }
            CCModel.generateBackface((CCModel)cCModel, (int)0, (CCModel)cCModel, (int)12, (int)12);
            return cCModel;
        }

        public CCModel generateConnection() {
            CCModel cCModel = CCModel.newModel((int)7, (int)64);
            double d = this.size;
            double d2 = 1.01;
            for (int i = 0; i < 8; ++i) {
                cCModel.verts[i * 4] = new Vertex5(this.octoFace[i].copy().multiply(d2, 1.0, d2), 0.5 - this.innerSize, 0.0);
                cCModel.verts[i * 4 + 1] = new Vertex5(this.octoFace[i].copy().multiply(d2, 1.0, d2).setSide(0, -d), 0.5 - this.innerSize, 0.5 - d);
                cCModel.verts[i * 4 + 2] = new Vertex5(this.octoFace[(i + 1) % 8].copy().multiply(d2, 1.0, d2).setSide(0, -d), 0.5 + this.innerSize, 0.5 - d);
                cCModel.verts[i * 4 + 3] = new Vertex5(this.octoFace[(i + 1) % 8].copy().multiply(d2, 1.0, d2), 0.5 + this.innerSize, 0.0);
            }
            CCModel.generateBackface((CCModel)cCModel, (int)0, (CCModel)cCModel, (int)32, (int)32);
            return cCModel;
        }

        public CCModel[] generateModels() {
            int n;
            CCModel[] cCModelArray = new CCModel[76];
            for (n = 0; n < 64; ++n) {
                LinkedList<Vertex5> linkedList = this.generateIntersections(n);
                linkedList = ModelHelper.simplifyModel(linkedList);
                int n2 = linkedList.size();
                cCModelArray[n] = CCModel.newModel((int)7, (int)(n2 * 2));
                for (int i = 0; i < n2; ++i) {
                    Vertex5 vertex5;
                    cCModelArray[n].verts[i] = vertex5 = linkedList.get(i);
                }
                CCModel.generateBackface((CCModel)cCModelArray[n], (int)0, (CCModel)cCModelArray[n], (int)n2, (int)n2);
                ModelHelper.finalizeModel(cCModelArray[n]);
            }
            cCModelArray[64] = this.generateConnection();
            for (n = 0; n < 6; ++n) {
                if (n != 0) {
                    cCModelArray[64 + n] = cCModelArray[64].sidedCopy(0, n, Vector3.zero);
                }
                ModelHelper.finalizeModel(cCModelArray[64 + n]);
            }
            cCModelArray[70] = this.generateSideFace();
            for (n = 0; n < 6; ++n) {
                if (n != 0) {
                    cCModelArray[70 + n] = cCModelArray[70].sidedCopy(0, n, Vector3.zero);
                }
                ModelHelper.finalizeModel(cCModelArray[70 + n]);
            }
            return cCModelArray;
        }

        public LinkedList<Vertex5> generateIntersections(int n) {
            boolean bl;
            int n2;
            int n3;
            int n4;
            LinkedList<Vertex5> linkedList = new LinkedList<Vertex5>();
            LinkedList<Vertex5> linkedList2 = ModelHelper.addSideFace(new LinkedList<Vertex5>(), new Cuboid6(-this.innerSize, -this.size, -this.innerSize, this.innerSize, this.size, this.innerSize), 0);
            LinkedList<Vertex5> linkedList3 = new LinkedList<Vertex5>();
            for (n4 = 0; n4 < 8; ++n4) {
                if (this.frameOnly && n4 % 2 == 0) continue;
                linkedList3.add(OctagonalTubeGen.toVertex5(this.octoFace[n4].copy()));
                linkedList3.add(OctagonalTubeGen.toVertex5(this.octoFace[n4].copy().setSide(0, -this.size)));
                linkedList3.add(OctagonalTubeGen.toVertex5(this.octoFace[(n4 + 1) % 8].copy().setSide(0, -this.size)));
                linkedList3.add(OctagonalTubeGen.toVertex5(this.octoFace[(n4 + 1) % 8].copy()));
            }
            for (n4 = 0; n4 < 6; ++n4) {
                if ((n & 1 << n4) != 0) {
                    linkedList.addAll(ModelHelper.apply(linkedList3, Rotation.sideRotations[n4]));
                    continue;
                }
                linkedList.addAll(ModelHelper.apply(linkedList2, Rotation.sideRotations[n4]));
            }
            for (n4 = 0; n4 < 6; ++n4) {
                for (n3 = n4 + 1; n3 < 6; ++n3) {
                    if ((n4 ^ 1) == n3) continue;
                    n2 = (n & 1 << n4) != 0 ? 1 : 0;
                    bl = (n & 1 << n3) != 0;
                    Vector3 vector3 = axes[n4].copy();
                    Vector3 vector32 = axes[n3].copy();
                    Vector3 vector33 = vector3.copy().crossProduct(vector32);
                    if (n2 == 0 && !bl) {
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.innerSize)).add(vector33.copy().multiply(this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.innerSize)).add(vector33.copy().multiply(-this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.innerSize).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(-this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.innerSize).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(this.innerSize)), n4));
                        continue;
                    }
                    if (n2 == 0 && bl) {
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.innerSize)).add(vector33.copy().multiply(this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.innerSize)).add(vector33.copy().multiply(-this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(-this.innerSize)), n4));
                        linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(this.innerSize)), n4));
                        continue;
                    }
                    if (n2 == 0 || bl) continue;
                    linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(this.innerSize)), n3));
                    linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.size).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(-this.innerSize)), n3));
                    linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.innerSize).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(-this.innerSize)), n3));
                    linkedList.add(OctagonalTubeGen.toVertex5(vector3.copy().multiply(this.innerSize).add(vector32.copy().multiply(this.size)).add(vector33.copy().multiply(this.innerSize)), n3));
                }
            }
            if (!this.frameOnly) {
                for (n4 = 0; n4 < 2; ++n4) {
                    for (n3 = 2; n3 < 4; ++n3) {
                        for (n2 = 4; n2 < 6; ++n2) {
                            Vector3 vector3;
                            int n5;
                            Vector3 vector34;
                            Vector3 vector35;
                            bl = (n & 1 << n4) != 0;
                            boolean bl2 = (n & 1 << n3) != 0;
                            boolean bl3 = (n & 1 << n2) != 0;
                            int n6 = (bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0);
                            Vector3 vector36 = axes[n4];
                            Vector3 vector37 = axes[n3];
                            Vector3 vector38 = axes[n2];
                            if (n6 == 3) {
                                Vector3 vector39 = vector36.copy().multiply(this.size).add(vector37.copy().multiply(this.size).add(vector38.copy().multiply(this.innerSize)));
                                vector35 = vector36.copy().multiply(this.size).add(vector37.copy().multiply(this.innerSize).add(vector38.copy().multiply(this.size)));
                                vector34 = vector36.copy().multiply(this.innerSize).add(vector37.copy().multiply(this.size).add(vector38.copy().multiply(this.size)));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector39, n4));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector34, n4));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector35, n4));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector39, n4));
                                continue;
                            }
                            if (n6 == 0) {
                                Vector3 vector310 = vector36.copy().multiply(this.size).add(vector37.copy().multiply(this.innerSize).add(vector38.copy().multiply(this.innerSize)));
                                vector35 = vector36.copy().multiply(this.innerSize).add(vector37.copy().multiply(this.innerSize).add(vector38.copy().multiply(this.size)));
                                vector34 = vector36.copy().multiply(this.innerSize).add(vector37.copy().multiply(this.size).add(vector38.copy().multiply(this.innerSize)));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector310, 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector34, 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector35, 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector310, 0));
                                continue;
                            }
                            if (n6 == 1) {
                                Vector3 vector311;
                                if (bl) {
                                    vector311 = vector36;
                                    vector35 = vector37;
                                    vector34 = vector38;
                                } else if (bl2) {
                                    vector311 = vector37;
                                    vector35 = vector36;
                                    vector34 = vector38;
                                } else {
                                    vector311 = vector38;
                                    vector35 = vector36;
                                    vector34 = vector37;
                                }
                                linkedList.add(OctagonalTubeGen.toVertex5(vector311.copy().multiply(this.innerSize).add(vector35.copy().multiply(this.size)).add(vector34.copy().multiply(this.innerSize)), 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector311.copy().multiply(this.size).add(vector35.copy().multiply(this.size).add(vector34.copy().multiply(this.innerSize))), 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector311.copy().multiply(this.size).add(vector35.copy().multiply(this.innerSize)).add(vector34.copy().multiply(this.size)), 0));
                                linkedList.add(OctagonalTubeGen.toVertex5(vector311.copy().multiply(this.innerSize).add(vector35.copy().multiply(this.innerSize)).add(vector34.copy().multiply(this.size)), 0));
                                continue;
                            }
                            if (n6 != 2) continue;
                            if (!bl) {
                                n5 = n4;
                                vector35 = vector36;
                                vector34 = vector37;
                                vector3 = vector38;
                            } else if (!bl2) {
                                n5 = n3;
                                vector35 = vector37;
                                vector34 = vector36;
                                vector3 = vector38;
                            } else {
                                n5 = n2;
                                vector35 = vector38;
                                vector34 = vector36;
                                vector3 = vector37;
                            }
                            linkedList.add(OctagonalTubeGen.toVertex5(vector35.copy().multiply(this.size).add(vector34.copy().multiply(this.innerSize)).add(vector3.copy().multiply(this.innerSize)), n5));
                            linkedList.add(OctagonalTubeGen.toVertex5(vector35.copy().multiply(this.size).add(vector34.copy().multiply(this.size)).add(vector3.copy().multiply(this.innerSize)), n5));
                            linkedList.add(OctagonalTubeGen.toVertex5(vector35.copy().multiply(this.innerSize).add(vector34.copy().multiply(this.size)).add(vector3.copy().multiply(this.size)), n5));
                            linkedList.add(OctagonalTubeGen.toVertex5(vector35.copy().multiply(this.size).add(vector34.copy().multiply(this.innerSize)).add(vector3.copy().multiply(this.size)), n5));
                        }
                    }
                }
            }
            return linkedList;
        }
    }

    public static class Face {
        public Vertex5[] verts;

        public static Face loadFromIterator(Iterator<Vertex5> iterator) {
            Face face = new Face(new Vertex5[4]);
            for (int i = 0; i < 4; ++i) {
                face.verts[i] = iterator.next();
            }
            return face;
        }

        public Vertex5 vec(int n) {
            return this.verts[n & 3];
        }

        public void setVec(int n, Vertex5 vertex5) {
            this.verts[n & 3] = vertex5;
        }

        public Face(Vertex5 ... vertex5Array) {
            assert (vertex5Array.length == 4);
            this.verts = vertex5Array;
        }

        public boolean isPolygon() {
            for (int i = 0; i < 4; ++i) {
                if (!this.vec((int)i).vec.equalsT(this.vec((int)(i + 1)).vec)) continue;
                return true;
            }
            return false;
        }

        public Face reverse() {
            this.verts = new Vertex5[]{this.verts[3], this.verts[2], this.verts[1], this.verts[0]};
            return this;
        }

        public boolean attemptToCombine(Face face) {
            if (this.isPolygon() || face.isPolygon()) {
                return false;
            }
            if (this.attemptToCombineUnflipped(face)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(face)) {
                return true;
            }
            this.reverse();
            face.reverse();
            if (this.attemptToCombineUnflipped(face)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(face)) {
                return true;
            }
            this.reverse();
            face.reverse();
            return false;
        }

        public boolean equalVert(Vertex5 vertex5, Vertex5 vertex52) {
            return vertex5.vec.equalsT(vertex52.vec) && vertex5.uv.equals((Object)vertex52.uv);
        }

        public boolean attemptToCombineUnflipped(Face face) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!this.equalVert(this.vec(i), this.vec(j)) || !this.equalVert(this.vec(i + 1), this.vec(j - 1))) continue;
                    Vector3 vector3 = this.vec((int)(i - 1)).vec.copy().subtract(this.vec((int)i).vec).normalize();
                    Vector3 vector32 = this.vec((int)(i + 2)).vec.copy().subtract(this.vec((int)(i + 1)).vec).normalize();
                    Vector3 vector33 = face.vec((int)j).vec.copy().subtract(face.vec((int)(j + 1)).vec).normalize();
                    Vector3 vector34 = face.vec((int)(j - 1)).vec.copy().subtract(face.vec((int)(j - 2)).vec).normalize();
                    if (!vector3.equalsT(vector33) || !vector32.equalsT(vector34)) continue;
                    this.setVec(i, face.vec(j + 1));
                    this.setVec(i + 1, face.vec(j - 2));
                    return true;
                }
            }
            return false;
        }
    }

    public static class StandardTubes {
        public final boolean opaque;
        public final float width;
        static final int[][] orthogs = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {0, 1, 4, 5}, {0, 1, 4, 5}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        Cuboid6 center;
        Cuboid6[] pipeWCenter = new Cuboid6[6];
        Cuboid6[] pipe = new Cuboid6[6];
        Cuboid6[] pipeFullLength = new Cuboid6[6];

        public static Cuboid6[] rotateCuboids(Cuboid6 cuboid6) {
            Cuboid6[] cuboid6Array = new Cuboid6[6];
            for (int i = 0; i < 6; ++i) {
                cuboid6Array[i] = cuboid6.copy().apply(Rotation.sideRotations[i]);
            }
            return cuboid6Array;
        }

        public static CCModel[] genModels(float f, boolean bl) {
            StandardTubes standardTubes = new StandardTubes(f, bl);
            CCModel[] cCModelArray = new CCModel[64];
            for (int i = 0; i < 64; ++i) {
                LinkedList<Vertex5> linkedList = standardTubes.createModel(i);
                int n = linkedList.size();
                cCModelArray[i] = CCModel.newModel((int)7, (int)(n * 2));
                for (int j = 0; j < n; ++j) {
                    cCModelArray[i].verts[j] = linkedList.get(j);
                }
                CCModel.generateBackface((CCModel)cCModelArray[i], (int)0, (CCModel)cCModelArray[i], (int)n, (int)n);
                ModelHelper.finalizeModel(cCModelArray[i]);
            }
            return cCModelArray;
        }

        public StandardTubes(int n) {
            this.width = 0.36f;
            this.opaque = false;
            double d = 0.47 - 0.025 * (double)n;
            double d2 = 0.53 + 0.025 * (double)n;
            double d3 = 0.32 + 0.06 * (double)n;
            double d4 = 0.32;
            double d5 = 0.68;
            double[][] dArrayArray = new double[][]{{d, 0.0, d, d2, d4, d2}, {d, d3, d, d2, 1.0, d2}, {d4, d4, 0.0, d5, d3, d4}, {d4, d4, d5, d5, d3, 1.0}, {0.0, d4, d4, d4, d3, d5}, {d5, d4, d4, 1.0, d3, d5}};
            this.center = new Cuboid6(d4, d4, d4, d5, d3, d5);
            this.pipe = new Cuboid6[6];
            for (int i = 0; i < this.pipe.length; ++i) {
                this.pipe[i] = new Cuboid6(dArrayArray[i][0], dArrayArray[i][1], dArrayArray[i][2], dArrayArray[i][3], dArrayArray[i][4], dArrayArray[i][5]);
            }
        }

        public StandardTubes(float f, boolean bl) {
            this.width = f;
            this.center = new Cuboid6((double)(-f), (double)(-f), (double)(-f), (double)f, (double)f, (double)f);
            this.pipe = StandardTubes.rotateCuboids(new Cuboid6((double)(-f), -0.5, (double)(-f), (double)f, (double)(-f), (double)f));
            this.pipeWCenter = StandardTubes.rotateCuboids(new Cuboid6((double)(-f), -0.5, (double)(-f), (double)f, (double)f, (double)f));
            this.pipeFullLength = StandardTubes.rotateCuboids(new Cuboid6((double)(-f), -0.5, (double)(-f), (double)f, 0.5, (double)f));
            this.opaque = bl;
        }

        public LinkedList<Vertex5> createModel(int n) {
            LinkedList<Vertex5> linkedList = new LinkedList<Vertex5>();
            for (int i = 0; i < 6; ++i) {
                int n2;
                int[] nArray;
                int n32;
                int n42;
                if (!this.opaque && MathHelper.isBitSet((int)n, (int)i)) {
                    for (int n42 : orthogs[i]) {
                        if (!MathHelper.isBitSet((int)n, (int)n42)) continue;
                        ModelHelper.addSideFace(linkedList, this.pipe[n42], i);
                    }
                    continue;
                }
                int n5 = -1;
                int n6 = -1;
                for (int n32 : orthogs[i]) {
                    if (!MathHelper.isBitSet((int)n, (int)n32) || this.pipeWCenter[n32] == null) continue;
                    n5 = n32;
                    if (!MathHelper.isBitSet((int)n, (int)(n32 ^ 1)) || this.pipeFullLength[n32] == null || this.pipeFullLength[n32 ^ 1] == null) continue;
                    n6 = n32;
                    break;
                }
                if (n6 != -1) {
                    nArray = orthogs[i];
                    n42 = nArray.length;
                    for (n2 = 0; n2 < n42; ++n2) {
                        n32 = nArray[n2];
                        if (n32 == n6) {
                            ModelHelper.addSideFace(linkedList, this.pipeFullLength[n32], i);
                            continue;
                        }
                        if (n32 == (n6 ^ 1) || !MathHelper.isBitSet((int)n, (int)n32)) continue;
                        ModelHelper.addSideFace(linkedList, this.pipe[n32], i);
                    }
                    continue;
                }
                if (n5 != -1) {
                    nArray = orthogs[i];
                    n42 = nArray.length;
                    for (n2 = 0; n2 < n42; ++n2) {
                        n32 = nArray[n2];
                        if (n32 == n5) {
                            ModelHelper.addSideFace(linkedList, this.pipeWCenter[n32], i);
                            continue;
                        }
                        if (!MathHelper.isBitSet((int)n, (int)n32)) continue;
                        ModelHelper.addSideFace(linkedList, this.pipe[n32], i);
                    }
                    continue;
                }
                if (!MathHelper.isBitSet((int)n, (int)i)) {
                    ModelHelper.addSideFace(linkedList, this.center, i);
                }
                nArray = orthogs[i];
                n42 = nArray.length;
                for (n2 = 0; n2 < n42; ++n2) {
                    n32 = nArray[n2];
                    if (!MathHelper.isBitSet((int)n, (int)n32)) continue;
                    ModelHelper.addSideFace(linkedList, this.pipe[n32], i);
                }
            }
            return linkedList;
        }
    }
}

