/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.api.tileentity.IRedstoneControl;
import cofh.asm.relauncher.CoFHSide;
import cofh.asm.relauncher.Strippable;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.audio.ISoundSource;
import cofh.lib.audio.SoundTile;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.SoundHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.ISound;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thermalexpansion.block.TileInventory;
import thermalexpansion.network.PacketTEBase;

@Strippable(value={"cofh.api.audio.ISoundSource"}, side=CoFHSide.SERVER)
public abstract class TileRSControl
extends TileInventory
implements IEnergyHandler,
IRedstoneControl,
ISoundSource {
    public boolean isActive;
    protected boolean isPowered;
    protected boolean wasPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;
    protected EnergyStorage energyStorage = new EnergyStorage(0);

    public void onNeighborBlockChange() {
        this.wasPowered = this.isPowered;
        this.isPowered = ((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (this.wasPowered != this.isPowered && this.sendRedstoneUpdates()) {
            PacketTEBase.sendRSPowerUpdatePacketToClients(this, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            this.onRedstoneUpdate();
        }
    }

    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    public boolean hasChargeSlot() {
        return true;
    }

    protected boolean sendRedstoneUpdates() {
        return false;
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    protected void chargeEnergy() {
        int n = this.getChargeSlot();
        if (this.hasChargeSlot() && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[n])) {
            int n2 = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory[n].func_77973_b()).extractEnergy(this.inventory[n], n2, false), false);
            if (this.inventory[n].field_77994_a <= 0) {
                this.inventory[n] = null;
            }
        }
    }

    public void onRedstoneUpdate() {
    }

    public final void setEnergyStored(int n) {
        this.energyStorage.setEnergyStored(n);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getScaledEnergyStored(int n) {
        return this.energyStorage.getEnergyStored() * n / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.isActive = nBTTagCompound.func_74767_n("Active");
        this.energyStorage.readFromNBT(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("RS");
        this.isPowered = nBTTagCompound2.func_74767_n("Power");
        this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound2.func_74771_c("Mode")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Active", this.isActive);
        this.energyStorage.writeToNBT(nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("Power", this.isPowered);
        nBTTagCompound2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nBTTagCompound.func_74782_a("RS", (NBTBase)nBTTagCompound2);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.isPowered);
        packetCoFHBase.addByte(this.rsMode.ordinal());
        packetCoFHBase.addBool(this.isActive);
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.isPowered = packetCoFHBase.getBool();
        this.rsMode = IRedstoneControl.ControlMode.values()[packetCoFHBase.getByte()];
        if (!bl) {
            boolean bl2 = this.isActive;
            this.isActive = packetCoFHBase.getBool();
            this.energyStorage.setEnergyStored(packetCoFHBase.getInt());
            if (this.isActive && !bl2 && this.getSoundName() != null && !this.getSoundName().isEmpty()) {
                SoundHelper.playSound((ISound)this.getSound());
            }
        } else {
            packetCoFHBase.getBool();
            packetCoFHBase.getInt();
        }
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.energyStorage.receiveEnergy(n, bl);
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }

    public final void setPowered(boolean bl) {
        this.wasPowered = this.isPowered;
        this.isPowered = bl;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode controlMode) {
        this.rsMode = controlMode;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundTile((ISoundSource)this, this.getSoundName(), 1.0f, 1.0f, true, 0, (double)((TileEntity)this).field_145851_c, (double)((TileEntity)this).field_145848_d, (double)((TileEntity)this).field_145849_e);
    }

    public String getSoundName() {
        return "";
    }

    public boolean shouldPlaySound() {
        return !((TileEntity)this).field_145846_f && this.isActive;
    }
}

