/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.api.tileentity.ISidedTexture;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.util.ReconfigurableHelper;

public abstract class TileReconfigurable
extends TileRSControl
implements IReconfigurableFacing,
IReconfigurableSides,
ISidedTexture {
    protected byte facing = (byte)3;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        return this.rotateBlock();
    }

    public byte[] getDefaultSides() {
        return new byte[]{0, 0, 0, 0, 0, 0};
    }

    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
    }

    public final boolean hasSide(int n) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.facing = ReconfigurableHelper.getFacingFromNBT(nBTTagCompound);
        this.sideCache = ReconfigurableHelper.getSideCacheFromNBT(nBTTagCompound, this.getDefaultSides());
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Facing", this.facing);
        nBTTagCompound.func_74773_a("SideCache", this.sideCache);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByteArray(this.sideCache);
        packetCoFHBase.addByte(this.facing);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        packetCoFHBase.getByteArray(this.sideCache);
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        if (!bl) {
            this.facing = packetCoFHBase.getByte();
        } else {
            packetCoFHBase.getByte();
        }
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        if (this.allowYAxisFacing()) {
            byte[] byArray = new byte[6];
            switch (this.facing) {
                case 0: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.INVERT_AROUND_X[i]];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_X[i]];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.INVERT_AROUND_Y[i]];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.INVERT_AROUND_Z[i]];
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < 6; ++i) {
                        byArray[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Z[i]];
                    }
                    break;
                }
            }
            this.sideCache = (byte[])byArray.clone();
            this.facing = (byte)(this.facing + 1);
            this.facing = (byte)(this.facing % 6);
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        if (this.isActive) {
            return false;
        }
        byte[] byArray = new byte[6];
        for (int i = 0; i < 6; ++i) {
            byArray[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
        }
        this.sideCache = (byte[])byArray.clone();
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        if (!this.allowYAxisFacing() && n < 2) {
            return false;
        }
        this.facing = (byte)n;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean decrSide(int n) {
        if (n == this.facing) {
            return false;
        }
        int n2 = n;
        this.sideCache[n2] = (byte)(this.sideCache[n2] + (this.getNumConfig(n) - 1));
        int n3 = n;
        this.sideCache[n3] = (byte)(this.sideCache[n3] % this.getNumConfig(n));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean incrSide(int n) {
        if (n == this.facing) {
            return false;
        }
        int n2 = n;
        this.sideCache[n2] = (byte)(this.sideCache[n2] + 1);
        int n3 = n;
        this.sideCache[n3] = (byte)(this.sideCache[n3] % this.getNumConfig(n));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean setSide(int n, int n2) {
        if (n == this.facing || this.sideCache[n] == n2 || n2 >= this.getNumConfig(n)) {
            return false;
        }
        this.sideCache[n] = (byte)n2;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean resetSides() {
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] <= 0) continue;
            this.sideCache[i] = 0;
            bl = true;
        }
        if (bl) {
            this.sendUpdatePacket(Side.SERVER);
        }
        return bl;
    }

    public abstract int getNumConfig(int var1);

    public abstract IIcon getTexture(int var1, int var2);
}

