/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.cell;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.cell.ItemBlockCell;
import thermalexpansion.block.cell.TileCell;
import thermalexpansion.block.cell.TileCellCreative;
import thermalexpansion.block.simple.BlockFrame;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.ReconfigurableHelper;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.TECraftingHandler;
import thermalfoundation.item.TFItems;

public class BlockCell
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 5.0f, 15.0f, 20.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static final String TEXTURE_DEFAULT = "CellConfig_";
    public static final String TEXTURE_CB = "CellConfig_CB_";
    public static String textureSelection;
    public static ItemStack cellCreative;
    public static ItemStack cellBasic;
    public static ItemStack cellHardened;
    public static ItemStack cellReinforced;
    public static ItemStack cellResonant;

    public BlockCell() {
        super(Material.field_151573_f);
        this.func_149711_c(20.0f);
        this.func_149752_b(120.0f);
        this.func_149663_c("thermalexpansion.cell");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        if (n == Types.CREATIVE.ordinal()) {
            if (!enable[Types.CREATIVE.ordinal()]) {
                return null;
            }
            return new TileCellCreative(n);
        }
        return new TileCell(n);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            if (i != Types.CREATIVE.ordinal()) {
                list.add(ItemBlockCell.setDefaultTag(new ItemStack(item, 1, i), 0));
            }
            list.add(ItemBlockCell.setDefaultTag(new ItemStack(item, 1, i), TileCell.STORAGE[i]));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (!enable[world.func_72805_g(n, n2, n3)]) {
            world.func_147468_f(n, n2, n3);
            return;
        }
        if (itemStack.field_77990_d != null) {
            TileCell tileCell = (TileCell)world.func_147438_o(n, n2, n3);
            tileCell.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            tileCell.energySend = itemStack.field_77990_d.func_74762_e("Send");
            tileCell.energyReceive = itemStack.field_77990_d.func_74762_e("Recv");
            int n4 = BlockHelper.determineXZPlaceFacing((EntityLivingBase)entityLivingBase);
            byte by = ReconfigurableHelper.getFacing(itemStack);
            byte[] byArray = ReconfigurableHelper.getSideCache(itemStack, tileCell.getDefaultSides());
            tileCell.sideCache[0] = byArray[0];
            tileCell.sideCache[1] = byArray[1];
            tileCell.sideCache[n4] = byArray[by];
            tileCell.sideCache[BlockHelper.getLeftSide((int)n4)] = byArray[BlockHelper.getLeftSide((int)by)];
            tileCell.sideCache[BlockHelper.getRightSide((int)n4)] = byArray[BlockHelper.getRightSide((int)by)];
            tileCell.sideCache[BlockHelper.getOppositeSide((int)n4)] = byArray[BlockHelper.getOppositeSide((int)by)];
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return TEProps.renderIdCell;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        return IconRegistry.getIcon((String)("Cell" + 2 * n2));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        for (int i = 0; i < 9; ++i) {
            IconRegistry.addIcon((String)("CellMeter" + i), (String)("thermalexpansion:cell/Cell_Meter_" + i), (IIconRegister)iIconRegister);
        }
        IconRegistry.addIcon((String)"CellMeterCreative", (String)"thermalexpansion:cell/Cell_Meter_Creative", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell0", (String)"thermalexpansion:cell/Cell_Creative", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell1", (String)"thermalexpansion:cell/Cell_Creative_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell2", (String)"thermalexpansion:cell/Cell_Basic", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell3", (String)"thermalexpansion:cell/Cell_Basic_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell4", (String)"thermalexpansion:cell/Cell_Hardened", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell5", (String)"thermalexpansion:cell/Cell_Hardened_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell6", (String)"thermalexpansion:cell/Cell_Reinforced", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell7", (String)"thermalexpansion:cell/Cell_Reinforced_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell8", (String)"thermalexpansion:cell/Cell_Resonant", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Cell9", (String)"thermalexpansion:cell/Cell_Resonant_Inner", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_0", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_1", (String)"thermalexpansion:cell/Cell_Config_Orange", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_2", (String)"thermalexpansion:cell/Cell_Config_Blue", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_CB_0", (String)"thermalexpansion:config/Config_None", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_CB_1", (String)"thermalexpansion:cell/Cell_Config_Orange_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"CellConfig_CB_2", (String)"thermalexpansion:cell/Cell_Config_Blue_CB", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"StorageRedstone", (String)"thermalexpansion:cell/Cell_Center_Solid", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileCell tileCell = (TileCell)world.func_147438_o(n, n2, n3);
        if (tileCell != null) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileCell);
            nBTTagCompound.func_74768_a("Energy", tileCell.getEnergyStored(ForgeDirection.UNKNOWN));
            nBTTagCompound.func_74768_a("Send", tileCell.energySend);
            nBTTagCompound.func_74768_a("Recv", tileCell.energyReceive);
        }
        return nBTTagCompound;
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (world.func_72805_g(n, n2, n3) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)entityPlayer)) {
            return false;
        }
        return super.canDismantle(entityPlayer, world, n, n2, n3);
    }

    public boolean initialize() {
        TileCell.initialize();
        TileCellCreative.initialize();
        cellCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        cellBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        cellHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        cellReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        cellResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        ItemBlockCell.setDefaultTag(cellCreative, 0);
        ItemBlockCell.setDefaultTag(cellBasic, 0);
        ItemBlockCell.setDefaultTag(cellHardened, 0);
        ItemBlockCell.setDefaultTag(cellReinforced, 0);
        ItemBlockCell.setDefaultTag(cellResonant, 0);
        GameRegistry.registerCustomItemStack((String)"cellCreative", (ItemStack)cellCreative);
        GameRegistry.registerCustomItemStack((String)"cellBasic", (ItemStack)cellBasic);
        GameRegistry.registerCustomItemStack((String)"cellHardened", (ItemStack)cellHardened);
        GameRegistry.registerCustomItemStack((String)"cellReinforced", (ItemStack)cellReinforced);
        GameRegistry.registerCustomItemStack((String)"cellResonant", (ItemStack)cellResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellBasic, new Object[]{" I ", "IXI", " P ", Character.valueOf('I'), "ingotCopper", Character.valueOf('X'), BlockFrame.frameCellBasic, Character.valueOf('P'), TEItems.powerCoilElectrum}));
            PulverizerManager.addRecipe(4000, cellBasic, ItemHelper.cloneStack((Item)Items.field_151137_ax, (int)8), ItemHelper.cloneStack((ItemStack)TFItems.ingotLead, (int)3));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(cellHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), cellBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellHardened, new Object[]{"IYI", "YXY", "IPI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), BlockFrame.frameCellBasic, Character.valueOf('Y'), "ingotCopper", Character.valueOf('P'), TEItems.powerCoilElectrum}));
            PulverizerManager.addRecipe(4000, cellHardened, ItemHelper.cloneStack((Item)Items.field_151137_ax, (int)8), ItemHelper.cloneStack((ItemStack)TFItems.ingotInvar, (int)3));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellReinforced, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), BlockFrame.frameCellReinforcedFull, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), TEItems.powerCoilElectrum, Character.valueOf('X'), "ingotElectrum", Character.valueOf('Y'), "ingotElectrum"}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(cellResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), cellReinforced}));
        }
        TECraftingHandler.addSecureRecipe(cellCreative);
        TECraftingHandler.addSecureRecipe(cellBasic);
        TECraftingHandler.addSecureRecipe(cellHardened);
        TECraftingHandler.addSecureRecipe(cellReinforced);
        TECraftingHandler.addSecureRecipe(cellResonant);
        return true;
    }

    static {
        String string = "block.feature";
        BlockCell.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(string, "Cell.Creative", true);
        BlockCell.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(string, "Cell.Basic", true);
        BlockCell.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(string, "Cell.Hardened", true);
        BlockCell.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(string, "Cell.Reinforced", true);
        BlockCell.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(string, "Cell.Resonant", true);
        textureSelection = TEXTURE_DEFAULT;
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

