/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.ender;

import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.api.transport.IEnderAttuned;
import cofh.api.transport.IEnderEnergyHandler;
import cofh.api.transport.IEnderFluidHandler;
import cofh.api.transport.IEnderItemHandler;
import cofh.api.transport.RegistryEnderAttuned;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.ender.GuiTesseract;
import thermalexpansion.gui.container.ender.ContainerTesseract;
import thermalexpansion.util.Utils;

public class TileTesseract
extends TileRSControl
implements ITileInfoPacketHandler,
IEnderEnergyHandler,
IEnderFluidHandler,
IEnderItemHandler,
IFluidHandler,
ISidedInventory {
    protected static final int[] SLOTS = new int[]{0};
    private boolean isSendingEnergy = false;
    private boolean isSendingFluid = false;
    private boolean isSendingItems = false;
    int itemTrackerAdjacent;
    int itemTrackerRemote;
    int fluidTrackerAdjacent;
    int fluidTrackerRemote;
    int energyTrackerAdjacent;
    int energyTrackerRemote;
    boolean cached = false;
    IEnergyHandler[] adjacentEnergyHandlers = new IEnergyHandler[6];
    IFluidHandler[] adjacentFluidHandlers = new IFluidHandler[6];
    public int frequency = -1;
    public byte modeItem = (byte)TransferMode.RECV.ordinal();
    public byte modeFluid = (byte)TransferMode.RECV.ordinal();
    public byte modeEnergy = (byte)TransferMode.RECV.ordinal();

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTesseract.class, (String)"thermalexpansion.Tesseract");
    }

    public TileTesseract() {
        this.inventory = new ItemStack[1];
    }

    public String getName() {
        return "tile.thermalexpansion.ender.tesseract.name";
    }

    public int getType() {
        return 0;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public void blockBroken() {
        this.removeFromRegistry();
    }

    public void onChunkUnload() {
        this.removeFromRegistry();
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.updateAdjacentHandler(n, n2, n3);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.blockBroken();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.frequency != -1) {
            this.addToRegistry();
        }
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        if (this.timeCheck() && this.inventory[0] != null) {
            this.sendItem(this.inventory[0]);
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
                this.callNeighborTileChange();
            }
        }
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            if (tileEntity instanceof TileTesseract) continue;
            this.adjacentFluidHandlers[i] = FluidHelper.isFluidHandler((TileEntity)tileEntity) ? (IFluidHandler)tileEntity : null;
            this.adjacentEnergyHandlers[i] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tileEntity, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? (IEnergyHandler)tileEntity : null;
        }
        this.cached = true;
    }

    protected void updateAdjacentHandler(int n, int n2, int n3) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        int n4 = BlockHelper.determineAdjacentSide((TileEntity)this, (int)n, (int)n2, (int)n3);
        TileEntity tileEntity = ((TileEntity)this).field_145850_b.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileTesseract) {
            return;
        }
        this.adjacentFluidHandlers[n4] = FluidHelper.isFluidHandler((TileEntity)tileEntity) ? (IFluidHandler)tileEntity : null;
        this.adjacentEnergyHandlers[n4] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tileEntity, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[n4 ^ 1]) ? (IEnergyHandler)tileEntity : null;
    }

    public boolean isOwner(String string) {
        return string == null ? false : string.equals(this.owner);
    }

    public void addEntry(int n, String string) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.ALTER_NAME_LIST.ordinal()).addBool(false).addString(this.access.isPublic() ? "_public_" : this.owner.toLowerCase()).addString(String.valueOf(n)).addString(string));
        }
    }

    public void removeEntry(int n, String string) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.ALTER_NAME_LIST.ordinal()).addBool(true).addString(this.access.isPublic() ? "_public_" : this.owner.toLowerCase()).addString(String.valueOf(n)).addString(string));
        }
    }

    public void addToRegistry() {
        RegistryEnderAttuned.add((IEnderAttuned)this);
    }

    public void removeFromRegistry() {
        RegistryEnderAttuned.remove((IEnderAttuned)this);
    }

    public void setTileInfo(int n) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            this.frequency = n;
            PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.TILE_INFO.ordinal()).addByte(this.modeItem).addByte(this.modeFluid).addByte(this.modeEnergy).addByte(this.access.ordinal()).addInt(n));
        }
    }

    int sendEnergy(int n, boolean bl) {
        List list = RegistryEnderAttuned.getLinkedEnergyOutputs((IEnderEnergyHandler)this);
        int n2 = n;
        if (n2 <= 0) {
            return 0;
        }
        if (list != null) {
            IEnderEnergyHandler iEnderEnergyHandler;
            int n3;
            this.isSendingEnergy = true;
            for (n3 = this.energyTrackerRemote; n3 < list.size() && n > 0; ++n3) {
                iEnderEnergyHandler = (IEnderEnergyHandler)list.get(n3);
                if (!iEnderEnergyHandler.canReceiveEnergy()) continue;
                n = iEnderEnergyHandler.receiveEnergy(n, bl);
            }
            for (n3 = 0; n3 < list.size() && n3 < this.energyTrackerRemote && n > 0; ++n3) {
                iEnderEnergyHandler = (IEnderEnergyHandler)list.get(n3);
                if (!iEnderEnergyHandler.canReceiveEnergy()) continue;
                n = iEnderEnergyHandler.receiveEnergy(n, bl);
            }
            this.energyTrackerRemote = this.incrRemoteTracker(this.energyTrackerRemote, list.size());
        }
        this.isSendingEnergy = false;
        return n2 - n;
    }

    int sendFluid(FluidStack fluidStack, boolean bl) {
        List list = RegistryEnderAttuned.getLinkedFluidOutputs((IEnderFluidHandler)this);
        int n = fluidStack.amount;
        if (n <= 0) {
            return 0;
        }
        if (list != null) {
            IEnderFluidHandler iEnderFluidHandler;
            int n2;
            this.isSendingFluid = true;
            for (n2 = this.fluidTrackerRemote; n2 < list.size() && fluidStack != null && fluidStack.amount > 0; ++n2) {
                iEnderFluidHandler = (IEnderFluidHandler)list.get(n2);
                if (!iEnderFluidHandler.canReceiveFluid()) continue;
                fluidStack = iEnderFluidHandler.receiveFluid(fluidStack, bl);
            }
            for (n2 = 0; n2 < list.size() && n2 < this.fluidTrackerRemote && fluidStack != null && fluidStack.amount > 0; ++n2) {
                iEnderFluidHandler = (IEnderFluidHandler)list.get(n2);
                if (!iEnderFluidHandler.canReceiveFluid()) continue;
                fluidStack = iEnderFluidHandler.receiveFluid(fluidStack, bl);
            }
            this.fluidTrackerRemote = this.incrRemoteTracker(this.fluidTrackerRemote, list.size());
        }
        this.isSendingFluid = false;
        return n - fluidStack.amount;
    }

    void sendItem(ItemStack itemStack) {
        List list = RegistryEnderAttuned.getLinkedItemOutputs((IEnderItemHandler)this);
        if (list != null) {
            IEnderItemHandler iEnderItemHandler;
            int n;
            this.isSendingItems = true;
            for (n = this.itemTrackerRemote; n < list.size() && itemStack != null && itemStack.field_77994_a > 0; ++n) {
                iEnderItemHandler = (IEnderItemHandler)list.get(n);
                if (!iEnderItemHandler.canReceiveItems()) continue;
                itemStack = iEnderItemHandler.receiveItem(itemStack);
            }
            for (n = 0; n < list.size() && n < this.itemTrackerRemote && itemStack != null && itemStack.field_77994_a > 0; ++n) {
                iEnderItemHandler = (IEnderItemHandler)list.get(n);
                if (!iEnderItemHandler.canReceiveItems()) continue;
                itemStack = iEnderItemHandler.receiveItem(itemStack);
            }
            this.itemTrackerRemote = this.incrRemoteTracker(this.itemTrackerRemote, list.size());
        }
        if (itemStack != null && itemStack.field_77994_a > 0) {
            this.inventory[0] = itemStack;
            ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
        }
        this.isSendingItems = false;
    }

    public void incrEnergyTrackerAdjacent() {
        int n;
        ++this.energyTrackerAdjacent;
        for (n = this.energyTrackerAdjacent; n < 6; ++n) {
            if (this.adjacentEnergyHandlers[n] == null) continue;
            this.energyTrackerAdjacent = n;
            return;
        }
        this.energyTrackerAdjacent %= 6;
        for (n = 0; n < this.energyTrackerAdjacent; ++n) {
            if (this.adjacentEnergyHandlers[n] == null) continue;
            this.energyTrackerAdjacent = n;
            return;
        }
        this.energyTrackerAdjacent = 0;
    }

    public void incrFluidTrackerAdjacent() {
        int n;
        ++this.fluidTrackerAdjacent;
        for (n = this.fluidTrackerAdjacent; n < 6; ++n) {
            if (this.adjacentFluidHandlers[n] == null) continue;
            this.fluidTrackerAdjacent = n;
            return;
        }
        this.fluidTrackerAdjacent %= 6;
        for (n = 0; n < this.fluidTrackerAdjacent; ++n) {
            if (this.adjacentFluidHandlers[n] == null) continue;
            this.fluidTrackerAdjacent = n;
            return;
        }
        this.fluidTrackerAdjacent = 0;
    }

    public void incrItemTrackerAdjacent() {
        int n;
        ++this.itemTrackerAdjacent;
        for (n = this.itemTrackerAdjacent; n < 6; ++n) {
            if (!Utils.isAdjacentInventory((TileEntity)this, n)) continue;
            this.itemTrackerAdjacent = n;
            return;
        }
        this.itemTrackerAdjacent %= 6;
        for (n = 0; n < this.itemTrackerAdjacent; ++n) {
            if (!Utils.isAdjacentInventory((TileEntity)this, n)) continue;
            this.itemTrackerAdjacent = n;
            return;
        }
        this.itemTrackerAdjacent = 0;
    }

    public int incrRemoteTracker(int n, int n2) {
        if (++n >= n2) {
            n = 0;
        }
        return n;
    }

    public int addToAdjInventory(TileEntity tileEntity, int n, ItemStack itemStack) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity((TileEntity)tileEntity, (int)n);
        if (tileEntity2 instanceof TileTesseract) {
            return itemStack.field_77994_a;
        }
        return Utils.addToAdjacentInventory((TileEntity)this, n, itemStack);
    }

    public boolean isAdjacentInventory(int n) {
        TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((World)((TileEntity)this).field_145850_b, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)n);
        return tileEntity instanceof TileTesseract ? false : Utils.isInventory(tileEntity, n);
    }

    public boolean modeSendEnergy() {
        return this.modeEnergy == TransferMode.SEND.ordinal() || this.modeEnergy == TransferMode.SENDRECV.ordinal();
    }

    public boolean modeReceiveEnergy() {
        return this.modeEnergy == TransferMode.RECV.ordinal() || this.modeEnergy == TransferMode.SENDRECV.ordinal();
    }

    public boolean modeSendFluid() {
        return this.modeFluid == TransferMode.SEND.ordinal() || this.modeFluid == TransferMode.SENDRECV.ordinal();
    }

    public boolean modeReceiveFluid() {
        return this.modeFluid == TransferMode.RECV.ordinal() || this.modeFluid == TransferMode.SENDRECV.ordinal();
    }

    public boolean modeSendItems() {
        return this.modeItem == TransferMode.SEND.ordinal() || this.modeItem == TransferMode.SENDRECV.ordinal();
    }

    public boolean modeReceiveItems() {
        return this.modeItem == TransferMode.RECV.ordinal() || this.modeItem == TransferMode.SENDRECV.ordinal();
    }

    public void incEnergyMode() {
        this.modeEnergy = (byte)(this.modeEnergy + 1);
        if (this.modeEnergy > 3) {
            this.modeEnergy = 0;
        }
    }

    public void decEnergyMode() {
        this.modeEnergy = (byte)(this.modeEnergy - 1);
        if (this.modeEnergy < 0) {
            this.modeEnergy = (byte)3;
        }
    }

    public void incFluidMode() {
        this.modeFluid = (byte)(this.modeFluid + 1);
        if (this.modeFluid > 3) {
            this.modeFluid = 0;
        }
    }

    public void decFluidMode() {
        this.modeFluid = (byte)(this.modeFluid - 1);
        if (this.modeFluid < 0) {
            this.modeFluid = (byte)3;
        }
    }

    public void incItemMode() {
        this.modeItem = (byte)(this.modeItem + 1);
        if (this.modeItem > 3) {
            this.modeItem = 0;
        }
    }

    public void decItemMode() {
        this.modeItem = (byte)(this.modeItem - 1);
        if (this.modeItem < 0) {
            this.modeItem = (byte)3;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTesseract(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTesseract(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (CoreUtils.isFakePlayer((EntityPlayer)entityPlayer)) {
            return true;
        }
        if (this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
                this.sendNamesList((EntityPlayerMP)entityPlayer);
            }
            entityPlayer.openGui((Object)ThermalExpansion.instance, 0, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            return true;
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)"chat.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"chat.cofh.secure2")));
        }
        return true;
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.canPlayerAccess(((EntityPlayer)iCrafting).func_70005_c_()) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.modeItem = nBTTagCompound.func_74771_c("Item.Mode");
        this.modeFluid = nBTTagCompound.func_74771_c("Fluid.Mode");
        this.modeEnergy = nBTTagCompound.func_74771_c("Energy.Mode");
        this.itemTrackerAdjacent = nBTTagCompound.func_74762_e("Item.Adj");
        this.itemTrackerRemote = nBTTagCompound.func_74762_e("Item.Rem");
        this.fluidTrackerAdjacent = nBTTagCompound.func_74762_e("Fluid.Adj");
        this.fluidTrackerRemote = nBTTagCompound.func_74762_e("Fluid.Rem");
        this.energyTrackerAdjacent = nBTTagCompound.func_74762_e("Energy.Adj");
        this.energyTrackerRemote = nBTTagCompound.func_74762_e("Energy.Rem");
        this.frequency = nBTTagCompound.func_74762_e("Frequency");
        this.addToRegistry();
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Item.Mode", this.modeItem);
        nBTTagCompound.func_74774_a("Fluid.Mode", this.modeFluid);
        nBTTagCompound.func_74774_a("Energy.Mode", this.modeEnergy);
        nBTTagCompound.func_74768_a("Item.Adj", this.itemTrackerAdjacent);
        nBTTagCompound.func_74768_a("Item.Rem", this.itemTrackerRemote);
        nBTTagCompound.func_74768_a("Fluid.Adj", this.fluidTrackerAdjacent);
        nBTTagCompound.func_74768_a("Fluid.Rem", this.fluidTrackerRemote);
        nBTTagCompound.func_74768_a("Energy.Adj", this.energyTrackerAdjacent);
        nBTTagCompound.func_74768_a("Energy.Rem", this.energyTrackerRemote);
        nBTTagCompound.func_74768_a("Frequency", this.frequency);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.modeEnergy);
        packetCoFHBase.addByte(this.modeFluid);
        packetCoFHBase.addByte(this.modeItem);
        packetCoFHBase.addInt(this.frequency);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.modeEnergy = packetCoFHBase.getByte();
        this.modeFluid = packetCoFHBase.getByte();
        this.modeItem = packetCoFHBase.getByte();
        this.frequency = packetCoFHBase.getInt();
        this.isActive = this.frequency != -1;
    }

    @Override
    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        switch (PacketInfoID.values()[packetCoFHBase.getByte()]) {
            case NAME_LIST: {
                RegistryEnderAttuned.clearClientNames();
                int n = packetCoFHBase.getInt();
                for (int i = 0; i < n; ++i) {
                    RegistryEnderAttuned.addClientNames((String)packetCoFHBase.getString(), (String)packetCoFHBase.getString());
                }
                ThermalExpansion.proxy.updateTesseractGui();
                return;
            }
            case ALTER_NAME_LIST: {
                if (packetCoFHBase.getBool()) {
                    RegistryEnderAttuned.linkConf.getCategory(packetCoFHBase.getString()).remove((Object)packetCoFHBase.getString());
                } else {
                    RegistryEnderAttuned.linkConf.get(packetCoFHBase.getString(), packetCoFHBase.getString(), "").set(packetCoFHBase.getString());
                }
                this.sendNamesList((EntityPlayerMP)entityPlayer);
                RegistryEnderAttuned.linkConf.save();
                return;
            }
            case TILE_INFO: {
                this.removeFromRegistry();
                this.modeItem = packetCoFHBase.getByte();
                this.modeFluid = packetCoFHBase.getByte();
                this.modeEnergy = packetCoFHBase.getByte();
                this.access = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
                this.frequency = packetCoFHBase.getInt();
                this.addToRegistry();
                this.isActive = this.frequency != -1;
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
                this.callNeighborTileChange();
                this.sendNamesList((EntityPlayerMP)entityPlayer);
                return;
            }
        }
    }

    public void sendNamesList(EntityPlayerMP entityPlayerMP) {
        String string = this.access.isPublic() ? "_Public_" : this.owner;
        ConfigCategory configCategory = RegistryEnderAttuned.linkConf.getCategory(string.toLowerCase());
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        if (configCategory != null) {
            packetTileInfo.addByte((byte)PacketInfoID.NAME_LIST.ordinal());
            packetTileInfo.addInt(configCategory.size());
            for (Property property : configCategory.values()) {
                packetTileInfo.addString(property.getName());
                packetTileInfo.addString(property.getString());
            }
        } else {
            packetTileInfo.addByte((byte)PacketInfoID.NAME_LIST.ordinal());
            packetTileInfo.addInt(0);
        }
        PacketHandler.sendTo((PacketBase)packetTileInfo, (EntityPlayerMP)entityPlayerMP);
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ItemStack func_70301_a(int n) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        return null;
    }

    @Override
    public ItemStack func_70304_b(int n) {
        return null;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this.sendItem(itemStack);
    }

    public String getChannelString() {
        return this.access.isPublic() ? "_public_" : this.owner;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean setFrequency(int n) {
        if (!this.access.isPublic() || n > 999 || n < 0) {
            return false;
        }
        this.removeFromRegistry();
        this.frequency = n;
        this.addToRegistry();
        this.isActive = true;
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        this.func_70296_d();
        return true;
    }

    public boolean clearFrequency() {
        if (!this.access.isPublic()) {
            return false;
        }
        this.removeFromRegistry();
        this.frequency = -1;
        this.addToRegistry();
        this.isActive = false;
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        this.func_70296_d();
        return true;
    }

    public boolean canSendEnergy() {
        return this.modeSendEnergy();
    }

    public boolean canReceiveEnergy() {
        return !this.isSendingEnergy && this.modeReceiveEnergy();
    }

    public int receiveEnergy(int n, boolean bl) {
        int n2;
        if (!this.redstoneControlOrDisable()) {
            return n;
        }
        for (n2 = this.energyTrackerAdjacent; n2 < 6 && n > 0; ++n2) {
            if (this.adjacentEnergyHandlers[n2] == null) continue;
            n -= this.adjacentEnergyHandlers[n2].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n2 ^ 1], n, bl);
        }
        for (n2 = 0; n2 < this.energyTrackerAdjacent && n2 < 6 && n > 0; ++n2) {
            if (this.adjacentEnergyHandlers[n2] == null) continue;
            n -= this.adjacentEnergyHandlers[n2].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n2 ^ 1], n, bl);
        }
        this.incrEnergyTrackerAdjacent();
        return n;
    }

    public boolean canSendFluid() {
        return this.modeSendFluid();
    }

    public boolean canReceiveFluid() {
        return !this.isSendingFluid && this.modeReceiveFluid();
    }

    public FluidStack receiveFluid(FluidStack fluidStack, boolean bl) {
        int n;
        if (!this.redstoneControlOrDisable()) {
            return fluidStack;
        }
        for (n = this.fluidTrackerAdjacent; n < 6 && fluidStack.amount > 0; ++n) {
            if (this.adjacentFluidHandlers[n] == null) continue;
            fluidStack.amount -= this.adjacentFluidHandlers[n].fill(ForgeDirection.VALID_DIRECTIONS[n ^ 1], fluidStack, bl);
        }
        for (n = 0; n < this.fluidTrackerAdjacent && n < 6 && fluidStack.amount > 0; ++n) {
            if (this.adjacentFluidHandlers[n] == null) continue;
            fluidStack.amount -= this.adjacentFluidHandlers[n].fill(ForgeDirection.VALID_DIRECTIONS[n ^ 1], fluidStack, bl);
        }
        this.incrFluidTrackerAdjacent();
        return fluidStack;
    }

    public boolean canSendItems() {
        return this.modeSendItems();
    }

    public boolean canReceiveItems() {
        return !this.isSendingItems && this.modeReceiveItems();
    }

    public ItemStack receiveItem(ItemStack itemStack) {
        int n;
        if (!this.redstoneControlOrDisable()) {
            return itemStack;
        }
        for (n = this.itemTrackerAdjacent; n < 6 && itemStack != null && itemStack.field_77994_a > 0; ++n) {
            if (!this.isAdjacentInventory(n)) continue;
            itemStack.field_77994_a = this.addToAdjInventory((TileEntity)this, n, itemStack.func_77946_l());
        }
        for (n = 0; n < this.itemTrackerAdjacent && itemStack != null && itemStack.field_77994_a > 0; ++n) {
            if (!this.isAdjacentInventory(n)) continue;
            itemStack.field_77994_a = this.addToAdjInventory((TileEntity)this, n, itemStack.func_77946_l());
        }
        this.incrItemTrackerAdjacent();
        return itemStack;
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.frequency == -1 || !this.redstoneControlOrDisable() || !this.canSendEnergy() || ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return 0;
        }
        return this.sendEnergy(n, bl);
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.frequency == -1 || !this.redstoneControlOrDisable() || !this.canSendFluid() || ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b) || fluidStack == null) {
            return 0;
        }
        return this.sendFluid(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return TEProps.EMPTY_TANK_INFO;
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        RedstoneControlHelper.getControlFromNBT((NBTTagCompound)nBTTagCompound);
        this.frequency = nBTTagCompound.func_74762_e("Frequency");
        this.modeItem = nBTTagCompound.func_74771_c("ModeItems");
        this.modeFluid = nBTTagCompound.func_74771_c("ModeFluid");
        this.modeEnergy = nBTTagCompound.func_74771_c("ModeEnergy");
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)nBTTagCompound, (IRedstoneControl)this);
        nBTTagCompound.func_74768_a("Frequency", this.frequency);
        nBTTagCompound.func_74774_a("ModeItems", this.modeItem);
        nBTTagCompound.func_74774_a("ModeFluid", this.modeFluid);
        nBTTagCompound.func_74774_a("ModeEnergy", this.modeEnergy);
    }

    @Override
    public boolean setAccess(ISecurable.AccessMode accessMode) {
        this.access = accessMode;
        this.sendUpdatePacket(Side.SERVER);
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            this.setTileInfo(-1);
        }
        return true;
    }

    public void setAccessQuick(ISecurable.AccessMode accessMode) {
        this.access = accessMode;
    }

    public int[] func_94128_d(int n) {
        return SLOTS;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.frequency != -1 && this.redstoneControlOrDisable() && this.canSendItems() && this.inventory[0] == null;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public static enum TransferMode {
        SEND,
        RECV,
        SENDRECV,
        BLOCKED;

    }

    public static enum PacketInfoID {
        NAME_LIST,
        ALTER_NAME_LIST,
        TILE_INFO;

    }
}

