/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.light;

import cofh.api.tileentity.ITileInfo;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thermalexpansion.block.TileTEBase;

public class TileLight
extends TileTEBase
implements ITilePacketHandler,
ITileInfo {
    public boolean modified;
    byte mode;
    int lightValue;
    int color = 0xFFFFFF;
    int renderColor = -1431655681;
    public boolean isPowered;
    public byte inputPower;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileLight.class, (String)"thermalexpansion.Light");
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.light.name";
    }

    public int getType() {
        return 0;
    }

    public int getLightValue() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return this.lightValue;
        }
        switch (this.mode) {
            case 0: {
                return this.isPowered ? 15 : 0;
            }
            case 1: {
                return this.isPowered ? 0 : 15;
            }
            case 2: {
                return this.inputPower;
            }
            case 3: {
                return 15 - this.inputPower;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public void onNeighborBlockChange() {
        boolean bl = this.isPowered;
        byte by = this.inputPower;
        this.isPowered = ((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        this.inputPower = (byte)((TileEntity)this).field_145850_b.func_94577_B(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (bl != this.isPowered || by != this.inputPower) {
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 6);
        this.sendUpdatePacket(Side.CLIENT);
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)("chat.thermalexpansion.light." + this.mode))));
        return true;
    }

    public int getColorMultiplier() {
        return this.renderColor;
    }

    public boolean resetColor() {
        if (!this.modified) {
            return false;
        }
        this.modified = false;
        this.color = 0xFFFFFF;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setColor(int n) {
        this.modified = true;
        this.color = n;
        this.setRenderColor();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setRenderColor() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            return false;
        }
        int n = 10 + this.getLightValue() / 3;
        int n2 = (this.color >> 16 & 0xFF) * n / 15;
        int n3 = (this.color >> 8 & 0xFF) * n / 15;
        int n4 = (this.color & 0xFF) * n / 15;
        this.renderColor = (n2 << 24) + (n3 << 16) + (n4 << 8) + 255;
        return true;
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.modified);
        packetCoFHBase.addInt(this.color);
        packetCoFHBase.addByte(this.mode);
        packetCoFHBase.addByte(this.getLightValue());
        packetCoFHBase.addBool(this.isPowered);
        packetCoFHBase.addByte(this.inputPower);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.modified = packetCoFHBase.getBool();
        this.color = packetCoFHBase.getInt();
        if (!bl) {
            this.mode = packetCoFHBase.getByte();
            this.lightValue = packetCoFHBase.getByte();
            this.isPowered = packetCoFHBase.getBool();
            this.inputPower = packetCoFHBase.getByte();
            this.setRenderColor();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.modified = nBTTagCompound.func_74767_n("Modified");
        this.mode = nBTTagCompound.func_74771_c("Mode");
        this.color = nBTTagCompound.func_74762_e("Color");
        this.isPowered = nBTTagCompound.func_74767_n("Powered");
        this.inputPower = nBTTagCompound.func_74771_c("Signal");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Modified", this.modified);
        nBTTagCompound.func_74774_a("Mode", this.mode);
        nBTTagCompound.func_74768_a("Color", this.color);
        nBTTagCompound.func_74757_a("Powered", this.isPowered);
        nBTTagCompound.func_74774_a("Signal", this.inputPower);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.mode = nBTTagCompound.func_74771_c("Mode");
        if (nBTTagCompound.func_74764_b("Color")) {
            this.setColor(nBTTagCompound.func_74762_e("Color"));
        }
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Mode", this.mode);
        if (this.modified) {
            nBTTagCompound.func_74768_a("Color", this.color);
        }
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            return;
        }
        list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)("chat.thermalexpansion.light." + this.mode))));
    }
}

